/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.client.direct;

import java.util.Optional;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.BasicAuthExtractor;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.util.CommonHelper;

public class DirectBasicAuthClient
extends DirectClient {
    private String realmName = "authentication required";

    public DirectBasicAuthClient() {
    }

    public DirectBasicAuthClient(Authenticator usernamePasswordAuthenticator) {
        this.defaultAuthenticator(usernamePasswordAuthenticator);
    }

    public DirectBasicAuthClient(Authenticator usernamePasswordAuthenticator, ProfileCreator profileCreator) {
        this.defaultAuthenticator(usernamePasswordAuthenticator);
        this.defaultProfileCreator(profileCreator);
    }

    protected void internalInit() {
        CommonHelper.assertNotBlank((String)"realmName", (String)this.realmName);
        this.defaultCredentialsExtractor((CredentialsExtractor)new BasicAuthExtractor());
    }

    protected Optional<Credentials> retrieveCredentials(WebContext context, SessionStore sessionStore) {
        this.addAuthenticateHeader(context);
        return super.retrieveCredentials(context, sessionStore);
    }

    protected void addAuthenticateHeader(WebContext context) {
        context.setResponseHeader("WWW-Authenticate", "Basic realm=\"" + this.realmName + "\"");
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    public String toString() {
        return CommonHelper.toNiceString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"name", this.getName(), "credentialsExtractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator(), "authorizationGenerators", this.getAuthorizationGenerators(), "realmName", this.realmName});
    }
}

