/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials.extractor;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.util.CommonHelper;

public class IpExtractor
implements CredentialsExtractor<TokenCredentials> {
    private final String clientName;
    private List<String> alternateIpHeaders = Collections.emptyList();
    private String proxyIp = "";

    public IpExtractor(String clientName) {
        this.clientName = clientName;
    }

    public IpExtractor(String clientName, String ... alternateIpHeaders) {
        this.clientName = clientName;
        this.alternateIpHeaders = Arrays.asList(alternateIpHeaders);
    }

    public TokenCredentials extract(WebContext context) throws HttpAction {
        String ip;
        if (this.alternateIpHeaders.isEmpty()) {
            ip = context.getRemoteAddr();
        } else {
            String requestSourceIp = context.getRemoteAddr();
            ip = this.proxyIp.isEmpty() ? this.ipFromHeaders(context) : (this.proxyIp.equals(requestSourceIp) ? this.ipFromHeaders(context) : null);
        }
        if (ip == null) {
            return null;
        }
        return new TokenCredentials(ip, this.clientName);
    }

    private String ipFromHeaders(WebContext context) {
        for (String header : this.alternateIpHeaders) {
            String ip = context.getRequestHeader(header);
            if (ip == null || ip.isEmpty()) continue;
            return ip;
        }
        return null;
    }

    @Deprecated
    public String getAlternateIpHeader() {
        return this.alternateIpHeaders.isEmpty() ? null : this.alternateIpHeaders.get(0);
    }

    @Deprecated
    public void setAlternateIpHeader(final String alternateIpHeader) {
        this.alternateIpHeaders = alternateIpHeader == null ? Collections.emptyList() : new LinkedList<String>(){
            {
                this.add(alternateIpHeader);
            }
        };
    }

    public String getProxyIp() {
        return this.proxyIp;
    }

    public void setProxyIp(String proxyIp) {
        this.proxyIp = proxyIp == null ? "" : proxyIp;
    }

    public List getAlternateIpHeaders() {
        return Collections.unmodifiableList(this.alternateIpHeaders);
    }

    public void setAlternateIpHeaders(String ... alternateIpHeaders) {
        CommonHelper.assertNotNull((String)"alternateIpHeaders", (Object)alternateIpHeaders);
        this.alternateIpHeaders = Arrays.asList(alternateIpHeaders);
    }

    public String toString() {
        return CommonHelper.toString(this.getClass(), (Object[])new Object[]{"clientName", this.clientName, "alternateIpHeaders", Arrays.asList(this.alternateIpHeaders)});
    }
}

