/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials.authenticator.test;

import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTestUsernamePasswordAuthenticator
implements Authenticator<UsernamePasswordCredentials> {
    protected static final Logger logger = LoggerFactory.getLogger(SimpleTestUsernamePasswordAuthenticator.class);

    public void validate(UsernamePasswordCredentials credentials, WebContext context) throws HttpAction {
        if (credentials == null) {
            this.throwsException("No credential");
        }
        String username = credentials.getUsername();
        String password = credentials.getPassword();
        if (CommonHelper.isBlank((String)username)) {
            this.throwsException("Username cannot be blank");
        }
        if (CommonHelper.isBlank((String)password)) {
            this.throwsException("Password cannot be blank");
        }
        if (CommonHelper.areNotEquals((String)username, (String)password)) {
            this.throwsException("Username : '" + username + "' does not match password");
        }
        CommonProfile profile = new CommonProfile();
        profile.setId((Object)username);
        profile.addAttribute("username", (Object)username);
        credentials.setUserProfile(profile);
    }

    protected void throwsException(String message) {
        throw new CredentialsException(message);
    }
}

