/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials.authenticator;

import java.util.regex.Pattern;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.http.profile.IpProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpRegexpAuthenticator
implements Authenticator<TokenCredentials> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String regexPattern;
    private Pattern pattern;

    public IpRegexpAuthenticator() {
    }

    public IpRegexpAuthenticator(String regexpPattern) {
        this.setRegexpPattern(regexpPattern);
    }

    public void validate(TokenCredentials credentials, WebContext context) throws HttpAction {
        CommonHelper.assertNotNull((String)"pattern", (Object)this.pattern);
        String ip = credentials.getToken();
        if (!this.pattern.matcher(ip).matches()) {
            throw new CredentialsException("Unauthorized IP address: " + ip);
        }
        IpProfile profile = new IpProfile(ip);
        this.logger.debug("profile: {}", (Object)profile);
        credentials.setUserProfile((CommonProfile)profile);
    }

    public void setRegexpPattern(String regexpPattern) {
        this.regexPattern = regexpPattern;
        this.pattern = Pattern.compile(regexpPattern);
    }

    public String toString() {
        return "IpRegexpAuthenticator[" + this.regexPattern + "]";
    }
}

