/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.client.indirect;

import org.pac4j.core.client.IndirectClientV2;
import org.pac4j.core.client.RedirectAction;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.credentials.extractor.FormExtractor;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.util.CommonHelper;

public class FormClient
extends IndirectClientV2<UsernamePasswordCredentials, CommonProfile> {
    private String loginUrl;
    public static final String ERROR_PARAMETER = "error";
    public static final String MISSING_FIELD_ERROR = "missing_field";
    private String usernameParameter = "username";
    private String passwordParameter = "password";

    public FormClient() {
    }

    public FormClient(String loginUrl, Authenticator usernamePasswordAuthenticator) {
        this.loginUrl = loginUrl;
        this.setAuthenticator(usernamePasswordAuthenticator);
    }

    public FormClient(String loginUrl, String usernameParameter, String passwordParameter, Authenticator usernamePasswordAuthenticator) {
        this.loginUrl = loginUrl;
        this.usernameParameter = usernameParameter;
        this.passwordParameter = passwordParameter;
        this.setAuthenticator(usernamePasswordAuthenticator);
    }

    public FormClient(String loginUrl, Authenticator usernamePasswordAuthenticator, ProfileCreator profileCreator) {
        this.loginUrl = loginUrl;
        this.setAuthenticator(usernamePasswordAuthenticator);
        this.setProfileCreator(profileCreator);
    }

    protected void internalInit(WebContext context) {
        super.internalInit(context);
        CommonHelper.assertNotBlank((String)"loginUrl", (String)this.loginUrl);
        this.loginUrl = this.callbackUrlResolver.compute(this.loginUrl, context);
        CommonHelper.assertNotBlank((String)"usernameParameter", (String)this.usernameParameter);
        CommonHelper.assertNotBlank((String)"passwordParameter", (String)this.passwordParameter);
        this.setRedirectActionBuilder(webContext -> RedirectAction.redirect((String)this.loginUrl));
        this.setCredentialsExtractor((CredentialsExtractor)new FormExtractor(this.usernameParameter, this.passwordParameter, this.getName()));
    }

    protected UsernamePasswordCredentials retrieveCredentials(WebContext context) throws HttpAction {
        UsernamePasswordCredentials credentials;
        CommonHelper.assertNotNull((String)"credentialsExtractor", (Object)this.getCredentialsExtractor());
        CommonHelper.assertNotNull((String)"authenticator", (Object)this.getAuthenticator());
        String username = context.getRequestParameter(this.usernameParameter);
        try {
            credentials = (UsernamePasswordCredentials)this.getCredentialsExtractor().extract(context);
            this.logger.debug("usernamePasswordCredentials: {}", (Object)credentials);
            if (credentials == null) {
                throw this.handleInvalidCredentials(context, username, "Username and password cannot be blank -> return to the form with error", MISSING_FIELD_ERROR, 401);
            }
            this.getAuthenticator().validate((Credentials)credentials, context);
        }
        catch (CredentialsException e) {
            throw this.handleInvalidCredentials(context, username, "Credentials validation fails -> return to the form with error", this.computeErrorMessage((TechnicalException)e), 403);
        }
        return credentials;
    }

    private HttpAction handleInvalidCredentials(WebContext context, String username, String message, String errorMessage, int errorCode) throws HttpAction {
        if (this.getAjaxRequestResolver().isAjax(context)) {
            this.logger.info("AJAX request detected -> returning " + errorCode);
            return HttpAction.status((String)("AJAX request -> " + errorCode), (int)errorCode, (WebContext)context);
        }
        String redirectionUrl = CommonHelper.addParameter((String)this.loginUrl, (String)this.usernameParameter, (String)username);
        redirectionUrl = CommonHelper.addParameter((String)redirectionUrl, (String)ERROR_PARAMETER, (String)errorMessage);
        this.logger.debug("redirectionUrl: {}", (Object)redirectionUrl);
        this.logger.debug(message);
        return HttpAction.redirect((String)message, (WebContext)context, (String)redirectionUrl);
    }

    protected String computeErrorMessage(TechnicalException e) {
        return e.getClass().getSimpleName();
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public String getUsernameParameter() {
        return this.usernameParameter;
    }

    public void setUsernameParameter(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    public String getPasswordParameter() {
        return this.passwordParameter;
    }

    public void setPasswordParameter(String passwordParameter) {
        this.passwordParameter = passwordParameter;
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"callbackUrl", this.callbackUrl, "name", this.getName(), "loginUrl", this.loginUrl, "usernameParameter", this.usernameParameter, "passwordParameter", this.passwordParameter, "redirectActionBuilder", this.getRedirectActionBuilder(), "extractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator()});
    }
}

