/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials;

import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.http.credentials.UsernamePasswordAuthenticator;
import org.pac4j.http.credentials.UsernamePasswordCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTestUsernamePasswordAuthenticator
implements UsernamePasswordAuthenticator {
    protected static final Logger logger = LoggerFactory.getLogger(SimpleTestUsernamePasswordAuthenticator.class);

    @Override
    public void validate(UsernamePasswordCredentials credentials) {
        if (credentials == null) {
            this.throwsException("No credential");
        }
        String username = credentials.getUsername();
        String password = credentials.getPassword();
        if (CommonHelper.isBlank((String)username)) {
            this.throwsException("Username cannot be blank");
        }
        if (CommonHelper.isBlank((String)password)) {
            this.throwsException("Password cannot be blank");
        }
        if (CommonHelper.areNotEquals((String)username, (String)password)) {
            this.throwsException("Username : '" + username + "' does not match password");
        }
    }

    protected void throwsException(String message) {
        logger.error(message);
        throw new CredentialsException(message);
    }
}

