/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.client;

import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.pac4j.core.client.Mechanism;
import org.pac4j.core.client.RedirectAction;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.http.client.AbstractHeaderClient;
import org.pac4j.http.credentials.UsernamePasswordAuthenticator;
import org.pac4j.http.credentials.UsernamePasswordCredentials;
import org.pac4j.http.profile.UsernameProfileCreator;

public class BasicAuthClient
extends AbstractHeaderClient<UsernamePasswordCredentials> {
    public BasicAuthClient() {
        this((UsernamePasswordAuthenticator)null, (UsernameProfileCreator)null);
    }

    public BasicAuthClient(UsernamePasswordAuthenticator usernamePasswordAuthenticator) {
        this(usernamePasswordAuthenticator, (UsernameProfileCreator)null);
    }

    public BasicAuthClient(UsernamePasswordAuthenticator usernamePasswordAuthenticator, UsernameProfileCreator profilePopulator) {
        this.setRealmName("authentication required");
        this.setHeaderName("Authorization");
        this.setPrefixHeader("Basic ");
        this.setAuthenticator(usernamePasswordAuthenticator);
        this.setProfileCreator(profilePopulator);
    }

    @Override
    protected void internalInit() {
        super.internalInit();
        CommonHelper.assertNotBlank((String)"callbackUrl", (String)this.callbackUrl);
        CommonHelper.assertNotBlank((String)"realmName", (String)this.getRealmName());
    }

    protected BasicAuthClient newClient() {
        BasicAuthClient newClient = new BasicAuthClient();
        newClient.setRealmName(this.getRealmName());
        newClient.setHeaderName(this.getHeaderName());
        newClient.setPrefixHeader(this.getPrefixHeader());
        return newClient;
    }

    @Override
    protected RedirectAction retrieveRedirectAction(WebContext context) {
        return RedirectAction.redirect((String)this.getContextualCallbackUrl(context));
    }

    @Override
    protected UsernamePasswordCredentials retrieveCredentialsFromHeader(String header) {
        String token;
        byte[] decoded = Base64.decodeBase64((String)header);
        try {
            token = new String(decoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new CredentialsException("Bad format of the basic auth header");
        }
        int delim = token.indexOf(":");
        if (delim < 0) {
            throw new CredentialsException("Bad format of the basic auth header");
        }
        return new UsernamePasswordCredentials(token.substring(0, delim), token.substring(delim + 1), this.getName());
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"callbackUrl", this.callbackUrl, "name", this.getName(), "realmName", this.getRealmName(), "headerName", this.getHeaderName(), "prefixHeader", this.getPrefixHeader(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator()});
    }

    public Mechanism getMechanism() {
        return Mechanism.BASICAUTH_MECHANISM;
    }
}

