/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.client;

import org.pac4j.core.client.RedirectAction;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Authenticator;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.RequiresHttpAction;
import org.pac4j.core.profile.ProfileCreator;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.http.client.BaseHttpClient;
import org.pac4j.http.profile.HttpProfile;

public abstract class AbstractHeaderClient<C extends Credentials>
extends BaseHttpClient<C> {
    private String headerName;
    private String prefixHeader;
    private String realmName;

    public AbstractHeaderClient() {
    }

    public AbstractHeaderClient(Authenticator<C> authenticator) {
        this.setAuthenticator(authenticator);
    }

    public AbstractHeaderClient(Authenticator<C> authenticator, ProfileCreator<C, HttpProfile> profilePopulator) {
        this.setAuthenticator(authenticator);
        this.setProfileCreator(profilePopulator);
    }

    @Override
    protected void internalInit() {
        super.internalInit();
        CommonHelper.assertNotBlank((String)"headerName", (String)this.headerName);
        CommonHelper.assertNotBlank((String)"prefixHeader", (String)this.prefixHeader);
    }

    protected RedirectAction retrieveRedirectAction(WebContext context) {
        return RedirectAction.redirect((String)this.getContextualCallbackUrl(context));
    }

    protected C retrieveCredentials(WebContext context) throws RequiresHttpAction {
        String header = context.getRequestHeader(this.headerName);
        if (header == null || !header.startsWith(this.prefixHeader)) {
            logger.warn("No header found");
            throw RequiresHttpAction.unauthorized((String)"Requires authentication (no header found)", (WebContext)context, (String)this.realmName);
        }
        C credentials = this.retrieveCredentialsFromHeader(header.substring(this.prefixHeader.length()));
        logger.debug("credentials : {}", credentials);
        try {
            this.getAuthenticator().validate(credentials);
        }
        catch (RuntimeException e) {
            logger.error("Credentials validation fails", (Throwable)e);
            throw RequiresHttpAction.unauthorized((String)"Requires authentication (credentials validation fails)", (WebContext)context, (String)this.realmName);
        }
        return credentials;
    }

    protected abstract C retrieveCredentialsFromHeader(String var1);

    protected boolean isDirectRedirection() {
        return true;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public String getPrefixHeader() {
        return this.prefixHeader;
    }

    public void setPrefixHeader(String prefixHeader) {
        this.prefixHeader = prefixHeader;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }
}

