/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InitializableObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(InitializableObject.class);
    private volatile boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (!this.initialized) {
            InitializableObject initializableObject = this;
            synchronized (initializableObject) {
                if (!this.initialized) {
                    LOGGER.debug("Initializing: {}", (Object)this.getClass().getSimpleName());
                    this.beforeInternalInit();
                    this.internalInit();
                    this.afterInternalInit();
                    this.initialized = true;
                }
            }
        }
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    protected abstract void internalInit();

    protected void beforeInternalInit() {
    }

    protected void afterInternalInit() {
    }
}

