/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.logout.handler;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.logout.handler.LogoutHandler;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.factory.ProfileManagerFactory2Aware;
import org.pac4j.core.store.GuavaStore;
import org.pac4j.core.store.Store;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLogoutHandler<C extends WebContext>
extends ProfileManagerFactory2Aware<C>
implements LogoutHandler<C> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Store<String, Object> store = new GuavaStore<String, Object>(10000, 30, TimeUnit.MINUTES);
    private boolean destroySession;

    public DefaultLogoutHandler() {
    }

    public DefaultLogoutHandler(Store<String, Object> store) {
        this.store = store;
    }

    @Override
    public void recordSession(C context, String key) {
        SessionStore sessionStore = context.getSessionStore();
        if (sessionStore == null) {
            this.logger.error("No session store available for this web context");
        } else {
            String sessionId = sessionStore.getOrCreateSessionId(context);
            Optional trackableSession = sessionStore.getTrackableSession(context);
            if (trackableSession != null) {
                this.logger.debug("key: {} -> trackableSession: {}", (Object)key, (Object)trackableSession);
                this.logger.debug("sessionId: {}", (Object)sessionId);
                this.store.set(key, trackableSession);
                this.store.set(sessionId, key);
            } else {
                this.logger.debug("No trackable session for the current session store: {}", (Object)sessionStore);
            }
        }
    }

    @Override
    public void destroySessionFront(C context, String key) {
        this.store.remove(key);
        SessionStore sessionStore = context.getSessionStore();
        if (sessionStore == null) {
            this.logger.error("No session store available for this web context");
        } else {
            String currentSessionId = sessionStore.getOrCreateSessionId(context);
            this.logger.debug("currentSessionId: {}", (Object)currentSessionId);
            String sessionToKey = this.store.get(currentSessionId).orElse(null);
            this.logger.debug("-> key: {}", (Object)key);
            this.store.remove(currentSessionId);
            if (CommonHelper.areEquals(key, sessionToKey)) {
                this.destroy(context, sessionStore, "front");
            } else {
                this.logger.error("The user profiles (and session) can not be destroyed for the front channel logout because the provided key is not the same as the one linked to the current session");
            }
        }
    }

    protected void destroy(C context, SessionStore sessionStore, String channel) {
        ProfileManager manager = this.getProfileManager(context, sessionStore);
        manager.logout();
        this.logger.debug("destroy the user profiles");
        if (this.destroySession) {
            this.logger.debug("destroy the whole session");
            boolean invalidated = sessionStore.destroySession(context);
            if (!invalidated) {
                this.logger.error("The session has not been invalidated for {} channel logout", (Object)channel);
            }
        }
    }

    @Override
    public void destroySessionBack(C context, String key) {
        Optional<Object> trackableSession = this.store.get(key);
        this.logger.debug("key: {} -> trackableSession: {}", (Object)key, trackableSession);
        if (!trackableSession.isPresent()) {
            this.logger.error("No trackable session found for back channel logout. Either the session store does not support to track session or it has expired from the store and the store settings must be updated (expired data)");
        } else {
            this.store.remove(key);
            SessionStore sessionStore = context.getSessionStore();
            if (sessionStore == null) {
                this.logger.error("No session store available for this web context");
            } else {
                Optional<SessionStore<C>> newSessionStore = sessionStore.buildFromTrackableSession(context, ((Optional)trackableSession.get()).orElse(null));
                if (newSessionStore.isPresent()) {
                    this.logger.debug("newSesionStore: {}", newSessionStore);
                    String sessionId = newSessionStore.get().getOrCreateSessionId(context);
                    this.logger.debug("remove sessionId: {}", (Object)sessionId);
                    this.store.remove(sessionId);
                    this.destroy(context, newSessionStore.get(), "back");
                } else {
                    this.logger.error("The session store should be able to build a new session store from the tracked session");
                }
            }
        }
    }

    @Override
    public void renewSession(String oldSessionId, C context) {
        Optional<Object> optKey = this.store.get(oldSessionId);
        this.logger.debug("oldSessionId: {} -> key: {}", (Object)oldSessionId, optKey);
        if (optKey.isPresent()) {
            String key = (String)optKey.get();
            this.store.remove(key);
            this.store.remove(oldSessionId);
            this.recordSession(context, key);
        }
    }

    public Store<String, Object> getStore() {
        return this.store;
    }

    public void setStore(Store<String, Object> store) {
        this.store = store;
    }

    public boolean isDestroySession() {
        return this.destroySession;
    }

    public void setDestroySession(boolean destroySession) {
        this.destroySession = destroySession;
    }

    public String toString() {
        return CommonHelper.toNiceString(this.getClass(), "store", this.store, "destroySession", this.destroySession);
    }
}

