/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.profile.factory;

import java.util.function.Function;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.util.CommonHelper;

public class ProfileManagerFactoryAware<C extends WebContext> {
    private static final Function<WebContext, ProfileManager> DEFAULT_PROFILE_MANAGER_FACTORY = webContext -> new ProfileManager((WebContext)webContext);
    private Function<C, ProfileManager> profileManagerFactory;

    protected ProfileManager getProfileManager(C context) {
        if (this.profileManagerFactory != null) {
            return this.profileManagerFactory.apply(context);
        }
        if (Config.getProfileManagerFactory() != null) {
            return Config.getProfileManagerFactory().apply((WebContext)context);
        }
        return DEFAULT_PROFILE_MANAGER_FACTORY.apply((WebContext)context);
    }

    public Function<C, ProfileManager> getProfileManagerFactory() {
        return this.profileManagerFactory;
    }

    public void setProfileManagerFactory(Function<C, ProfileManager> factory) {
        CommonHelper.assertNotNull("factory", factory);
        this.profileManagerFactory = factory;
    }
}

