/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.profile.factory;

import java.util.function.BiFunction;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.util.CommonHelper;

public class ProfileManagerFactory2Aware<C extends WebContext> {
    private static final BiFunction<WebContext, SessionStore<WebContext>, ProfileManager> DEFAULT_PROFILE_MANAGER_FACTORY2 = (webContext, sessionStore) -> new ProfileManager((WebContext)webContext, (SessionStore)sessionStore);
    private BiFunction<C, SessionStore<C>, ProfileManager> profileManagerFactory2;

    protected ProfileManager getProfileManager(C context, SessionStore<C> sessionStore) {
        if (this.profileManagerFactory2 != null) {
            return this.profileManagerFactory2.apply(context, sessionStore);
        }
        if (Config.getProfileManagerFactory2() != null) {
            return Config.getProfileManagerFactory2().apply((WebContext)context, sessionStore);
        }
        return DEFAULT_PROFILE_MANAGER_FACTORY2.apply((WebContext)context, (SessionStore<WebContext>)sessionStore);
    }

    public BiFunction<C, SessionStore<C>, ProfileManager> getProfileManagerFactory2() {
        return this.profileManagerFactory2;
    }

    public void setProfileManagerFactory2(BiFunction<C, SessionStore<C>, ProfileManager> factory) {
        CommonHelper.assertNotNull("factory", factory);
        this.profileManagerFactory2 = factory;
    }
}

