/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.profile;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.pac4j.core.authorization.authorizer.Authorizer;
import org.pac4j.core.authorization.authorizer.IsAuthenticatedAuthorizer;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;

public class ProfileManager<U extends UserProfile> {
    private final Authorizer<U> IS_AUTHENTICATED_AUTHORIZER = new IsAuthenticatedAuthorizer();
    protected final WebContext context;
    protected final SessionStore sessionStore;

    public ProfileManager(WebContext context) {
        CommonHelper.assertNotNull("context", context);
        this.context = context;
        this.sessionStore = context.getSessionStore();
    }

    public ProfileManager(WebContext context, SessionStore sessionStore) {
        CommonHelper.assertNotNull("context", context);
        CommonHelper.assertNotNull("sessionStore", sessionStore);
        this.context = context;
        this.sessionStore = sessionStore;
    }

    public Optional<U> get(boolean readFromSession) {
        LinkedHashMap<String, U> allProfiles = this.retrieveAll(readFromSession);
        return ProfileHelper.flatIntoOneProfile(allProfiles.values());
    }

    public List<U> getAll(boolean readFromSession) {
        LinkedHashMap<String, U> profiles = this.retrieveAll(readFromSession);
        return ProfileHelper.flatIntoAProfileList(profiles);
    }

    protected LinkedHashMap<String, U> retrieveAll(boolean readFromSession) {
        LinkedHashMap profiles = new LinkedHashMap();
        this.context.getRequestAttribute("pac4jUserProfiles").ifPresent(request -> {
            if (request instanceof LinkedHashMap) {
                profiles.putAll((LinkedHashMap)request);
            }
            if (request instanceof CommonProfile) {
                profiles.put(this.retrieveClientName((UserProfile)request), (UserProfile)request);
            }
        });
        if (readFromSession) {
            this.sessionStore.get(this.context, "pac4jUserProfiles").ifPresent(sessionAttribute -> {
                if (sessionAttribute instanceof LinkedHashMap) {
                    profiles.putAll((LinkedHashMap)sessionAttribute);
                }
                if (sessionAttribute instanceof CommonProfile) {
                    profiles.put(this.retrieveClientName((UserProfile)sessionAttribute), (UserProfile)sessionAttribute);
                }
            });
        }
        this.removeExpiredProfiles(profiles);
        return profiles;
    }

    private void removeExpiredProfiles(LinkedHashMap<String, U> profiles) {
        Iterator<Map.Entry<String, U>> profileIterator = profiles.entrySet().iterator();
        while (profileIterator.hasNext()) {
            Map.Entry<String, U> entry = profileIterator.next();
            if (!((UserProfile)entry.getValue()).isExpired()) continue;
            profileIterator.remove();
        }
    }

    public void remove(boolean removeFromSession) {
        if (removeFromSession) {
            this.sessionStore.set(this.context, "pac4jUserProfiles", new LinkedHashMap());
        }
        this.context.setRequestAttribute("pac4jUserProfiles", new LinkedHashMap());
    }

    public void save(boolean saveInSession, U profile, boolean multiProfile) {
        LinkedHashMap<String, Object> profiles;
        String clientName = this.retrieveClientName(profile);
        if (multiProfile) {
            profiles = this.retrieveAll(saveInSession);
            profiles.remove(clientName);
        } else {
            profiles = new LinkedHashMap();
        }
        profiles.put(clientName, profile);
        if (saveInSession) {
            this.sessionStore.set(this.context, "pac4jUserProfiles", profiles);
        }
        this.context.setRequestAttribute("pac4jUserProfiles", profiles);
    }

    protected String retrieveClientName(U profile) {
        String clientName = profile.getClientName();
        if (clientName == null) {
            clientName = "DEFAULT";
        }
        return clientName;
    }

    public void logout() {
        this.remove(true);
    }

    public boolean isAuthenticated() {
        try {
            return this.IS_AUTHENTICATED_AUTHORIZER.isAuthorized(null, this.getAll(true));
        }
        catch (HttpAction e) {
            throw new TechnicalException(e);
        }
    }
}

