/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.engine.savedrequest;

import java.util.Optional;
import org.pac4j.core.context.ContextHelper;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.engine.savedrequest.SavedRequestHandler;
import org.pac4j.core.exception.http.FoundAction;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.exception.http.OkAction;
import org.pac4j.core.exception.http.RedirectionActionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSavedRequestHandler
implements SavedRequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSavedRequestHandler.class);

    @Override
    public void save(WebContext context) {
        String requestedUrl = context.getFullRequestURL();
        if (ContextHelper.isPost(context)) {
            LOGGER.debug("requestedUrl with data: {}", (Object)requestedUrl);
            String formPost = RedirectionActionHelper.buildFormPostContent(context);
            context.getSessionStore().set(context, "pac4jRequestedUrl", new OkAction(formPost));
        } else {
            LOGGER.debug("requestedUrl: {}", (Object)requestedUrl);
            context.getSessionStore().set(context, "pac4jRequestedUrl", new FoundAction(requestedUrl));
        }
    }

    @Override
    public HttpAction restore(WebContext context, String defaultUrl) {
        Optional<Object> optRequestedUrl = context.getSessionStore().get(context, "pac4jRequestedUrl");
        Throwable requestedAction = null;
        if (optRequestedUrl.isPresent()) {
            context.getSessionStore().set(context, "pac4jRequestedUrl", "");
            Object requestedUrl = optRequestedUrl.get();
            if (requestedUrl instanceof String && !"".equals(requestedUrl)) {
                requestedAction = new FoundAction((String)requestedUrl);
            } else if (requestedUrl instanceof FoundAction) {
                requestedAction = (FoundAction)requestedUrl;
            } else if (requestedUrl instanceof OkAction) {
                requestedAction = (OkAction)requestedUrl;
            }
        }
        if (requestedAction == null) {
            requestedAction = new FoundAction(defaultUrl);
        }
        LOGGER.debug("requestedAction: {}", (Object)requestedAction.getMessage());
        if (requestedAction instanceof FoundAction) {
            return RedirectionActionHelper.buildRedirectUrlAction(context, ((FoundAction)requestedAction).getLocation());
        }
        return RedirectionActionHelper.buildFormPostContentAction(context, ((OkAction)requestedAction).getContent());
    }
}

