/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.engine;

import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.exception.http.RedirectionActionHelper;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.profile.factory.ProfileManagerFactoryAware;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExceptionAwareLogic<R, C extends WebContext>
extends ProfileManagerFactoryAware<C> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private String errorUrl;

    protected R handleException(Exception e, HttpActionAdapter<R, C> httpActionAdapter, C context) {
        if (httpActionAdapter == null || context == null) {
            throw this.runtimeException(e);
        }
        if (e instanceof HttpAction) {
            HttpAction action = (HttpAction)e;
            this.logger.debug("extra HTTP action required in security: {}", (Object)action.getCode());
            return httpActionAdapter.adapt(action, context);
        }
        if (CommonHelper.isNotBlank(this.errorUrl)) {
            RedirectionAction action = RedirectionActionHelper.buildRedirectUrlAction(context, this.errorUrl);
            return httpActionAdapter.adapt(action, context);
        }
        throw this.runtimeException(e);
    }

    protected RuntimeException runtimeException(Exception exception) {
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(exception);
    }

    public String getErrorUrl() {
        return this.errorUrl;
    }

    public void setErrorUrl(String errorUrl) {
        this.errorUrl = errorUrl;
    }
}

