/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.context.session;

import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.session.JEEProvidedSessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JEESessionStore
implements SessionStore<JEEContext> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected HttpSession getHttpSession(JEEContext context) {
        return context.getNativeRequest().getSession();
    }

    @Override
    public String getOrCreateSessionId(JEEContext context) {
        return this.getHttpSession(context).getId();
    }

    @Override
    public Optional get(JEEContext context, String key) {
        return Optional.ofNullable(this.getHttpSession(context).getAttribute(key));
    }

    @Override
    public void set(JEEContext context, String key, Object value) {
        if (value == null) {
            this.getHttpSession(context).removeAttribute(key);
        } else {
            this.getHttpSession(context).setAttribute(key, value);
        }
    }

    @Override
    public boolean destroySession(JEEContext context) {
        this.getHttpSession(context).invalidate();
        return true;
    }

    @Override
    public Optional getTrackableSession(JEEContext context) {
        return Optional.ofNullable(this.getHttpSession(context));
    }

    @Override
    public Optional<SessionStore<JEEContext>> buildFromTrackableSession(JEEContext context, Object trackableSession) {
        if (trackableSession != null) {
            return Optional.of(new JEEProvidedSessionStore((HttpSession)trackableSession));
        }
        return Optional.empty();
    }

    @Override
    public boolean renewSession(JEEContext context) {
        HttpServletRequest request = context.getNativeRequest();
        HttpSession session = request.getSession();
        this.logger.debug("Discard old session: {}", (Object)session.getId());
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Collections.list(session.getAttributeNames()).forEach(k -> attributes.put((String)k, session.getAttribute(k)));
        session.invalidate();
        HttpSession newSession = request.getSession(true);
        this.logger.debug("And copy all data to the new one: {}", (Object)newSession.getId());
        attributes.forEach((k, v) -> newSession.setAttribute(k, v));
        return true;
    }
}

