/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.pac4j.core.authorization.authorizer.Authorizer;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.CallbackLogic;
import org.pac4j.core.engine.LogoutLogic;
import org.pac4j.core.engine.SecurityLogic;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.matching.Matcher;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger LOGGER = LoggerFactory.getLogger(Config.class);
    private static Function<WebContext, ProfileManager> profileManagerFactory;
    private static BiFunction<WebContext, SessionStore, ProfileManager> profileManagerFactory2;
    protected Clients clients;
    protected Map<String, Authorizer> authorizers = new HashMap<String, Authorizer>();
    protected Map<String, Matcher> matchers = new HashMap<String, Matcher>();
    protected SessionStore sessionStore;
    protected HttpActionAdapter httpActionAdapter;
    protected SecurityLogic securityLogic;
    protected CallbackLogic callbackLogic;
    protected LogoutLogic logoutLogic;

    public Config() {
    }

    public Config(Client client) {
        this.clients = new Clients(client);
    }

    public Config(Clients clients) {
        this.clients = clients;
    }

    public Config(List<Client> clients) {
        this.clients = new Clients(clients);
    }

    public Config(Client ... clients) {
        this.clients = new Clients(clients);
    }

    public Config(String callbackUrl, Client client) {
        this.clients = new Clients(callbackUrl, client);
    }

    public Config(String callbackUrl, Client ... clients) {
        this.clients = new Clients(callbackUrl, clients);
    }

    public Config(String callbackUrl, List<Client> clients) {
        this.clients = new Clients(callbackUrl, clients);
    }

    public Config(Map<String, Authorizer> authorizers) {
        this.setAuthorizers(authorizers);
    }

    public Config(Clients clients, Map<String, Authorizer> authorizers) {
        this.clients = clients;
        this.setAuthorizers(authorizers);
    }

    public Config(Client client, Map<String, Authorizer> authorizers) {
        this.clients = new Clients(client);
        this.setAuthorizers(authorizers);
    }

    public Config(Map<String, Authorizer> authorizers, Client ... clients) {
        this.clients = new Clients(clients);
        this.setAuthorizers(authorizers);
    }

    public Config(String callbackUrl, Map<String, Authorizer> authorizers, Client ... clients) {
        this.clients = new Clients(callbackUrl, clients);
        this.setAuthorizers(authorizers);
    }

    public Config(String callbackUrl, Client client, Map<String, Authorizer> authorizers) {
        this.clients = new Clients(callbackUrl, client);
        this.setAuthorizers(authorizers);
    }

    public Clients getClients() {
        return this.clients;
    }

    public void setClients(Clients clients) {
        this.clients = clients;
    }

    public Map<String, Authorizer> getAuthorizers() {
        return this.authorizers;
    }

    public void setAuthorizer(Authorizer authorizer) {
        CommonHelper.assertNotNull("authorizer", authorizer);
        this.authorizers.put(authorizer.getClass().getSimpleName(), authorizer);
    }

    public void setAuthorizers(Map<String, Authorizer> authorizers) {
        CommonHelper.assertNotNull("authorizers", authorizers);
        this.authorizers = authorizers;
    }

    public void addAuthorizer(String name, Authorizer authorizer) {
        this.authorizers.put(name, authorizer);
    }

    public Map<String, Matcher> getMatchers() {
        return this.matchers;
    }

    public void setMatcher(Matcher matcher) {
        CommonHelper.assertNotNull("matcher", matcher);
        this.matchers.put(matcher.getClass().getSimpleName(), matcher);
    }

    public void setMatchers(Map<String, Matcher> matchers) {
        CommonHelper.assertNotNull("matchers", matchers);
        this.matchers = matchers;
    }

    public void addMatcher(String name, Matcher matcher) {
        this.matchers.put(name, matcher);
    }

    public SessionStore getSessionStore() {
        return this.sessionStore;
    }

    public void setSessionStore(SessionStore sessionStore) {
        this.sessionStore = sessionStore;
    }

    public HttpActionAdapter getHttpActionAdapter() {
        return this.httpActionAdapter;
    }

    public void setHttpActionAdapter(HttpActionAdapter httpActionAdapter) {
        this.httpActionAdapter = httpActionAdapter;
    }

    public SecurityLogic getSecurityLogic() {
        return this.securityLogic;
    }

    public void setSecurityLogic(SecurityLogic securityLogic) {
        this.securityLogic = securityLogic;
    }

    public CallbackLogic getCallbackLogic() {
        return this.callbackLogic;
    }

    public void setCallbackLogic(CallbackLogic callbackLogic) {
        this.callbackLogic = callbackLogic;
    }

    public LogoutLogic getLogoutLogic() {
        return this.logoutLogic;
    }

    public void setLogoutLogic(LogoutLogic logoutLogic) {
        this.logoutLogic = logoutLogic;
    }

    public static Function<WebContext, ProfileManager> getProfileManagerFactory() {
        return profileManagerFactory;
    }

    public static void setProfileManagerFactory(String name, Function<WebContext, ProfileManager> profileManagerFactory) {
        CommonHelper.assertNotNull("profileManagerFactory", profileManagerFactory);
        LOGGER.info("Setting Config.profileManagerFactory: {}", (Object)name);
        Config.profileManagerFactory = profileManagerFactory;
    }

    public static void defaultProfileManagerFactory(String name, Function<WebContext, ProfileManager> profileManagerFactory) {
        if (Config.profileManagerFactory == null) {
            Config.setProfileManagerFactory(name, profileManagerFactory);
        }
    }

    public static BiFunction<WebContext, SessionStore, ProfileManager> getProfileManagerFactory2() {
        return profileManagerFactory2;
    }

    public static void setProfileManagerFactory2(String name, BiFunction<WebContext, SessionStore, ProfileManager> profileManagerFactory2) {
        CommonHelper.assertNotNull("profileManagerFactory2", profileManagerFactory2);
        LOGGER.info("Setting Config.profileManagerFactory2: {}", (Object)name);
        Config.profileManagerFactory2 = profileManagerFactory2;
    }

    public static void defaultProfileManagerFactory2(String name, BiFunction<WebContext, SessionStore, ProfileManager> profileManagerFactory2) {
        if (Config.profileManagerFactory2 == null) {
            Config.setProfileManagerFactory2(name, profileManagerFactory2);
        }
    }
}

