/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.authorization.checker;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.pac4j.core.authorization.authorizer.Authorizer;
import org.pac4j.core.authorization.authorizer.CacheControlHeader;
import org.pac4j.core.authorization.authorizer.CorsAuthorizer;
import org.pac4j.core.authorization.authorizer.IsAnonymousAuthorizer;
import org.pac4j.core.authorization.authorizer.IsAuthenticatedAuthorizer;
import org.pac4j.core.authorization.authorizer.IsFullyAuthenticatedAuthorizer;
import org.pac4j.core.authorization.authorizer.IsRememberedAuthorizer;
import org.pac4j.core.authorization.authorizer.StrictTransportSecurityHeader;
import org.pac4j.core.authorization.authorizer.XContentTypeOptionsHeader;
import org.pac4j.core.authorization.authorizer.XFrameOptionsHeader;
import org.pac4j.core.authorization.authorizer.XSSProtectionHeader;
import org.pac4j.core.authorization.authorizer.csrf.CsrfAuthorizer;
import org.pac4j.core.authorization.authorizer.csrf.CsrfTokenGeneratorAuthorizer;
import org.pac4j.core.authorization.authorizer.csrf.DefaultCsrfTokenGenerator;
import org.pac4j.core.authorization.checker.AuthorizationChecker;
import org.pac4j.core.context.HttpConstants;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthorizationChecker
implements AuthorizationChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAuthorizationChecker.class);
    static final StrictTransportSecurityHeader STRICT_TRANSPORT_SECURITY_HEADER = new StrictTransportSecurityHeader();
    static final XContentTypeOptionsHeader X_CONTENT_TYPE_OPTIONS_HEADER = new XContentTypeOptionsHeader();
    static final XFrameOptionsHeader X_FRAME_OPTIONS_HEADER = new XFrameOptionsHeader();
    static final XSSProtectionHeader XSS_PROTECTION_HEADER = new XSSProtectionHeader();
    static final CacheControlHeader CACHE_CONTROL_HEADER = new CacheControlHeader();
    static final CsrfAuthorizer CSRF_AUTHORIZER = new CsrfAuthorizer();
    static final CsrfTokenGeneratorAuthorizer CSRF_TOKEN_GENERATOR_AUTHORIZER = new CsrfTokenGeneratorAuthorizer(new DefaultCsrfTokenGenerator());
    static final CorsAuthorizer CORS_AUTHORIZER = new CorsAuthorizer();
    static final IsAnonymousAuthorizer IS_ANONYMOUS_AUTHORIZER = new IsAnonymousAuthorizer();
    static final IsAuthenticatedAuthorizer IS_AUTHENTICATED_AUTHORIZER = new IsAuthenticatedAuthorizer();
    static final IsFullyAuthenticatedAuthorizer IS_FULLY_AUTHENTICATED_AUTHORIZER = new IsFullyAuthenticatedAuthorizer();
    static final IsRememberedAuthorizer IS_REMEMBERED_AUTHORIZER = new IsRememberedAuthorizer();

    @Override
    public boolean isAuthorized(WebContext context, List<UserProfile> profiles, String authorizersValue, Map<String, Authorizer> authorizersMap) {
        ArrayList<Authorizer> authorizers = new ArrayList<Authorizer>();
        String authorizerNames = authorizersValue;
        if (authorizerNames == null) {
            authorizerNames = "csrf,securityheaders";
        }
        if (CommonHelper.isNotBlank(authorizerNames)) {
            String[] names = authorizerNames.split(",");
            int nb = names.length;
            for (int i = 0; i < nb; ++i) {
                String name = names[i].trim();
                if ("hsts".equalsIgnoreCase(name)) {
                    authorizers.add(STRICT_TRANSPORT_SECURITY_HEADER);
                    continue;
                }
                if ("nosniff".equalsIgnoreCase(name)) {
                    authorizers.add(X_CONTENT_TYPE_OPTIONS_HEADER);
                    continue;
                }
                if ("noframe".equalsIgnoreCase(name)) {
                    authorizers.add(X_FRAME_OPTIONS_HEADER);
                    continue;
                }
                if ("xssprotection".equalsIgnoreCase(name)) {
                    authorizers.add(XSS_PROTECTION_HEADER);
                    continue;
                }
                if ("nocache".equalsIgnoreCase(name)) {
                    authorizers.add(CACHE_CONTROL_HEADER);
                    continue;
                }
                if ("securityheaders".equalsIgnoreCase(name)) {
                    authorizers.add(CACHE_CONTROL_HEADER);
                    authorizers.add(X_CONTENT_TYPE_OPTIONS_HEADER);
                    authorizers.add(STRICT_TRANSPORT_SECURITY_HEADER);
                    authorizers.add(X_FRAME_OPTIONS_HEADER);
                    authorizers.add(XSS_PROTECTION_HEADER);
                    continue;
                }
                if ("csrfToken".equalsIgnoreCase(name)) {
                    authorizers.add(CSRF_TOKEN_GENERATOR_AUTHORIZER);
                    continue;
                }
                if ("csrfCheck".equalsIgnoreCase(name)) {
                    authorizers.add(CSRF_AUTHORIZER);
                    continue;
                }
                if ("csrf".equalsIgnoreCase(name)) {
                    authorizers.add(CSRF_TOKEN_GENERATOR_AUTHORIZER);
                    authorizers.add(CSRF_AUTHORIZER);
                    continue;
                }
                if ("allowAjaxRequests".equalsIgnoreCase(name)) {
                    authorizers.add(CORS_AUTHORIZER);
                    continue;
                }
                if ("isAnonymous".equalsIgnoreCase(name)) {
                    authorizers.add(IS_ANONYMOUS_AUTHORIZER);
                    continue;
                }
                if ("isAuthenticated".equalsIgnoreCase(name)) {
                    authorizers.add(IS_AUTHENTICATED_AUTHORIZER);
                    continue;
                }
                if ("isFullyAuthenticated".equalsIgnoreCase(name)) {
                    authorizers.add(IS_FULLY_AUTHENTICATED_AUTHORIZER);
                    continue;
                }
                if ("isRemembered".equalsIgnoreCase(name)) {
                    authorizers.add(IS_REMEMBERED_AUTHORIZER);
                    continue;
                }
                CommonHelper.assertNotNull("authorizersMap", authorizersMap);
                Authorizer result = null;
                for (Map.Entry<String, Authorizer> entry : authorizersMap.entrySet()) {
                    if (!CommonHelper.areEqualsIgnoreCaseAndTrim(entry.getKey(), name)) continue;
                    result = entry.getValue();
                    break;
                }
                CommonHelper.assertNotNull("authorizersMap['" + name + "']", result);
                authorizers.add(result);
            }
        }
        return this.isAuthorized(context, profiles, authorizers);
    }

    protected boolean isAuthorized(WebContext context, List<UserProfile> profiles, List<Authorizer> authorizers) {
        CommonHelper.assertTrue(CommonHelper.isNotEmpty(profiles), "profiles must not be null or empty");
        if (CommonHelper.isNotEmpty(authorizers)) {
            for (Authorizer authorizer : authorizers) {
                boolean isAuthorized = authorizer.isAuthorized(context, profiles);
                LOGGER.debug("Checking authorizer: {} -> {}", (Object)authorizer, (Object)isAuthorized);
                if (isAuthorized) continue;
                return false;
            }
        }
        return true;
    }

    static {
        CORS_AUTHORIZER.setAllowOrigin("*");
        CORS_AUTHORIZER.setAllowCredentials(true);
        HashSet<HttpConstants.HTTP_METHOD> methods = new HashSet<HttpConstants.HTTP_METHOD>();
        methods.add(HttpConstants.HTTP_METHOD.GET);
        methods.add(HttpConstants.HTTP_METHOD.PUT);
        methods.add(HttpConstants.HTTP_METHOD.POST);
        methods.add(HttpConstants.HTTP_METHOD.DELETE);
        methods.add(HttpConstants.HTTP_METHOD.OPTIONS);
        CORS_AUTHORIZER.setAllowMethods(methods);
    }
}

