/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.context;

import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pac4j.core.context.Cookie;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.J2ESessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;

public class J2EContext
implements WebContext {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private SessionStore<J2EContext> sessionStore;

    public J2EContext(HttpServletRequest request, HttpServletResponse response) {
        this(request, response, new J2ESessionStore());
    }

    public J2EContext(HttpServletRequest request, HttpServletResponse response, SessionStore<J2EContext> sessionStore) {
        CommonHelper.assertNotNull("request", request);
        CommonHelper.assertNotNull("response", response);
        this.request = request;
        this.response = response;
        this.sessionStore = sessionStore == null ? new J2ESessionStore() : sessionStore;
    }

    @Override
    public SessionStore getSessionStore() {
        return this.sessionStore;
    }

    @Override
    public String getRequestParameter(String name) {
        return this.request.getParameter(name);
    }

    @Override
    public Object getRequestAttribute(String name) {
        return this.request.getAttribute(name);
    }

    @Override
    public void setRequestAttribute(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    @Override
    public Map<String, String[]> getRequestParameters() {
        return this.request.getParameterMap();
    }

    @Override
    public String getRequestHeader(String name) {
        Enumeration names = this.request.getHeaderNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String headerName = (String)names.nextElement();
                if (headerName == null || !headerName.equalsIgnoreCase(name)) continue;
                return this.request.getHeader(headerName);
            }
        }
        return null;
    }

    @Override
    public String getRequestMethod() {
        return this.request.getMethod();
    }

    @Override
    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    public void writeResponseContent(String content) {
        if (content != null) {
            try {
                this.response.getWriter().write(content);
            }
            catch (IOException e) {
                throw new TechnicalException(e);
            }
        }
    }

    @Override
    public void setResponseStatus(int code) {
        if (code == 200 || code == 302) {
            this.response.setStatus(code);
        } else {
            try {
                this.response.sendError(code);
            }
            catch (IOException e) {
                throw new TechnicalException(e);
            }
        }
    }

    @Override
    public void setResponseHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    @Override
    public void setResponseContentType(String content) {
        this.response.setContentType(content);
    }

    @Override
    public String getServerName() {
        return this.request.getServerName();
    }

    @Override
    public int getServerPort() {
        return this.request.getServerPort();
    }

    @Override
    public String getScheme() {
        return this.request.getScheme();
    }

    @Override
    public boolean isSecure() {
        return this.request.isSecure();
    }

    @Override
    public String getFullRequestURL() {
        StringBuffer requestURL = this.request.getRequestURL();
        String queryString = this.request.getQueryString();
        if (queryString == null) {
            return requestURL.toString();
        }
        return requestURL.append('?').append(queryString).toString();
    }

    @Override
    public Collection<Cookie> getRequestCookies() {
        LinkedHashSet<Cookie> pac4jCookies = new LinkedHashSet<Cookie>();
        javax.servlet.http.Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (javax.servlet.http.Cookie c : cookies) {
                Cookie cookie = new Cookie(c.getName(), c.getValue());
                cookie.setVersion(c.getVersion());
                cookie.setComment(c.getComment());
                cookie.setDomain(c.getDomain());
                cookie.setHttpOnly(c.isHttpOnly());
                cookie.setMaxAge(c.getMaxAge());
                cookie.setPath(c.getPath());
                cookie.setSecure(c.getSecure());
                pac4jCookies.add(cookie);
            }
        }
        return pac4jCookies;
    }

    @Override
    public void addResponseCookie(Cookie cookie) {
        javax.servlet.http.Cookie c = new javax.servlet.http.Cookie(cookie.getName(), cookie.getValue());
        c.setVersion(cookie.getVersion());
        c.setSecure(cookie.isSecure());
        c.setPath(cookie.getPath());
        c.setMaxAge(cookie.getMaxAge());
        c.setHttpOnly(cookie.isHttpOnly());
        c.setComment(cookie.getComment());
        c.setDomain(cookie.getDomain());
        this.response.addCookie(c);
    }

    @Override
    public String getPath() {
        String fullPath = this.request.getRequestURI();
        if (fullPath == null) {
            return "";
        }
        String context = this.request.getContextPath();
        if (context != null) {
            return fullPath.substring(context.length());
        }
        return fullPath;
    }

    @Override
    public String getRequestContent() {
        try {
            return this.request.getReader().lines().reduce("", (accumulator, actual) -> accumulator.concat((String)actual));
        }
        catch (IOException e) {
            throw new TechnicalException(e);
        }
    }

    @Override
    public String getProtocol() {
        return this.request.getProtocol();
    }
}

