/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.engine;

import java.util.List;
import org.pac4j.core.authorization.checker.AuthorizationChecker;
import org.pac4j.core.authorization.checker.DefaultAuthorizationChecker;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.client.direct.AnonymousClient;
import org.pac4j.core.client.finder.ClientFinder;
import org.pac4j.core.client.finder.DefaultClientFinder;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.engine.SecurityGrantedAccessAdapter;
import org.pac4j.core.engine.SecurityLogic;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.http.HttpActionAdapter;
import org.pac4j.core.matching.DefaultMatchingChecker;
import org.pac4j.core.matching.MatchingChecker;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.ProfileManagerFactoryAware;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSecurityLogic<R, C extends WebContext>
extends ProfileManagerFactoryAware<C>
implements SecurityLogic<R, C> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private ClientFinder clientFinder = new DefaultClientFinder();
    private AuthorizationChecker authorizationChecker = new DefaultAuthorizationChecker();
    private MatchingChecker matchingChecker = new DefaultMatchingChecker();
    private boolean saveProfileInSession;
    private boolean saveRequestURLInSession = true;

    @Override
    public R perform(C context, Config config, SecurityGrantedAccessAdapter<R, C> securityGrantedAccessAdapter, HttpActionAdapter<R, C> httpActionAdapter, String clients, String authorizers, String matchers, Boolean inputMultiProfile, Object ... parameters) {
        HttpAction action;
        block13: {
            this.logger.debug("=== SECURITY ===");
            boolean multiProfile = inputMultiProfile == null ? false : inputMultiProfile;
            CommonHelper.assertNotNull("context", context);
            CommonHelper.assertNotNull("config", config);
            CommonHelper.assertNotNull("httpActionAdapter", httpActionAdapter);
            CommonHelper.assertNotNull("clientFinder", this.clientFinder);
            CommonHelper.assertNotNull("authorizationChecker", this.authorizationChecker);
            CommonHelper.assertNotNull("matchingChecker", this.matchingChecker);
            Clients configClients = config.getClients();
            CommonHelper.assertNotNull("configClients", configClients);
            try {
                this.logger.debug("url: {}", (Object)context.getFullRequestURL());
                this.logger.debug("matchers: {}", (Object)matchers);
                if (this.matchingChecker.matches((WebContext)context, matchers, config.getMatchers())) {
                    this.logger.debug("clients: {}", (Object)clients);
                    List<Client> currentClients = this.clientFinder.find(configClients, (WebContext)context, clients);
                    this.logger.debug("currentClients: {}", currentClients);
                    boolean loadProfilesFromSession = this.loadProfilesFromSession(context, currentClients);
                    this.logger.debug("loadProfilesFromSession: {}", (Object)loadProfilesFromSession);
                    ProfileManager manager = this.getProfileManager(context, config);
                    List<CommonProfile> profiles = manager.getAll(loadProfilesFromSession);
                    this.logger.debug("profiles: {}", profiles);
                    if (CommonHelper.isEmpty(profiles) && CommonHelper.isNotEmpty(currentClients)) {
                        boolean updated = false;
                        for (Client currentClient : currentClients) {
                            if (!(currentClient instanceof DirectClient)) continue;
                            this.logger.debug("Performing authentication for direct client: {}", (Object)currentClient);
                            Object credentials = currentClient.getCredentials((WebContext)context);
                            this.logger.debug("credentials: {}", credentials);
                            Object profile = currentClient.getUserProfile(credentials, (WebContext)context);
                            this.logger.debug("profile: {}", profile);
                            if (profile == null) continue;
                            boolean saveProfileInSession = this.saveProfileInSession(context, currentClients, (DirectClient)currentClient, (CommonProfile)profile);
                            this.logger.debug("saveProfileInSession: {} / multiProfile: {}", (Object)saveProfileInSession, (Object)multiProfile);
                            manager.save(saveProfileInSession, profile, multiProfile);
                            updated = true;
                            if (multiProfile) continue;
                            break;
                        }
                        if (updated) {
                            profiles = manager.getAll(loadProfilesFromSession);
                            this.logger.debug("new profiles: {}", profiles);
                        }
                    }
                    if (CommonHelper.isNotEmpty(profiles)) {
                        this.logger.debug("authorizers: {}", (Object)authorizers);
                        if (this.authorizationChecker.isAuthorized((WebContext)context, profiles, authorizers, config.getAuthorizers())) {
                            this.logger.debug("authenticated and authorized -> grant access");
                            return securityGrantedAccessAdapter.adapt(context, parameters);
                        }
                        this.logger.debug("forbidden");
                        action = this.forbidden(context, currentClients, profiles, authorizers);
                    } else if (this.startAuthentication(context, currentClients)) {
                        this.logger.debug("Starting authentication");
                        this.saveRequestedUrl(context, currentClients);
                        action = this.redirectToIdentityProvider(context, currentClients);
                    } else {
                        this.logger.debug("unauthorized");
                        action = this.unauthorized(context, currentClients);
                    }
                    break block13;
                }
                this.logger.debug("no matching for this request -> grant access");
                return securityGrantedAccessAdapter.adapt(context, parameters);
            }
            catch (HttpAction e) {
                this.logger.debug("extra HTTP action required in security: {}", (Object)e.getCode());
                action = e;
            }
            catch (TechnicalException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new TechnicalException(e);
            }
        }
        return httpActionAdapter.adapt(action.getCode(), context);
    }

    protected boolean loadProfilesFromSession(C context, List<Client> currentClients) {
        return CommonHelper.isEmpty(currentClients) || currentClients.get(0) instanceof IndirectClient || currentClients.get(0) instanceof AnonymousClient;
    }

    protected boolean saveProfileInSession(C context, List<Client> currentClients, DirectClient directClient, CommonProfile profile) {
        return this.saveProfileInSession;
    }

    protected HttpAction forbidden(C context, List<Client> currentClients, List<CommonProfile> profiles, String authorizers) throws HttpAction {
        return HttpAction.forbidden("forbidden", context);
    }

    protected boolean startAuthentication(C context, List<Client> currentClients) {
        return CommonHelper.isNotEmpty(currentClients) && currentClients.get(0) instanceof IndirectClient;
    }

    protected void saveRequestedUrl(C context, List<Client> currentClients) throws HttpAction {
        if (this.saveRequestURLInSession) {
            String requestedUrl = context.getFullRequestURL();
            this.logger.debug("requestedUrl: {}", (Object)requestedUrl);
            context.setSessionAttribute("pac4jRequestedUrl", requestedUrl);
        }
    }

    protected HttpAction redirectToIdentityProvider(C context, List<Client> currentClients) throws HttpAction {
        IndirectClient currentClient = (IndirectClient)currentClients.get(0);
        return currentClient.redirect((WebContext)context);
    }

    protected HttpAction unauthorized(C context, List<Client> currentClients) throws HttpAction {
        return HttpAction.unauthorized("unauthorized", context, null, null);
    }

    public ClientFinder getClientFinder() {
        return this.clientFinder;
    }

    public void setClientFinder(ClientFinder clientFinder) {
        this.clientFinder = clientFinder;
    }

    public AuthorizationChecker getAuthorizationChecker() {
        return this.authorizationChecker;
    }

    public void setAuthorizationChecker(AuthorizationChecker authorizationChecker) {
        this.authorizationChecker = authorizationChecker;
    }

    public MatchingChecker getMatchingChecker() {
        return this.matchingChecker;
    }

    public void setMatchingChecker(MatchingChecker matchingChecker) {
        this.matchingChecker = matchingChecker;
    }

    public boolean isSaveProfileInSession() {
        return this.saveProfileInSession;
    }

    public void setSaveProfileInSession(boolean saveProfileInSession) {
        this.saveProfileInSession = saveProfileInSession;
    }

    public boolean isSaveRequestURLInSession() {
        return this.saveRequestURLInSession;
    }

    public void setSaveRequestURLInSession(boolean saveRequestURLInSession) {
        this.saveRequestURLInSession = saveRequestURLInSession;
    }
}

