/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.client.finder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.client.finder.ClientFinder;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;

public class DefaultClientFinder
implements ClientFinder {
    @Override
    public List<Client> find(Clients clients, WebContext context, String clientNames) {
        ArrayList<Client> result = new ArrayList<Client>();
        if (CommonHelper.isNotBlank(clientNames)) {
            List<String> names = Arrays.asList(clientNames.split(","));
            String clientNameOnRequest = context.getRequestParameter(clients.getClientNameParameter());
            if (clientNameOnRequest != null) {
                Client client = clients.findClient(context);
                String nameFound = client.getName();
                boolean found = false;
                for (String name : names) {
                    if (!CommonHelper.areEqualsIgnoreCaseAndTrim(name, nameFound)) continue;
                    result.add(client);
                    found = true;
                    break;
                }
                if (!found) {
                    throw new TechnicalException("Client not allowed: " + nameFound);
                }
            } else {
                for (String name : names) {
                    Client client = clients.findClient(name);
                    result.add(client);
                }
            }
        }
        return result;
    }
}

