/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.io.Resource;
import org.pac4j.core.io.WritableResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommonHelper {
    private static final Logger logger = LoggerFactory.getLogger(CommonHelper.class);
    public static final String RESOURCE_PREFIX = "resource";
    public static final String CLASSPATH_PREFIX = "classpath";
    protected static final String FILE_PREFIX = "file";
    public static final String INVALID_PATH_MESSAGE = "begin with 'resource:', 'classpath:', 'http:', 'https:' or it must be a physical readable non-empty local file at the path specified.";
    private static final String EMPTY = "";
    private static final int INDEX_NOT_FOUND = -1;

    public static boolean isNotBlank(String s) {
        if (s == null) {
            return false;
        }
        return s.trim().length() > 0;
    }

    public static boolean isBlank(String s) {
        return !CommonHelper.isNotBlank(s);
    }

    public static boolean areEquals(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public static boolean areEqualsIgnoreCaseAndTrim(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 != null && s2 != null) {
            return s1.trim().equalsIgnoreCase(s2.trim());
        }
        return false;
    }

    public static boolean areNotEquals(String s1, String s2) {
        return !CommonHelper.areEquals(s1, s2);
    }

    public static boolean isEmpty(Collection<?> coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> coll) {
        return !CommonHelper.isEmpty(coll);
    }

    public static void assertTrue(boolean value, String message) {
        if (!value) {
            throw new TechnicalException(message);
        }
    }

    public static void assertNotBlank(String name, String value) {
        CommonHelper.assertTrue(!CommonHelper.isBlank(value), name + " cannot be blank");
    }

    public static void assertNotNull(String name, Object obj) {
        CommonHelper.assertTrue(obj != null, name + " cannot be null");
    }

    public static void assertNull(String name, Object obj) {
        CommonHelper.assertTrue(obj == null, name + " must be null");
    }

    public static String addParameter(String url, String name, String value) {
        if (url != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(url);
            if (name != null) {
                if (url.indexOf("?") >= 0) {
                    sb.append("&");
                } else {
                    sb.append("?");
                }
                sb.append(name);
                sb.append("=");
                if (value != null) {
                    sb.append(CommonHelper.urlEncode(value));
                }
            }
            return sb.toString();
        }
        return null;
    }

    public static String urlEncode(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            String message = "Unable to encode text : " + text;
            throw new TechnicalException(message, e);
        }
    }

    public static String toString(Class<?> clazz, Object ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append("#");
        sb.append(clazz.getSimpleName());
        sb.append("# |");
        boolean b = true;
        for (Object arg : args) {
            if (b) {
                sb.append(" ");
                sb.append(arg);
                sb.append(":");
            } else {
                sb.append(" ");
                sb.append(arg);
                sb.append(" |");
            }
            b = !b;
        }
        return sb.toString();
    }

    protected static String extractPrefix(String name) {
        int prefixEnd;
        String prefix = null;
        if (name != null && (prefixEnd = name.indexOf(":")) != -1) {
            prefix = name.substring(0, prefixEnd);
        }
        return prefix;
    }

    protected static String startWithSlash(String path) {
        if (!path.startsWith("/")) {
            return "/" + path;
        }
        return path;
    }

    public static InputStream getInputStreamFromName(String name) {
        String path = name;
        String prefix = CommonHelper.extractPrefix(name);
        if (prefix != null) {
            path = name.substring(prefix.length() + 1);
        }
        if (CommonHelper.isEmpty(prefix)) {
            return CommonHelper.newFileInputStream(path);
        }
        switch (prefix) {
            case "resource": {
                return CommonHelper.class.getResourceAsStream(CommonHelper.startWithSlash(path));
            }
            case "classpath": {
                return Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
            }
            case "http": {
                logger.warn("file is retrieved from an insecure http endpoint [{}]", (Object)path);
                return CommonHelper.getInputStreamViaHttp(name);
            }
            case "https": {
                return CommonHelper.getInputStreamViaHttp(name);
            }
            case "file": {
                return CommonHelper.newFileInputStream(path);
            }
        }
        throw new TechnicalException("prefix is not handled:" + prefix);
    }

    private static FileInputStream newFileInputStream(String name) {
        try {
            return new FileInputStream(name);
        }
        catch (FileNotFoundException e) {
            throw new TechnicalException(e);
        }
    }

    private static InputStream getInputStreamViaHttp(String name) {
        URLConnection con = null;
        try {
            URL url = new URL(name);
            con = url.openConnection();
            return con.getInputStream();
        }
        catch (IOException ex) {
            if (con instanceof HttpURLConnection) {
                ((HttpURLConnection)con).disconnect();
            }
            throw new TechnicalException(ex);
        }
    }

    public static Resource getResource(final String filePath) {
        return new WritableResource(){

            @Override
            public File getFile() {
                String filename = this.getFilename();
                if (filename != null) {
                    return new File(filename);
                }
                logger.warn("This filePath: {} is not a file. Returning null in the getFile() method", (Object)filePath);
                return null;
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return CommonHelper.getInputStreamFromName(filePath);
            }

            @Override
            public String getFilename() {
                String filename = null;
                String prefix = CommonHelper.extractPrefix(filePath);
                if (prefix == null) {
                    filename = filePath;
                } else if (prefix.equals(CommonHelper.RESOURCE_PREFIX) || prefix.equals(CommonHelper.CLASSPATH_PREFIX)) {
                    String path = filePath.substring(prefix.length() + 1);
                    URL url = prefix.equals(CommonHelper.RESOURCE_PREFIX) ? CommonHelper.class.getResource(CommonHelper.startWithSlash(path)) : Thread.currentThread().getContextClassLoader().getResource(path);
                    if (url == null || url.toString() == null) {
                        throw new TechnicalException("Do not use the resource: or classpath: prefix for non-existing files. Use a direct path (relative or absolute, no prefix)");
                    }
                    String sUrl = url.toString();
                    if (sUrl.startsWith("file:")) {
                        filename = sUrl.substring(CommonHelper.FILE_PREFIX.length() + 1);
                    } else {
                        throw new TechnicalException("Unsupported resource format: " + sUrl + ". Use a relative or absolute path");
                    }
                }
                logger.debug("filepath: {} -> filename: {}", (Object)filePath, (Object)filename);
                return filename;
            }

            @Override
            public boolean exists() {
                File f = this.getFile();
                if (f != null) {
                    return f.exists();
                }
                return true;
            }

            @Override
            public OutputStream getOutputStream() throws IOException {
                String filename = this.getFilename();
                if (filename != null) {
                    return new FileOutputStream(filePath);
                }
                return null;
            }
        };
    }

    public static String randomString(int size) {
        return UUID.randomUUID().toString().replace("-", EMPTY).substring(0, size);
    }

    public static Date newDate(Date original) {
        return original != null ? new Date(original.getTime()) : null;
    }

    public static String substringBetween(String str, String open, String close) {
        int end;
        if (str == null || open == null || close == null) {
            return null;
        }
        int start = str.indexOf(open);
        if (start != -1 && (end = str.indexOf(close, start + open.length())) != -1) {
            return str.substring(start + open.length(), end);
        }
        return null;
    }

    public static String substringAfter(String str, String separator) {
        if (CommonHelper.isEmpty(str)) {
            return str;
        }
        if (separator == null) {
            return EMPTY;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return EMPTY;
        }
        return str.substring(pos + separator.length());
    }

    public static String substringBefore(String str, String separator) {
        if (CommonHelper.isEmpty(str) || separator == null) {
            return str;
        }
        if (separator.length() == 0) {
            return EMPTY;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    private static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }
}

