/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.credentials.authenticator;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableWebObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalCachingAuthenticator<T extends Credentials>
extends InitializableWebObject
implements Authenticator<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Authenticator<T> delegate;
    private long cacheSize;
    private long timeout;
    private TimeUnit timeUnit;
    private Cache<T, CommonProfile> cache;

    public LocalCachingAuthenticator() {
    }

    public LocalCachingAuthenticator(Authenticator<T> delegate, long cacheSize, long timeout, TimeUnit timeUnit) {
        this.delegate = delegate;
        this.cacheSize = cacheSize;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    @Override
    public void validate(T credentials, WebContext context) throws HttpAction {
        this.init(context);
        try {
            CommonProfile profile = (CommonProfile)this.cache.get(credentials, () -> {
                this.logger.debug("Delegating authentication to {}...", this.delegate);
                this.delegate.validate(credentials, context);
                return credentials.getUserProfile();
            });
            ((Credentials)credentials).setUserProfile(profile);
            this.logger.debug("Found cached credential. Using cached profile {}...", (Object)profile);
        }
        catch (Exception e) {
            throw new CredentialsException(e);
        }
    }

    @Override
    protected void internalInit(WebContext context) {
        CommonHelper.assertNotNull("delegate", this.delegate);
        CommonHelper.assertTrue(this.cacheSize > 0L, "cacheSize must be > 0");
        CommonHelper.assertTrue(this.timeout > 0L, "timeout must be > 0");
        CommonHelper.assertNotNull("timeUnit", (Object)this.timeUnit);
        if (this.delegate instanceof InitializableWebObject) {
            ((InitializableWebObject)((Object)this.delegate)).init(context);
        }
        this.cache = CacheBuilder.newBuilder().maximumSize(this.cacheSize).expireAfterWrite(this.timeout, this.timeUnit).build();
    }

    public void removeFromCache(T credentials) {
        this.cache.invalidate(credentials);
    }

    public boolean isCached(T credentials) {
        return this.cache.getIfPresent(credentials) != null;
    }

    public boolean clearCache() {
        this.cache.invalidateAll();
        return this.cache.asMap().isEmpty();
    }

    public Authenticator<T> getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Authenticator<T> delegate) {
        this.delegate = delegate;
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(long cacheSize) {
        this.cacheSize = cacheSize;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public String toString() {
        return CommonHelper.toString(this.getClass(), new Object[]{"delegate", this.delegate, "cacheSize", this.cacheSize, "timeout", this.timeout, "timeUnit", this.timeUnit});
    }
}

