/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSerializationHelper {
    private static final Logger logger = LoggerFactory.getLogger(JavaSerializationHelper.class);

    public String serializeToBase64(Serializable o) {
        return DatatypeConverter.printBase64Binary((byte[])this.serializeToBytes(o));
    }

    public byte[] serializeToBytes(Serializable o) {
        byte[] bytes = null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(o);
            oos.flush();
            bytes = baos.toByteArray();
        }
        catch (IOException e) {
            logger.warn("cannot Java serialize object", (Throwable)e);
        }
        return bytes;
    }

    public Serializable unserializeFromBase64(String base64) {
        return this.unserializeFromBytes(DatatypeConverter.parseBase64Binary((String)base64));
    }

    public Serializable unserializeFromBytes(byte[] bytes) {
        Serializable o = null;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
             ObjectInputStream ois = new ObjectInputStream(bais);){
            o = (Serializable)ois.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            logger.warn("cannot Java deserialize object", (Throwable)e);
        }
        return o;
    }
}

