/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.io.Resource;
import org.pac4j.core.io.WritableResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommonHelper {
    private static final Logger logger = LoggerFactory.getLogger(CommonHelper.class);
    public static final String RESOURCE_PREFIX = "resource";
    public static final String CLASSPATH_PREFIX = "classpath";
    public static final String INVALID_PATH_MESSAGE = "begin with 'resource:', 'classpath:', 'http:', 'https:' or it must be a physical readable non-empty local file at the path specified.";

    public static boolean isNotBlank(String s) {
        if (s == null) {
            return false;
        }
        return s.trim().length() > 0;
    }

    public static boolean isBlank(String s) {
        return !CommonHelper.isNotBlank(s);
    }

    public static boolean areEquals(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public static boolean areNotEquals(String s1, String s2) {
        return !CommonHelper.areEquals(s1, s2);
    }

    public static void assertTrue(boolean value, String message) {
        if (!value) {
            throw new TechnicalException(message);
        }
    }

    public static void assertNotBlank(String name, String value) {
        CommonHelper.assertTrue(!CommonHelper.isBlank(value), name + " cannot be blank");
    }

    public static void assertNotNull(String name, Object obj) {
        CommonHelper.assertTrue(obj != null, name + " cannot be null");
    }

    public static void assertNull(String name, Object obj) {
        CommonHelper.assertTrue(obj == null, name + " must be null");
    }

    public static String addParameter(String url, String name, String value) {
        if (url != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(url);
            if (name != null) {
                if (url.indexOf("?") >= 0) {
                    sb.append("&");
                } else {
                    sb.append("?");
                }
                sb.append(name);
                sb.append("=");
                if (value != null) {
                    sb.append(CommonHelper.encodeText(value));
                }
            }
            return sb.toString();
        }
        return null;
    }

    private static String encodeText(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            String message = "Unable to encode text : " + text;
            throw new TechnicalException(message, e);
        }
    }

    public static String toString(Class<?> clazz, Object ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(clazz.getSimpleName());
        sb.append("> |");
        boolean b = true;
        for (Object arg : args) {
            if (b) {
                sb.append(" ");
                sb.append(arg);
                sb.append(":");
            } else {
                sb.append(" ");
                sb.append(arg);
                sb.append(" |");
            }
            b = !b;
        }
        return sb.toString();
    }

    public static InputStream getInputStreamFromName(String name) {
        int prefixEnd = name.indexOf(":");
        String prefix = null;
        String path = name;
        if (prefixEnd != -1) {
            prefix = name.substring(0, prefixEnd);
            path = name.substring(prefixEnd + 1);
        }
        if (prefix == null || prefix.isEmpty()) {
            try {
                return new FileInputStream(path);
            }
            catch (FileNotFoundException e) {
                throw new TechnicalException(e);
            }
        }
        switch (prefix) {
            case "resource": {
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                return CommonHelper.class.getResourceAsStream(path);
            }
            case "classpath": {
                return Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
            }
            case "http": {
                logger.warn("file is retrieved from an insecure http endpoint [{}]", (Object)path);
                return CommonHelper.getInputStreamViaHttp(name);
            }
            case "https": {
                return CommonHelper.getInputStreamViaHttp(name);
            }
        }
        throw new TechnicalException("prefix is not handled:" + prefix);
    }

    private static InputStream getInputStreamViaHttp(String name) {
        URLConnection con = null;
        try {
            URL url = new URL(name);
            con = url.openConnection();
            return con.getInputStream();
        }
        catch (IOException ex) {
            if (con instanceof HttpURLConnection) {
                ((HttpURLConnection)con).disconnect();
            }
            throw new TechnicalException(ex);
        }
    }

    public static Resource getResource(final String filePath) {
        return new WritableResource(){

            @Override
            public InputStream getInputStream() throws IOException {
                return CommonHelper.getInputStreamFromName(filePath);
            }

            @Override
            public String getFilename() {
                return filePath;
            }

            @Override
            public boolean exists() {
                return true;
            }

            @Override
            public OutputStream getOutputStream() throws IOException {
                return new FileOutputStream(filePath);
            }
        };
    }
}

