/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.profile;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pac4j.core.Clearable;
import org.pac4j.core.profile.AttributesDefinition;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserProfile
implements Serializable,
Externalizable,
Clearable {
    private static final long serialVersionUID = 9020114478664816338L;
    protected static final transient Logger logger = LoggerFactory.getLogger(UserProfile.class);
    private String id;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    public static final transient String SEPARATOR = "#";
    private boolean isRemembered = false;
    private List<String> roles = new ArrayList<String>();
    private List<String> permissions = new ArrayList<String>();

    public void build(Object id, Map<String, Object> attributes) {
        this.setId(id);
        this.addAttributes(attributes);
    }

    protected AttributesDefinition getAttributesDefinition() {
        return null;
    }

    public void addAttribute(String key, Object value) {
        if (value != null) {
            AttributesDefinition definition = this.getAttributesDefinition();
            if (definition == null) {
                logger.debug("no conversion => key : {} / value : {} / {}", new Object[]{key, value, value.getClass()});
                this.attributes.put(key, value);
            } else if ((value = definition.convert(key, value)) != null) {
                logger.debug("converted to => key : {} / value : {} / {}", new Object[]{key, value, value.getClass()});
                this.attributes.put(key, value);
            }
        }
    }

    public void addAttributes(Map<String, Object> attributes) {
        for (String key : attributes.keySet()) {
            this.addAttribute(key, attributes.get(key));
        }
    }

    public void setId(Object id) {
        if (id != null) {
            String type;
            String sId = id.toString();
            if (sId.startsWith((type = this.getClass().getSimpleName()) + SEPARATOR)) {
                sId = sId.substring(type.length() + SEPARATOR.length());
            }
            logger.debug("identifier : {}", (Object)sId);
            this.id = sId;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getTypedId() {
        return this.getClass().getSimpleName() + SEPARATOR + this.id;
    }

    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public <T> T getAttribute(String name, Class<T> clazz) {
        Object attribute = this.getAttribute(name);
        if (attribute == null) {
            return null;
        }
        if (!clazz.isAssignableFrom(attribute.getClass())) {
            throw new ClassCastException("Attribute [" + name + " is of type " + attribute.getClass() + " when we were expecting " + clazz);
        }
        return (T)attribute;
    }

    public void addRole(String role) {
        this.roles.add(role);
    }

    public void addRoles(List<String> roles) {
        this.roles.addAll(roles);
    }

    public void addPermission(String permission) {
        this.permissions.add(permission);
    }

    public void addPermissions(List<String> permissions) {
        this.permissions.addAll(permissions);
    }

    public void setRemembered(boolean rme) {
        this.isRemembered = rme;
    }

    public List<String> getRoles() {
        return Collections.unmodifiableList(this.roles);
    }

    public List<String> getPermissions() {
        return Collections.unmodifiableList(this.permissions);
    }

    public boolean isRemembered() {
        return this.isRemembered;
    }

    public String toString() {
        return CommonHelper.toString(this.getClass(), "id", this.id, "attributes", this.attributes, "roles", this.roles, "permissions", this.permissions, "isRemembered", this.isRemembered);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.id);
        out.writeObject(this.attributes);
        out.writeBoolean(this.isRemembered);
        out.writeObject(this.roles);
        out.writeObject(this.permissions);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = (String)in.readObject();
        this.attributes = (Map)in.readObject();
        this.isRemembered = in.readBoolean();
        this.roles = (List)in.readObject();
        this.permissions = (List)in.readObject();
    }

    @Override
    public void clear() {
    }
}

