/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.context;

import java.util.Collection;
import org.pac4j.core.context.Cookie;
import org.pac4j.core.context.HttpConstants;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.CommonHelper;

public final class ContextHelper {
    public static Cookie getCookie(Collection<Cookie> cookies, String name) {
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie == null || !CommonHelper.areEquals(name, cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    public static Cookie getCookie(WebContext context, String name) {
        return ContextHelper.getCookie(context.getRequestCookies(), name);
    }

    public static boolean isPost(WebContext context) {
        return HttpConstants.HTTP_METHOD.POST.name().equalsIgnoreCase(context.getRequestMethod());
    }

    public static boolean isHttpsOrSecure(WebContext context) {
        return "HTTPS".equalsIgnoreCase(context.getScheme()) || context.isSecure();
    }

    public static boolean isHttp(WebContext context) {
        return "HTTP".equalsIgnoreCase(context.getScheme());
    }

    public static boolean isHttps(WebContext context) {
        return "HTTPS".equalsIgnoreCase(context.getScheme());
    }
}

