/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.client;

import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.RedirectAction;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.RequiresHttpAction;
import org.pac4j.core.http.AjaxRequestResolver;
import org.pac4j.core.http.CallbackUrlResolver;
import org.pac4j.core.http.DefaultAjaxRequestResolver;
import org.pac4j.core.http.DefaultCallbackUrlResolver;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.util.CommonHelper;

public abstract class IndirectClient<C extends Credentials, U extends CommonProfile>
extends BaseClient<C, U> {
    public static final String NEEDS_CLIENT_REDIRECTION_PARAMETER = "needs_client_redirection";
    public static final String ATTEMPTED_AUTHENTICATION_SUFFIX = "$attemptedAuthentication";
    protected String callbackUrl;
    private boolean includeClientNameInCallbackUrl = true;
    private AjaxRequestResolver ajaxRequestResolver = new DefaultAjaxRequestResolver();
    protected CallbackUrlResolver callbackUrlResolver = new DefaultCallbackUrlResolver();

    protected abstract boolean isDirectRedirection();

    @Override
    public final void redirect(WebContext context, boolean protectedTarget) throws RequiresHttpAction {
        RedirectAction action = this.getRedirectAction(context, protectedTarget);
        if (action.getType() == RedirectAction.RedirectType.REDIRECT) {
            context.setResponseStatus(302);
            context.setResponseHeader("Location", action.getLocation());
        } else if (action.getType() == RedirectAction.RedirectType.SUCCESS) {
            context.setResponseStatus(200);
            context.writeResponseContent(action.getContent());
        }
    }

    public final RedirectAction getRedirectAction(WebContext context, boolean protectedTarget) throws RequiresHttpAction {
        if (this.ajaxRequestResolver.isAjax(context)) {
            this.logger.info("AJAX request detected -> returning 401");
            this.cleanRequestedUrl(context);
            throw RequiresHttpAction.unauthorized("AJAX request -> 401", context, null);
        }
        String attemptedAuth = (String)context.getSessionAttribute(this.getName() + ATTEMPTED_AUTHENTICATION_SUFFIX);
        if (CommonHelper.isNotBlank(attemptedAuth)) {
            this.cleanAttemptedAuthentication(context);
            if (protectedTarget) {
                this.cleanRequestedUrl(context);
                throw RequiresHttpAction.forbidden("authentication already tried -> forbidden", context);
            }
        }
        if (this.isDirectRedirection() || protectedTarget) {
            this.init(context);
            return this.retrieveRedirectAction(context);
        }
        String intermediateUrl = CommonHelper.addParameter(this.computeFinalCallbackUrl(context), NEEDS_CLIENT_REDIRECTION_PARAMETER, "true");
        return RedirectAction.redirect(intermediateUrl);
    }

    private void cleanRequestedUrl(WebContext context) {
        context.setSessionAttribute("pac4jRequestedUrl", "");
    }

    private void cleanAttemptedAuthentication(WebContext context) {
        context.setSessionAttribute(this.getName() + ATTEMPTED_AUTHENTICATION_SUFFIX, "");
    }

    public String computeFinalCallbackUrl(WebContext context) {
        return this.callbackUrlResolver.compute(this.callbackUrl, context);
    }

    public String getRedirectionUrl(WebContext context) {
        try {
            return this.getRedirectAction(context, false).getLocation();
        }
        catch (RequiresHttpAction e) {
            return null;
        }
    }

    protected abstract RedirectAction retrieveRedirectAction(WebContext var1);

    @Override
    public final C getCredentials(WebContext context) throws RequiresHttpAction {
        this.init(context);
        String value = context.getRequestParameter(NEEDS_CLIENT_REDIRECTION_PARAMETER);
        if (CommonHelper.isNotBlank(value)) {
            RedirectAction action = this.retrieveRedirectAction(context);
            String message = "Needs client redirection";
            if (action.getType() == RedirectAction.RedirectType.SUCCESS) {
                throw RequiresHttpAction.ok("Needs client redirection", context, action.getContent());
            }
            throw RequiresHttpAction.redirect("Needs client redirection", context, action.getLocation());
        }
        C credentials = this.retrieveCredentials(context);
        if (credentials == null) {
            context.setSessionAttribute(this.getName() + ATTEMPTED_AUTHENTICATION_SUFFIX, "true");
        } else {
            this.cleanAttemptedAuthentication(context);
        }
        return credentials;
    }

    protected abstract C retrieveCredentials(WebContext var1) throws RequiresHttpAction;

    protected String getStateParameter(WebContext webContext) {
        throw new UnsupportedOperationException("To be implemented in subclasses if required");
    }

    public boolean isIncludeClientNameInCallbackUrl() {
        return this.includeClientNameInCallbackUrl;
    }

    public void setIncludeClientNameInCallbackUrl(boolean includeClientNameInCallbackUrl) {
        this.includeClientNameInCallbackUrl = includeClientNameInCallbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public AjaxRequestResolver getAjaxRequestResolver() {
        return this.ajaxRequestResolver;
    }

    public void setAjaxRequestResolver(AjaxRequestResolver ajaxRequestResolver) {
        this.ajaxRequestResolver = ajaxRequestResolver;
    }

    public CallbackUrlResolver getCallbackUrlResolver() {
        return this.callbackUrlResolver;
    }

    public void setCallbackUrlResolver(CallbackUrlResolver callbackUrlResolver) {
        this.callbackUrlResolver = callbackUrlResolver;
    }
}

