/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.ClientFinder;
import org.pac4j.core.client.Clients;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;

public class DefaultClientFinder
implements ClientFinder {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<Client> find(Clients clients, WebContext context, String clientName) {
        ArrayList<Client> result = new ArrayList<Client>();
        if (!CommonHelper.isNotBlank(clientName)) return result;
        List<String> names = Arrays.asList(clientName.split(","));
        String clientNameOnRequest = context.getRequestParameter(clients.getClientNameParameter());
        if (clientNameOnRequest != null) {
            Client client = clients.findClient(context);
            String nameFound = client.getName();
            if (!names.contains(nameFound)) throw new TechnicalException("Client not allowed: " + nameFound);
            result.add(client);
            return result;
        } else {
            for (String name : names) {
                Client client = clients.findClient(name);
                result.add(client);
            }
        }
        return result;
    }
}

