/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.client;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Clients
extends InitializableObject {
    private static final Logger logger = LoggerFactory.getLogger(Clients.class);
    public static final String DEFAULT_CLIENT_NAME_PARAMETER = "client_name";
    private String clientNameParameter = "client_name";
    private List<Client> clients;
    private String callbackUrl = null;
    private Client defaultClient;

    public Clients() {
    }

    public Clients(String callbackUrl, List<Client> clients) {
        this.setCallbackUrl(callbackUrl);
        this.setClients(clients);
    }

    public Clients(String callbackUrl, Client ... clients) {
        this.setCallbackUrl(callbackUrl);
        this.setClients(clients);
    }

    public Clients(String callbackUrl, Client client) {
        this.setCallbackUrl(callbackUrl);
        this.setClients(Arrays.asList(client));
    }

    public Clients(List<Client> clients) {
        this.setClients(clients);
    }

    public Clients(Client ... clients) {
        this.setClients(clients);
    }

    public Clients(Client client) {
        this.setClients(Arrays.asList(client));
    }

    @Override
    protected void internalInit() {
        CommonHelper.assertNotNull("clients", this.getClients());
        HashSet<String> names = new HashSet<String>();
        for (Client client : this.getClients()) {
            String name = client.getName();
            if (names.contains(name)) {
                throw new TechnicalException("Duplicate name in clients: " + name);
            }
            names.add(name);
            if (!CommonHelper.isNotBlank(this.callbackUrl) || !(client instanceof IndirectClient)) continue;
            IndirectClient indirectClient = (IndirectClient)client;
            String indirectClientCallbackUrl = indirectClient.getCallbackUrl();
            if (indirectClientCallbackUrl == null) {
                indirectClient.setCallbackUrl(this.callbackUrl);
                indirectClientCallbackUrl = this.callbackUrl;
            }
            if (!indirectClient.isIncludeClientNameInCallbackUrl() || indirectClientCallbackUrl.indexOf(this.clientNameParameter + "=") >= 0) continue;
            indirectClient.setCallbackUrl(CommonHelper.addParameter(indirectClientCallbackUrl, this.clientNameParameter, name));
        }
    }

    public Client findClient(WebContext context) {
        String name = context.getRequestParameter(this.clientNameParameter);
        if (name == null && this.defaultClient != null) {
            return this.defaultClient;
        }
        CommonHelper.assertNotBlank("name", name);
        return this.findClient(name);
    }

    public Client findClient(String name) {
        this.init();
        for (Client client : this.getClients()) {
            if (!CommonHelper.areEquals(name, client.getName())) continue;
            return client;
        }
        String message = "No client found for name: " + name;
        throw new TechnicalException(message);
    }

    public <C extends Client> C findClient(Class<C> clazz) {
        this.init();
        if (clazz != null) {
            for (Client client : this.getClients()) {
                if (!clazz.isAssignableFrom(client.getClass())) continue;
                return (C)client;
            }
        }
        String message = "No client found for class: " + clazz;
        throw new TechnicalException(message);
    }

    public List<Client> findAllClients() {
        this.init();
        return this.getClients();
    }

    public String getClientNameParameter() {
        return this.clientNameParameter;
    }

    public void setClientNameParameter(String clientNameParameter) {
        this.clientNameParameter = clientNameParameter;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    @Deprecated
    public void setClientsList(List<Client> clients) {
        this.clients = clients;
    }

    public void setClients(List<Client> clients) {
        this.clients = clients;
    }

    public void setClients(Client ... clients) {
        this.clients = Arrays.asList(clients);
    }

    public List<Client> getClients() {
        return this.clients;
    }

    public String toString() {
        return CommonHelper.toString(this.getClass(), "callbackUrl", this.callbackUrl, "clientTypeParameter", this.clientNameParameter, "clients", this.getClients());
    }

    public void setDefaultClient(Client defaultClient) {
        this.defaultClient = defaultClient;
    }

    public Client getDefaultClient() {
        return this.defaultClient;
    }
}

