/*
  Copyright 2012 - 2015 pac4j organization
   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at
       http://www.apache.org/licenses/LICENSE-2.0
   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */
package org.pac4j.core.authorization.authorizer.csrf;

import org.pac4j.core.context.Pac4jConstants;
import org.pac4j.core.context.WebContext;

/**
 * Default CSRF token generator.
 *
 * @author Jerome Leleu
 * @since 1.8.0
 */
public class DefaultCsrfTokenGenerator implements CsrfTokenGenerator {

    @Override
    public String get(final WebContext context) {
        String token = (String) context.getSessionAttribute(Pac4jConstants.CSRF_TOKEN);
        if (token == null) {
            synchronized (this) {
                token = (String) context.getSessionAttribute(Pac4jConstants.CSRF_TOKEN);
                if (token == null) {
                    token = java.util.UUID.randomUUID().toString();
                    context.setSessionAttribute(Pac4jConstants.CSRF_TOKEN, token);
                }
            }
        }
        return token;
    }
}
