/*
 * Decompiled with CFR 0.152.
 */
package org.oxerr.spring.boot.daemon;

import java.util.logging.Logger;
import org.apache.commons.daemon.Daemon;
import org.apache.commons.daemon.DaemonContext;
import org.apache.commons.daemon.DaemonInitException;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ConfigurableApplicationContext;

public abstract class SpringApplicationDaemon
implements Daemon {
    private final Logger log = Logger.getLogger(SpringApplicationDaemon.class.getName());
    private SpringApplication application;
    private ConfigurableApplicationContext context;

    public void init(DaemonContext context) throws DaemonInitException, Exception {
        this.log.info("Initializing...");
        this.application = this.initSpringApplication(context);
        this.log.info("Initialized.");
    }

    public void start() throws Exception {
        this.log.info("Starting...");
        this.context = this.application.run(new String[0]);
        this.log.info("Started.");
    }

    public void stop() throws Exception {
        this.log.info("Stopping...");
        this.context.stop();
        this.log.info("Stopped.");
    }

    public void destroy() {
        this.log.info("Destroying...");
        this.context.close();
        this.log.info("Destroyed.");
    }

    protected abstract SpringApplication initSpringApplication(DaemonContext var1);
}

