/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.ui.prefs;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.owasp.jbrofuzz.JBroFuzz;
import org.owasp.jbrofuzz.ui.prefs.AbstractPrefsPanel;
import org.owasp.jbrofuzz.ui.prefs.PrefDialog;
import org.owasp.jbrofuzz.version.JBroFuzzPrefs;

class WirePPanel
extends AbstractPrefsPanel {
    private static final long serialVersionUID = -6794971039096994742L;
    private final JCheckBox[] checkBoxes = new JCheckBox[JBroFuzzPrefs.FUZZINGONTHEWIRE.length];
    private static final String[] RADIONAMES = new String[]{"Nothing", "Requests", "Responses", "Both"};
    private final JRadioButton[] rButton1 = new JRadioButton[RADIONAMES.length];

    protected WirePPanel(final PrefDialog dialog) {
        super("Fuzzing: On the Wire");
        for (int i = 0; i < JBroFuzzPrefs.FUZZINGONTHEWIRE.length; ++i) {
            if (i == 1) continue;
            boolean boolEntry = JBroFuzz.PREFS.getBoolean(JBroFuzzPrefs.FUZZINGONTHEWIRE[i].getId(), true);
            this.checkBoxes[i] = new JCheckBox(JBroFuzzPrefs.FUZZINGONTHEWIRE[i].getTitle(), boolEntry);
            this.checkBoxes[i].setToolTipText(JBroFuzzPrefs.FUZZINGONTHEWIRE[i].getTooltip());
            this.checkBoxes[i].setBorderPaintedFlat(true);
            this.checkBoxes[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.setApplyEnabled(true);
                }
            });
            this.add(this.checkBoxes[i]);
            this.add(Box.createRigidArea(new Dimension(0, 20)));
        }
        ButtonGroup group = new ButtonGroup();
        JPanel radioPanel = new JPanel(new FlowLayout(1, 25, 0));
        radioPanel.setAlignmentX(0.0f);
        radioPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(JBroFuzzPrefs.FUZZINGONTHEWIRE[1].getTitle()), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        radioPanel.setToolTipText(JBroFuzzPrefs.FUZZINGONTHEWIRE[1].getTooltip());
        int showOnTheWire = JBroFuzz.PREFS.getInt(JBroFuzzPrefs.FUZZINGONTHEWIRE[1].getId(), 3);
        for (int j = 0; j < RADIONAMES.length; ++j) {
            this.rButton1[j] = new JRadioButton(RADIONAMES[j]);
            group.add(this.rButton1[j]);
            this.rButton1[j].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.setApplyEnabled(true);
                }
            });
            radioPanel.add(this.rButton1[j]);
            if (showOnTheWire != j) continue;
            this.rButton1[j].setSelected(true);
        }
        this.add(radioPanel);
        this.add(Box.createRigidArea(new Dimension(0, 300)));
    }

    @Override
    public void apply() {
        for (int i = 0; i < this.checkBoxes.length; ++i) {
            if (i == 1) continue;
            JBroFuzz.PREFS.putBoolean(JBroFuzzPrefs.FUZZINGONTHEWIRE[i].getId(), this.checkBoxes[i].isSelected());
        }
        for (int j = 0; j < this.rButton1.length; ++j) {
            if (!this.rButton1[j].isSelected()) continue;
            JBroFuzz.PREFS.putInt(JBroFuzzPrefs.FUZZINGONTHEWIRE[1].getId(), j);
        }
    }
}

