/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.ui.prefs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.owasp.jbrofuzz.JBroFuzz;
import org.owasp.jbrofuzz.ui.prefs.AbstractPrefsPanel;
import org.owasp.jbrofuzz.ui.prefs.PrefDialog;
import org.owasp.jbrofuzz.version.JBroFuzzPrefs;

public class UpdatePPanel
extends AbstractPrefsPanel {
    private static final long serialVersionUID = 6601607213870707446L;
    private final JCheckBox proxyEnabledBox;
    private final JCheckBox proxyReqAuthBox;
    private final JTextField hostTextField;
    private final JTextField portTextField;
    private final JTextField userTextField;
    private final JTextField passTextField;
    private final JComboBox authTypeBox;
    private static final Dimension V_SPACE = new Dimension(0, 20);

    protected UpdatePPanel(final PrefDialog dialog) {
        super("Check for Updates");
        boolean proxyEnabled = JBroFuzz.PREFS.getBoolean(JBroFuzzPrefs.UPDATE[0].getId(), false);
        this.proxyEnabledBox = new JCheckBox(JBroFuzzPrefs.UPDATE[0].getTitle(), proxyEnabled);
        this.proxyEnabledBox.setToolTipText(JBroFuzzPrefs.UPDATE[0].getTooltip());
        this.proxyEnabledBox.setBorderPaintedFlat(true);
        String hostEntry = JBroFuzz.PREFS.get(JBroFuzzPrefs.UPDATE[1].getId(), "");
        this.hostTextField = new JTextField(hostEntry);
        this.hostTextField.setToolTipText(JBroFuzzPrefs.UPDATE[1].getTooltip());
        this.hostTextField.setFont(new Font("Verdana", 0, 12));
        this.hostTextField.setMargin(new Insets(1, 1, 1, 1));
        String portEntry = JBroFuzz.PREFS.get(JBroFuzzPrefs.UPDATE[2].getId(), "");
        this.portTextField = new JTextField(portEntry);
        this.portTextField.setToolTipText(JBroFuzzPrefs.UPDATE[2].getTooltip());
        this.portTextField.setFont(new Font("Verdana", 0, 12));
        this.portTextField.setMargin(new Insets(1, 1, 1, 1));
        boolean proxyReqAuth = JBroFuzz.PREFS.getBoolean(JBroFuzzPrefs.UPDATE[3].getId(), false);
        this.proxyReqAuthBox = new JCheckBox(JBroFuzzPrefs.UPDATE[3].getTitle(), proxyReqAuth);
        this.proxyReqAuthBox.setToolTipText(JBroFuzzPrefs.UPDATE[3].getTooltip());
        this.proxyReqAuthBox.setBorderPaintedFlat(true);
        String[] authTypeArray = new String[]{"HTTP"};
        this.authTypeBox = new JComboBox<String>(authTypeArray);
        this.authTypeBox.setToolTipText(JBroFuzzPrefs.UPDATE[4].getTooltip());
        String userEntry = JBroFuzz.PREFS.get(JBroFuzzPrefs.UPDATE[5].getId(), "");
        this.userTextField = new JTextField(userEntry);
        this.userTextField.setToolTipText(JBroFuzzPrefs.UPDATE[5].getTooltip());
        this.userTextField.setFont(new Font("Verdana", 0, 12));
        this.userTextField.setMargin(new Insets(1, 1, 1, 1));
        this.userTextField.setPreferredSize(new Dimension(80, 20));
        String passEntry = JBroFuzz.PREFS.get(JBroFuzzPrefs.UPDATE[6].getId(), "");
        this.passTextField = new JTextField(passEntry);
        this.passTextField.setToolTipText(JBroFuzzPrefs.UPDATE[6].getTooltip());
        this.passTextField.setFont(new Font("Verdana", 0, 12));
        this.passTextField.setMargin(new Insets(1, 1, 1, 1));
        this.passTextField.setPreferredSize(new Dimension(80, 20));
        JPanel hostPortPanel = new JPanel(new GridBagLayout());
        hostPortPanel.setAlignmentX(0.0f);
        hostPortPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(JBroFuzzPrefs.UPDATE[1].getTitle() + " / " + JBroFuzzPrefs.UPDATE[2].getTitle()), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 4;
        c.ipadx = 250;
        hostPortPanel.add((Component)this.hostTextField, c);
        c.fill = 2;
        c.weightx = 0.5;
        c.gridx = 4;
        c.gridy = 0;
        c.gridwidth = 1;
        c.ipadx = 0;
        hostPortPanel.add((Component)this.portTextField, c);
        JPanel userPassPanel = new JPanel(new FlowLayout(0, 15, 0));
        userPassPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Authentication"), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        userPassPanel.add(this.authTypeBox);
        userPassPanel.add(new JLabel(JBroFuzzPrefs.UPDATE[5].getTitle()));
        userPassPanel.add(this.userTextField);
        userPassPanel.add(new JLabel(JBroFuzzPrefs.UPDATE[6].getTitle()));
        userPassPanel.add(this.passTextField);
        userPassPanel.setAlignmentX(0.0f);
        if (this.proxyEnabledBox.isSelected()) {
            this.hostTextField.setEnabled(true);
            this.portTextField.setEnabled(true);
            this.proxyReqAuthBox.setEnabled(true);
            this.authTypeBox.setEnabled(true);
            this.userTextField.setEnabled(true);
            this.passTextField.setEnabled(true);
        } else {
            this.hostTextField.setEnabled(false);
            this.portTextField.setEnabled(false);
            this.proxyReqAuthBox.setEnabled(false);
            this.authTypeBox.setEnabled(false);
            this.userTextField.setEnabled(false);
            this.passTextField.setEnabled(false);
        }
        if (this.proxyReqAuthBox.isSelected()) {
            this.authTypeBox.setEnabled(true);
            this.userTextField.setEnabled(true);
            this.passTextField.setEnabled(true);
        } else {
            this.authTypeBox.setEnabled(false);
            this.userTextField.setEnabled(false);
            this.passTextField.setEnabled(false);
        }
        this.proxyEnabledBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent1) {
                if (UpdatePPanel.this.proxyEnabledBox.isSelected()) {
                    UpdatePPanel.this.hostTextField.setEnabled(true);
                    UpdatePPanel.this.portTextField.setEnabled(true);
                    UpdatePPanel.this.proxyReqAuthBox.setEnabled(true);
                    UpdatePPanel.this.authTypeBox.setEnabled(true);
                    UpdatePPanel.this.userTextField.setEnabled(true);
                    UpdatePPanel.this.passTextField.setEnabled(true);
                    if (UpdatePPanel.this.proxyReqAuthBox.isSelected()) {
                        UpdatePPanel.this.authTypeBox.setEnabled(true);
                        UpdatePPanel.this.userTextField.setEnabled(true);
                        UpdatePPanel.this.passTextField.setEnabled(true);
                    } else {
                        UpdatePPanel.this.authTypeBox.setEnabled(false);
                        UpdatePPanel.this.userTextField.setEnabled(false);
                        UpdatePPanel.this.passTextField.setEnabled(false);
                    }
                } else {
                    UpdatePPanel.this.hostTextField.setEnabled(false);
                    UpdatePPanel.this.portTextField.setEnabled(false);
                    UpdatePPanel.this.proxyReqAuthBox.setEnabled(false);
                    UpdatePPanel.this.authTypeBox.setEnabled(false);
                    UpdatePPanel.this.userTextField.setEnabled(false);
                    UpdatePPanel.this.passTextField.setEnabled(false);
                }
                dialog.setApplyEnabled(true);
            }
        });
        this.proxyReqAuthBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent2) {
                if (UpdatePPanel.this.proxyReqAuthBox.isSelected()) {
                    UpdatePPanel.this.authTypeBox.setEnabled(true);
                    UpdatePPanel.this.userTextField.setEnabled(true);
                    UpdatePPanel.this.passTextField.setEnabled(true);
                } else {
                    UpdatePPanel.this.authTypeBox.setEnabled(false);
                    UpdatePPanel.this.userTextField.setEnabled(false);
                    UpdatePPanel.this.passTextField.setEnabled(false);
                }
                dialog.setApplyEnabled(true);
            }
        });
        this.add(this.proxyEnabledBox);
        this.add(Box.createRigidArea(V_SPACE));
        this.add(hostPortPanel);
        this.add(Box.createRigidArea(V_SPACE));
        this.add(this.proxyReqAuthBox);
        this.add(userPassPanel);
        this.add(Box.createRigidArea(new Dimension(0, 300)));
    }

    @Override
    protected void apply() {
        JBroFuzz.PREFS.putBoolean(JBroFuzzPrefs.UPDATE[0].getId(), this.proxyEnabledBox.isSelected());
        if (this.proxyEnabledBox.isSelected()) {
            JBroFuzz.PREFS.put(JBroFuzzPrefs.UPDATE[1].getId(), this.hostTextField.getText());
            JBroFuzz.PREFS.put(JBroFuzzPrefs.UPDATE[2].getId(), this.portTextField.getText());
            JBroFuzz.PREFS.putBoolean(JBroFuzzPrefs.UPDATE[3].getId(), this.proxyReqAuthBox.isSelected());
            if (this.proxyReqAuthBox.isSelected()) {
                JBroFuzz.PREFS.put(JBroFuzzPrefs.UPDATE[5].getId(), this.userTextField.getText());
                JBroFuzz.PREFS.put(JBroFuzzPrefs.UPDATE[6].getId(), this.passTextField.getText());
            }
        }
    }
}

