/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.system;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.prefs.Preferences;
import org.owasp.jbrofuzz.version.JBroFuzzPrefs;

public final class Logger {
    private static final Preferences PREFS = Preferences.userRoot().node("owasp/jbrofuzz");
    private static File logDirectory;

    private Logger() {
    }

    protected static File getLogFile() throws IOException {
        Logger.checkOrCreateDirs();
        Date currentTime = new Date();
        SimpleDateFormat dateTime = new SimpleDateFormat("dd.MM.yyyy", new Locale("en"));
        String fileName = dateTime.format(currentTime) + "-log.txt";
        File toWrite = new File(logDirectory, fileName);
        return toWrite;
    }

    private static void checkOrCreateDirs() throws IOException {
        boolean success;
        boolean saveElsewhere = PREFS.getBoolean(JBroFuzzPrefs.DIRS[1].getId(), true);
        String dirString = saveElsewhere ? PREFS.get(JBroFuzzPrefs.DIRS[0].getId(), System.getProperty("user.dir")) : System.getProperty("user.dir");
        new File(dirString);
        StringBuffer directoryLocation = new StringBuffer();
        directoryLocation.append(dirString);
        directoryLocation.append(File.separator);
        directoryLocation.append("jbrofuzz");
        directoryLocation.append(File.separator);
        directoryLocation.append("log");
        logDirectory = new File(directoryLocation.toString());
        if (!logDirectory.exists() && !(success = logDirectory.mkdirs())) {
            throw new IOException();
        }
    }

    public static void log(String str, int level) {
        Date currentTime = new Date();
        SimpleDateFormat dateTime = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss", new Locale("en"));
        StringBuffer toLog = new StringBuffer();
        toLog.append('[');
        toLog.append(dateTime.format(currentTime));
        toLog.append(']');
        if (level <= 0) {
            toLog.append(" [INFO] ");
        } else if (level == 1) {
            toLog.append(" [OPPR] ");
        } else if (level == 2) {
            toLog.append(" [WARN] ");
        } else if (level == 3) {
            toLog.append(" [SHOT] ");
        } else {
            toLog.append(" [ERRR] ");
        }
        toLog.append(str);
        toLog.append('\n');
        try {
            Logger.appendToLogFile(toLog.toString());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static void appendToLogFile(String error) throws IOException {
        Logger.checkOrCreateDirs();
        Date currentTime = new Date();
        SimpleDateFormat dateTime = new SimpleDateFormat("dd.MM.yyyy", new Locale("en"));
        String fileName = dateTime.format(currentTime) + "-log.txt";
        File toWrite = new File(logDirectory, fileName);
        try {
            FileWriter fWriter = new FileWriter(toWrite, true);
            fWriter.write(error);
            fWriter.close();
        }
        catch (IOException e) {
            throw new IOException();
        }
    }

    protected static ArrayList<String> readLogFile(long oldLength) throws FileNotFoundException, IOException {
        String line;
        RandomAccessFile rFile = new RandomAccessFile(Logger.getLogFile(), "r");
        rFile.seek(oldLength);
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = rFile.readLine()) != null) {
            lines.add(line);
        }
        return lines;
    }

    protected static void log() {
        String[] info;
        Logger.log("[System Health Check Start]", 2);
        Logger.log("[System Info Start]", 1);
        String systemInfo = "  [Java]=    Vendor:  " + System.getProperty("java.vendor") + "=    Version: " + System.getProperty("java.version") + "=    Installed at: " + System.getProperty("java.home") + "=    Website: " + System.getProperty("java.vendor.url") + "=  [User]=" + "    User: " + System.getProperty("user.name") + "=    Home dir: " + System.getProperty("user.home") + "=    Current dir: " + System.getProperty("user.dir") + "=  [O/S]=    Name: " + System.getProperty("os.name") + "=    Version: " + System.getProperty("os.version") + "=    Architecture: " + System.getProperty("os.arch") + "=";
        for (String element : info = systemInfo.split("=")) {
            Logger.log(element, 0);
        }
        Logger.log("[System Info End]", 1);
        Logger.log("[Testing Warning Levels Start]", 1);
        Logger.log("  Informational - no issue - no tab counter increment", 0);
        Logger.log("  Opperational - operation changed - no tab counter increment", 1);
        Logger.log("  Warning - still functional - an operation change did not complete", 2);
        Logger.log("  Shout - controlable error occured - bad news but not the worst", 3);
        Logger.log("  Error - something that was meant to happen, didn't complete as expected", 4);
        Logger.log("[Testing Warning Levels End]", 1);
        Logger.log("[System Health Check End]", 2);
    }
}

