/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.io;

import java.util.Vector;
import org.owasp.jbrofuzz.JBroFuzz;
import org.owasp.jbrofuzz.db.DBAdaptor;
import org.owasp.jbrofuzz.db.DBAdaptorFactory;
import org.owasp.jbrofuzz.fuzz.MessageContainer;
import org.owasp.jbrofuzz.graph.FileSystemTreeNode;
import org.owasp.jbrofuzz.graph.GraphingPanel;
import org.owasp.jbrofuzz.graph.utils.DBWalker;
import org.owasp.jbrofuzz.graph.utils.JohnyWalker;
import org.owasp.jbrofuzz.io.FileHandler;
import org.owasp.jbrofuzz.io.StorageInterface;
import org.owasp.jbrofuzz.system.Logger;
import org.owasp.jbrofuzz.ui.JBroFuzzWindow;
import org.owasp.jbrofuzz.version.JBroFuzzPrefs;

public class StorageHandler
implements StorageInterface {
    private FileHandler mFileHandler;
    private DBAdaptor mdbAdaptor;
    private String sessionId;

    public StorageHandler() {
        String dbType = JBroFuzz.PREFS.get(JBroFuzzPrefs.DBSETTINGS[11].getId(), "-1");
        if (dbType.equals("SQLite") || dbType.equals("CouchDB")) {
            this.mdbAdaptor = DBAdaptorFactory.getInstance();
        } else {
            this.mFileHandler = new FileHandler();
        }
    }

    @Override
    public void createNewLocation() {
        if (this.mFileHandler != null) {
            this.mFileHandler.createNewLocation();
        }
    }

    @Override
    public String getLocationCanonicalPath() {
        String canonicalPath = "";
        if (this.mFileHandler != null) {
            canonicalPath = this.mFileHandler.getLocationCanonicalPath();
        }
        return canonicalPath;
    }

    @Override
    public String getFuzzURIString(String fileName) {
        String fuzzerURI = "";
        if (this.mFileHandler != null) {
            fuzzerURI = this.mFileHandler.getFuzzURIString(fileName);
        }
        return fuzzerURI;
    }

    @Override
    public String getLocationURIString() {
        String locationURI = "";
        if (this.mFileHandler != null) {
            locationURI = this.mFileHandler.getLocationURIString();
        }
        return locationURI;
    }

    @Override
    public void writeFuzzFile(MessageContainer outputMessage, String sessionId) {
        this.sessionId = sessionId != null && sessionId.length() != 0 ? sessionId : JBroFuzz.PREFS.get("sessionId", "");
        if (this.mFileHandler != null) {
            this.mFileHandler.writeFuzzFile(outputMessage, this.sessionId);
        }
        if (this.mdbAdaptor != null) {
            this.mdbAdaptor.store(outputMessage, this.sessionId);
        }
    }

    @Override
    public Vector<MessageContainer> readFuzzFile(String name, String sessionId, JBroFuzzWindow mWindow) {
        if (this.mFileHandler != null) {
            Logger.log("Reading from file not implemented yet.", 3);
        }
        if (this.mdbAdaptor != null) {
            if (sessionId != null) {
                this.sessionId = sessionId;
            }
            return this.mdbAdaptor.read(name, this.sessionId, mWindow);
        }
        return null;
    }

    @Override
    public String[] readTableRow(String sqlStatement) {
        if (this.mFileHandler != null) {
            Logger.log("reading form file not implemented", 3);
        }
        if (this.mdbAdaptor != null) {
            return this.mdbAdaptor.executeQuery(sqlStatement);
        }
        return null;
    }

    @Override
    public FileSystemTreeNode getSystemTreeNodeFromWalker(GraphingPanel gPanel) {
        String dbType = JBroFuzz.PREFS.get(JBroFuzzPrefs.DBSETTINGS[11].getId(), "-1");
        if (dbType.equals("SQLite") || dbType.equals("CouchDB")) {
            this.mdbAdaptor = DBAdaptorFactory.getInstance();
            DBWalker test = this.mdbAdaptor.getWalker(gPanel);
            test.run();
            return test.getFileSystemTreeNode();
        }
        JohnyWalker test = new JohnyWalker(gPanel);
        test.run();
        return test.getFileSystemTreeNode();
    }
}

