/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.owasp.jbrofuzz.ui.JBroFuzzWindow;
import org.owasp.jbrofuzz.version.ImageCreator;
import org.owasp.jbrofuzz.version.JBroFuzzFormat;

public class Faq
extends JFrame
implements TreeSelectionListener {
    private static final long serialVersionUID = 4301858021356404678L;
    private static final int SIZE_X = 650;
    private static final int SIZE_Y = 400;
    private static final String[] NODENAMES = new String[]{"FAQ", "System Requirements", "Java", "Installation", "Files & Directories", "Fuzzers & Payloads", "Older Features/Versions", "Proxy Settings"};
    private static boolean faqShowing = false;
    private JTree tree;
    private JEditorPane faqEditorPane;
    private JScrollPane faqScrollPane;
    private JSplitPane splitPane;
    private URL[] faqURL;

    public Faq(JBroFuzzWindow parent) {
        if (faqShowing) {
            return;
        }
        faqShowing = true;
        this.setTitle(" JBroFuzz - Frequently Asked Questions ");
        this.setIconImage(ImageCreator.IMG_FRAME.getImage());
        this.setLayout(new BorderLayout());
        this.setFont(new Font("SansSerif", 0, 12));
        this.faqURL = new URL[NODENAMES.length];
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(NODENAMES[0]);
        for (int i = 0; i < NODENAMES.length; ++i) {
            this.faqURL[i] = ClassLoader.getSystemClassLoader().getResource("help/faq-0" + i + ".html");
            if (i <= 0) continue;
            top.add(new DefaultMutableTreeNode(NODENAMES[i]));
        }
        this.tree = new JTree(top);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        JScrollPane treeView = new JScrollPane(this.tree);
        try {
            this.faqEditorPane = new JEditorPane(this.faqURL[0]);
        }
        catch (IOException e1) {
            this.faqEditorPane = new JEditorPane();
            this.faqEditorPane.setText("Frequently Asked Questions file could not be located.");
        }
        this.faqScrollPane = new JScrollPane(this.faqEditorPane);
        this.splitPane = new JSplitPane(1);
        this.splitPane.setLeftComponent(treeView);
        this.splitPane.setRightComponent(this.faqScrollPane);
        this.splitPane.setOneTouchExpandable(false);
        this.faqScrollPane.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        treeView.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        this.splitPane.setDividerLocation(100);
        this.splitPane.setPreferredSize(new Dimension(100, 0));
        this.getContentPane().add((Component)this.splitPane, "Center");
        JButton ok = new JButton("  OK  ");
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 15, 15));
        buttonPanel.add(ok);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                faqShowing = false;
                Faq.this.dispose();
            }
        });
        this.getContentPane().add((Component)buttonPanel, "South");
        this.splitPane.setDividerLocation(150);
        this.setLocation(parent.getLocation().x + (parent.getWidth() - 650) / 2, parent.getLocation().y + (parent.getHeight() - 400) / 2);
        this.setSize(650, 400);
        this.setMinimumSize(new Dimension(325, 200));
        this.setResizable(true);
        this.setVisible(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                faqShowing = false;
                Faq.this.dispose();
            }
        });
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        String s = node.toString();
        for (int i = 0; i < NODENAMES.length; ++i) {
            if (!s.equalsIgnoreCase(NODENAMES[i])) continue;
            try {
                this.faqEditorPane.setPage(this.faqURL[i]);
            }
            catch (IOException e1) {
                this.faqEditorPane.setText("Could not find page: " + this.faqURL[i]);
            }
            this.faqScrollPane.setViewportView(this.faqEditorPane);
            this.splitPane.setRightComponent(this.faqScrollPane);
            this.splitPane.setDividerLocation(150);
        }
    }
}

