/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.graph.utils;

import org.owasp.jbrofuzz.graph.FileSystemTreeNode;
import org.owasp.jbrofuzz.graph.GraphingPanel;
import org.owasp.jbrofuzz.io.StorageHandler;
import org.owasp.jbrofuzz.system.Logger;

public class DBWalker {
    private FileSystemTreeNode master;
    private String[] sessionids = null;
    private final GraphingPanel gPanel;
    private int fileCount;
    private int dirCount;

    public DBWalker(GraphingPanel gPanel) {
        StorageHandler sh = new StorageHandler();
        this.sessionids = sh.readTableRow("Select sessionId from session");
        Logger.log("received: " + this.sessionids.length + " sessionIds.", 3);
        this.master = new FileSystemTreeNode("DATABASE");
        for (int i = 0; i < this.sessionids.length; ++i) {
            this.master.add(new FileSystemTreeNode(this.sessionids[i]));
        }
        this.gPanel = gPanel;
        this.master.setAsDirectory();
        Logger.log("Constructor: DBWalker: SessionIds: " + this.sessionids, 3);
        this.fileCount = 0;
        this.dirCount = 0;
    }

    public FileSystemTreeNode getFileSystemTreeNode() {
        return this.master;
    }

    public int getMaximum() {
        if (this.sessionids != null) {
            return this.sessionids.length;
        }
        return 0;
    }

    private void listAllFiles(FileSystemTreeNode parent) {
        if (this.gPanel.isStoppedEnabled()) {
            return;
        }
        StorageHandler sh = new StorageHandler();
        this.sessionids = sh.readTableRow("Select sessionId from session");
        for (int i = 0; i < this.sessionids.length; ++i) {
            parent.add(new FileSystemTreeNode(this.sessionids[i]));
        }
        Logger.log("listAllFiles: SessionIds: " + this.sessionids, 3);
        this.dirCount = 1;
        this.fileCount = this.sessionids.length;
    }

    public void run() {
        this.listAllFiles(this.master);
        this.gPanel.toConsole("Total Files: " + this.fileCount);
        this.gPanel.toConsole("Total Directories: " + this.dirCount);
    }
}

