/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.fuzz.ui;

import com.Ostermiller.util.Browser;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.owasp.jbrofuzz.JBroFuzz;
import org.owasp.jbrofuzz.encode.EncoderHashCore;
import org.owasp.jbrofuzz.fuzz.ui.FuzzersTableModel;
import org.owasp.jbrofuzz.fuzz.ui.FuzzingPanel;
import org.owasp.jbrofuzz.system.Logger;
import org.owasp.jbrofuzz.ui.viewers.PropertiesViewer;
import org.owasp.jbrofuzz.ui.viewers.WindowViewerFrame;
import org.owasp.jbrofuzz.version.ImageCreator;
import org.owasp.jbrofuzz.version.JBroFuzzPrefs;

public final class RightClickPopups {
    private RightClickPopups() {
    }

    public static void rightClickOutputTable(final FuzzingPanel mFuzzingPanel, final JTable area) {
        final JPopupMenu popmenu = new JPopupMenu();
        final JMenuItem i5_open_folder = new JMenuItem("Open Containing Folder");
        final JMenuItem i0_open_browser = new JMenuItem("Open in Browser");
        final JMenuItem i1_open_viewer = new JMenuItem("Open in Viewer");
        final JMenuItem i2_clear = new JMenuItem("Clear All Output");
        final JMenuItem i3_copy = new JMenuItem("Copy");
        final JMenuItem i4_select = new JMenuItem("Select All");
        i0_open_browser.setIcon(ImageCreator.IMG_OPENINBROWSER);
        i2_clear.setIcon(ImageCreator.IMG_CLEAR);
        i3_copy.setIcon(ImageCreator.IMG_COPY);
        i4_select.setIcon(ImageCreator.IMG_SELECTALL);
        popmenu.add(i5_open_folder);
        popmenu.add(i0_open_browser);
        popmenu.add(i1_open_viewer);
        popmenu.addSeparator();
        popmenu.add(i2_clear);
        popmenu.addSeparator();
        popmenu.add(i3_copy);
        popmenu.add(i4_select);
        i5_open_folder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int c = area.getSelectedRow();
                if (c < 0) {
                    return;
                }
                String sURI = mFuzzingPanel.getFrame().getJBroFuzz().getStorageHandler().getLocationURIString();
                Browser.init();
                try {
                    Browser.displayURL((String)sURI);
                }
                catch (IOException ex) {
                    Logger.log("Could not launch link in external browser", 3);
                }
            }
        });
        i1_open_viewer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int c = area.getSelectedRow();
                if (c < 0) {
                    return;
                }
                String name = (String)area.getModel().getValueAt(area.convertRowIndexToModel(c), 0);
                Logger.log("Calling WindowViewer with name: " + name, 3);
                new WindowViewerFrame(mFuzzingPanel, name);
            }
        });
        i0_open_browser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int c = area.getSelectedRow();
                if (c < 0) {
                    return;
                }
                String fileName = (String)area.getModel().getValueAt(area.convertRowIndexToModel(c), 0) + ".html";
                String s = mFuzzingPanel.getFrame().getJBroFuzz().getStorageHandler().getFuzzURIString(fileName);
                Browser.init();
                try {
                    Browser.displayURL((String)s);
                }
                catch (IOException ex) {
                    Logger.log("Could not launch link in external browser", 3);
                }
            }
        });
        i2_clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (mFuzzingPanel.isStopped()) {
                    mFuzzingPanel.clearOutputTable();
                    mFuzzingPanel.getFrame().getJBroFuzz().getStorageHandler().createNewLocation();
                } else {
                    int choice = JOptionPane.showConfirmDialog(mFuzzingPanel.getFrame(), "Fuzzing Session Running. Stop Fuzzing?", " JBroFuzz - Stop ", 0);
                    if (choice == 0) {
                        mFuzzingPanel.stop();
                        mFuzzingPanel.clearOutputTable();
                        mFuzzingPanel.getFrame().getJBroFuzz().getStorageHandler().createNewLocation();
                    }
                }
            }
        });
        i3_copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selection;
                StringBuffer selectionBuffer = new StringBuffer();
                for (int element : selection = area.getSelectedRows()) {
                    for (int i = 0; i < area.getColumnCount(); ++i) {
                        selectionBuffer.append(area.getModel().getValueAt(area.convertRowIndexToModel(element), i));
                        if (i >= area.getColumnCount() - 1) continue;
                        selectionBuffer.append(',');
                    }
                    selectionBuffer.append('\n');
                }
                JTextArea myTempArea = new JTextArea();
                myTempArea.setText(selectionBuffer.toString());
                myTempArea.selectAll();
                myTempArea.copy();
            }
        });
        i4_select.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                area.selectAll();
            }
        });
        MouseAdapter myOutputMouseAdapter = new MouseAdapter(){

            private void checkForTriggerEvent(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    Point point = e.getPoint();
                    int row = area.rowAtPoint(point);
                    if (row < 0) {
                        i0_open_browser.setEnabled(false);
                        i1_open_viewer.setEnabled(false);
                        i2_clear.setEnabled(true);
                        i3_copy.setEnabled(false);
                        i4_select.setEnabled(false);
                        i5_open_folder.setEnabled(false);
                    } else {
                        i0_open_browser.setEnabled(true);
                        i1_open_viewer.setEnabled(true);
                        i2_clear.setEnabled(true);
                        i3_copy.setEnabled(true);
                        i4_select.setEnabled(true);
                        i5_open_folder.setEnabled(true);
                        if (area.getSelectedRows().length < 2) {
                            area.getSelectionModel().setSelectionInterval(row, row);
                        }
                    }
                    area.requestFocus();
                    popmenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.checkForTriggerEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.checkForTriggerEvent(e);
            }
        };
        area.getTableHeader().addMouseListener(myOutputMouseAdapter);
        area.addMouseListener(myOutputMouseAdapter);
    }

    private static JMenu buildEncodeMenu(final JTextComponent area) {
        JMenu encodeMenu = new JMenu("Encode");
        JMenuItem[] encodeList = new JMenuItem[EncoderHashCore.CODES.length];
        for (int i = 0; i < encodeList.length; ++i) {
            final int index = i;
            JMenuItem encode = new JMenuItem(EncoderHashCore.CODES[i]);
            encodeMenu.add(encode);
            encode.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    String toEncode = area.getSelectedText();
                    if (toEncode != null) {
                        String encoded = EncoderHashCore.encode(toEncode, EncoderHashCore.CODES[index]);
                        area.replaceSelection(encoded);
                    }
                }
            });
        }
        return encodeMenu;
    }

    private static JMenu buildDecodeMenu(final JTextComponent area) {
        JMenu decodeMenu = new JMenu("Decode");
        JMenuItem[] decodeList = new JMenuItem[EncoderHashCore.CODES.length];
        for (int i = 0; i < decodeList.length; ++i) {
            final int index = i;
            if (!EncoderHashCore.isDecoded(EncoderHashCore.CODES[index])) continue;
            JMenuItem decode = new JMenuItem(EncoderHashCore.CODES[i]);
            decodeMenu.add(decode);
            decode.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    String toDecode = area.getSelectedText();
                    if (toDecode != null) {
                        String decoded = EncoderHashCore.decode(toDecode, EncoderHashCore.CODES[index]);
                        area.replaceSelection(decoded);
                    }
                }
            });
        }
        return decodeMenu;
    }

    public static void rightClickRequestTextComponent(final FuzzingPanel mFuzzingPanel, final JTextComponent area) {
        final JPopupMenu popmenu = new JPopupMenu();
        JMenu encodeMenu = RightClickPopups.buildEncodeMenu(area);
        JMenu decodeMenu = RightClickPopups.buildDecodeMenu(area);
        JMenuItem i0_add = new JMenuItem("Add");
        JMenuItem i1_cut = new JMenuItem("Cut");
        JMenuItem i2_copy = new JMenuItem("Copy");
        JMenuItem i3_paste = new JMenuItem("Paste");
        JMenuItem i4_select = new JMenuItem("Select All");
        i0_add.setIcon(ImageCreator.IMG_ADD);
        i1_cut.setIcon(ImageCreator.IMG_CUT);
        i2_copy.setIcon(ImageCreator.IMG_COPY);
        i3_paste.setIcon(ImageCreator.IMG_PASTE);
        i4_select.setIcon(ImageCreator.IMG_SELECTALL);
        popmenu.add(i0_add);
        popmenu.addSeparator();
        popmenu.add(i1_cut);
        popmenu.add(i2_copy);
        popmenu.add(i3_paste);
        popmenu.add(encodeMenu);
        popmenu.add(decodeMenu);
        popmenu.addSeparator();
        popmenu.add(i4_select);
        if (!area.isEditable()) {
            i3_paste.setEnabled(false);
        }
        i0_add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mFuzzingPanel.add();
            }
        });
        i1_cut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                area.cut();
            }
        });
        i2_copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                area.copy();
            }
        });
        i3_paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (area.isEditable()) {
                    area.paste();
                }
            }
        });
        i4_select.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                area.selectAll();
            }
        });
        area.addMouseListener(new MouseAdapter(){

            private void checkForTriggerEvent(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    area.requestFocus();
                    popmenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.checkForTriggerEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.checkForTriggerEvent(e);
            }
        });
    }

    public static void rightClickOnTheWireTextComponent(final FuzzingPanel mFuzzingPanel, final JTextArea area) {
        final JPopupMenu popmenu = new JPopupMenu();
        JMenuItem i0_clear = new JMenuItem("Clear");
        JMenuItem i1_cut = new JMenuItem("Cut");
        JMenuItem i2_copy = new JMenuItem("Copy");
        JMenuItem i3_paste = new JMenuItem("Paste");
        JMenuItem i4_select = new JMenuItem("Select All");
        i0_clear.setIcon(ImageCreator.IMG_CLEAR);
        i1_cut.setIcon(ImageCreator.IMG_CUT);
        i2_copy.setIcon(ImageCreator.IMG_COPY);
        i3_paste.setIcon(ImageCreator.IMG_PASTE);
        i4_select.setIcon(ImageCreator.IMG_SELECTALL);
        JMenu ix_show = new JMenu("Show");
        String[] showOptions = new String[]{"Nothing", "Requests", "Responses", "Both"};
        ButtonGroup group = new ButtonGroup();
        int showOnTheWire = JBroFuzz.PREFS.getInt(JBroFuzzPrefs.FUZZINGONTHEWIRE[1].getId(), 3);
        for (int i = 0; i < showOptions.length; ++i) {
            JRadioButtonMenuItem rButton1 = new JRadioButtonMenuItem(showOptions[i]);
            group.add(rButton1);
            ix_show.add(rButton1);
            if (i == showOnTheWire) {
                rButton1.setSelected(true);
            }
            rButton1.putClientProperty("Show Name", i);
            rButton1.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent iEvent) {
                    JRadioButtonMenuItem rbi = (JRadioButtonMenuItem)iEvent.getSource();
                    if (rbi.isSelected()) {
                        final int selection = (Integer)rbi.getClientProperty("Show Name");
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JBroFuzz.PREFS.putInt(JBroFuzzPrefs.FUZZINGONTHEWIRE[1].getId(), selection);
                            }
                        });
                    }
                }
            });
        }
        popmenu.add(i1_cut);
        popmenu.add(i2_copy);
        popmenu.add(i3_paste);
        popmenu.addSeparator();
        popmenu.add(i0_clear);
        popmenu.add(ix_show);
        popmenu.addSeparator();
        popmenu.add(i4_select);
        if (!area.isEditable()) {
            i3_paste.setEnabled(false);
            i1_cut.setEnabled(false);
        }
        i0_clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mFuzzingPanel.clearOnTheWire();
            }
        });
        i1_cut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                area.cut();
            }
        });
        i2_copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                area.copy();
            }
        });
        i3_paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (area.isEditable()) {
                    area.paste();
                }
            }
        });
        i4_select.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                area.selectAll();
            }
        });
        area.addMouseListener(new MouseAdapter(){

            private void checkForTriggerEvent(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    area.requestFocus();
                    popmenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.checkForTriggerEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.checkForTriggerEvent(e);
            }
        });
    }

    public static void rightClickFuzzersTable(final FuzzingPanel mFuzzingPanel, final JTable area) {
        final JPopupMenu popmenu = new JPopupMenu();
        final JMenuItem i0_view_payloads = new JMenuItem("View Payloads");
        final JMenuItem i1_remove_fuzzer = new JMenuItem("Remove Fuzzer");
        final JMenuItem i2_clear = new JMenuItem("Clear All Fuzzers");
        final JMenuItem i3_copy = new JMenuItem("Copy");
        final JMenuItem i4_select = new JMenuItem("Select All");
        i1_remove_fuzzer.setIcon(ImageCreator.IMG_REMOVE);
        i2_clear.setIcon(ImageCreator.IMG_CLEAR);
        i3_copy.setIcon(ImageCreator.IMG_COPY);
        i4_select.setIcon(ImageCreator.IMG_SELECTALL);
        popmenu.add(i0_view_payloads);
        popmenu.add(i1_remove_fuzzer);
        popmenu.addSeparator();
        popmenu.add(i2_clear);
        popmenu.addSeparator();
        popmenu.add(i3_copy);
        popmenu.add(i4_select);
        i0_view_payloads.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int c = area.getSelectedRow();
                if (c < 0) {
                    return;
                }
                String fuzzerRowId = (String)area.getModel().getValueAt(area.convertRowIndexToModel(c), 0);
                String fuzzerName = mFuzzingPanel.getFrame().getJBroFuzz().getDatabase().getName(fuzzerRowId);
                String[] fuzzerPayloads = mFuzzingPanel.getFrame().getJBroFuzz().getDatabase().getPayloads(fuzzerRowId);
                StringBuffer myPayloadsBuffer = new StringBuffer();
                for (String si : fuzzerPayloads) {
                    myPayloadsBuffer.append(si);
                    myPayloadsBuffer.append("\n\n");
                }
                new PropertiesViewer(mFuzzingPanel, "Fuzzer: " + fuzzerName + " (" + fuzzerRowId + ")", myPayloadsBuffer.toString());
            }
        });
        i1_remove_fuzzer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int c = area.getSelectedRow();
                if (c < 0) {
                    return;
                }
                if (mFuzzingPanel.isStopped()) {
                    ((FuzzersTableModel)area.getModel()).removeRow(area.convertRowIndexToModel(c));
                } else {
                    int choice = JOptionPane.showConfirmDialog(mFuzzingPanel.getFrame(), "Fuzzing Session Running. Stop Fuzzing?", " JBroFuzz - Stop ", 0);
                    if (choice == 0) {
                        mFuzzingPanel.stop();
                        ((FuzzersTableModel)area.getModel()).removeRow(area.convertRowIndexToModel(c));
                    }
                }
            }
        });
        i2_clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (mFuzzingPanel.isStopped()) {
                    mFuzzingPanel.getFuzzersPanel().clearFuzzersTable();
                } else {
                    int choice = JOptionPane.showConfirmDialog(mFuzzingPanel.getFrame(), "Fuzzing Session Running. Stop Fuzzing?", " JBroFuzz - Stop ", 0);
                    if (choice == 0) {
                        mFuzzingPanel.stop();
                        mFuzzingPanel.getFuzzersPanel().clearFuzzersTable();
                    }
                }
            }
        });
        i3_copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selection;
                StringBuffer selectionBuffer = new StringBuffer();
                for (int element : selection = area.getSelectedRows()) {
                    for (int i = 0; i < area.getColumnCount(); ++i) {
                        selectionBuffer.append(area.getModel().getValueAt(area.convertRowIndexToModel(element), i));
                        if (i >= area.getColumnCount() - 1) continue;
                        selectionBuffer.append(',');
                    }
                    selectionBuffer.append('\n');
                }
                JTextArea myTempArea = new JTextArea();
                myTempArea.setText(selectionBuffer.toString());
                myTempArea.selectAll();
                myTempArea.copy();
            }
        });
        i4_select.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                area.selectAll();
            }
        });
        MouseAdapter myFuZZMouseAdapter = new MouseAdapter(){

            private void checkForTriggerEvent(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    Point point = e.getPoint();
                    int row = area.rowAtPoint(point);
                    if (row < 0) {
                        i0_view_payloads.setEnabled(false);
                        i1_remove_fuzzer.setEnabled(false);
                        i2_clear.setEnabled(true);
                        i3_copy.setEnabled(false);
                        i4_select.setEnabled(false);
                    } else {
                        i0_view_payloads.setEnabled(true);
                        i1_remove_fuzzer.setEnabled(true);
                        i2_clear.setEnabled(true);
                        i3_copy.setEnabled(true);
                        i4_select.setEnabled(true);
                        if (area.getSelectedRows().length < 2) {
                            area.getSelectionModel().setSelectionInterval(row, row);
                        }
                    }
                    area.requestFocus();
                    popmenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.checkForTriggerEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.checkForTriggerEvent(e);
            }
        };
        area.getTableHeader().addMouseListener(myFuZZMouseAdapter);
        area.addMouseListener(myFuZZMouseAdapter);
    }
}

