/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.fuzz.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import org.owasp.jbrofuzz.JBroFuzz;
import org.owasp.jbrofuzz.fuzz.io.FuzzFileUtils;
import org.owasp.jbrofuzz.fuzz.ui.FuzzSplitPane;
import org.owasp.jbrofuzz.fuzz.ui.FuzzingPanel;
import org.owasp.jbrofuzz.fuzz.ui.OutputTable;
import org.owasp.jbrofuzz.fuzz.ui.OutputTableModel;
import org.owasp.jbrofuzz.fuzz.ui.RightClickPopups;
import org.owasp.jbrofuzz.io.FileHandler;
import org.owasp.jbrofuzz.system.Logger;
import org.owasp.jbrofuzz.version.JBroFuzzFormat;
import org.owasp.jbrofuzz.version.JBroFuzzPrefs;

public class OutputPanel
extends JPanel {
    private static final long serialVersionUID = -8246023219146780640L;
    private TableRowSorter<OutputTableModel> outputSorter;
    private JTextPane outputRequestPane;
    private JTextPane outputResponsePane;
    private OutputTableModel outputTableModel;
    private OutputTable mOutputTable;
    private JCheckBox csxReq;
    private JCheckBox csxRes;
    private int lastIndex;
    private Color HILIT_COLOR = Color.LIGHT_GRAY;
    private FuzzingPanel fp;

    public OutputPanel(FuzzingPanel fp) {
        this.fp = fp;
        this.createOutputPanel();
    }

    public OutputTable getOutputTable() {
        return this.mOutputTable;
    }

    public void setOutputTable(OutputTable ot) {
        this.mOutputTable = ot;
    }

    public OutputTableModel getOutputTableModel() {
        return this.outputTableModel;
    }

    public void setOutputTableModel(OutputTableModel otm) {
        this.outputTableModel = otm;
    }

    public void clear() {
        this.outputTableModel.clearAllRows();
        this.outputRequestPane.setText("");
        this.outputResponsePane.setText("");
    }

    private void createOutputPanel() {
        FuzzSplitPane outputMainPane = new FuzzSplitPane(0, 6);
        FuzzSplitPane outputBottomPane = new FuzzSplitPane(1, 7);
        JPanel outputTablePanel = new JPanel(new BorderLayout());
        outputTablePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Output "), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.outputTableModel = new OutputTableModel();
        this.mOutputTable = new OutputTable(this.outputTableModel);
        this.outputSorter = new TableRowSorter<OutputTableModel>(this.outputTableModel);
        this.mOutputTable.setRowSorter(this.outputSorter);
        JScrollPane outputScrollPane = new JScrollPane(this.mOutputTable);
        outputScrollPane.setVerticalScrollBarPolicy(20);
        outputTablePanel.add(outputScrollPane);
        outputTablePanel.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        RightClickPopups.rightClickOutputTable(this.fp, this.mOutputTable);
        this.outputRequestPane = this.fp.createSimplePane();
        this.outputRequestPane.setEditable(false);
        this.outputResponsePane = this.fp.createSimplePane();
        this.outputResponsePane.setEditable(false);
        JPanel bL = new JPanel(new BorderLayout());
        JPanel bR = new JPanel(new BorderLayout());
        bL.add((Component)FuzzingPanel.createScrollingPanel(" Request ", this.outputRequestPane), "Center");
        bR.add((Component)FuzzingPanel.createScrollingPanel(" Response ", this.outputResponsePane), "Center");
        final JTextField reqSearch = new JTextField();
        final JTextField resSearch = new JTextField();
        this.csxReq = new JCheckBox("Ignore Case");
        this.csxRes = new JCheckBox("Ignore Case");
        this.csxReq.setSelected(true);
        this.csxRes.setSelected(true);
        resSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    OutputPanel.this.outputSearch(OutputPanel.this.outputResponsePane, resSearch, OutputPanel.this.csxRes.isSelected());
                }
            }
        });
        reqSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    OutputPanel.this.outputSearch(OutputPanel.this.outputRequestPane, reqSearch, OutputPanel.this.csxReq.isSelected());
                }
            }
        });
        JPanel pbL = new JPanel(new BorderLayout());
        pbL.add((Component)this.csxReq, "West");
        pbL.add((Component)reqSearch, "Center");
        JPanel pbR = new JPanel(new BorderLayout());
        pbR.add((Component)this.csxRes, "West");
        pbR.add((Component)resSearch, "Center");
        bL.add((Component)pbL, "South");
        bR.add((Component)pbR, "South");
        outputBottomPane.setLeftComponent(bL);
        outputBottomPane.setRightComponent(bR);
        outputBottomPane.getLeftComponent().setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        outputBottomPane.getRightComponent().setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        outputBottomPane.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        outputMainPane.setTopComponent(outputTablePanel);
        outputMainPane.setBottomComponent(outputBottomPane);
        this.mOutputTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int cRow = OutputPanel.this.mOutputTable.getSelectedRow();
                try {
                    cRow = OutputPanel.this.mOutputTable.convertRowIndexToModel(cRow);
                }
                catch (IndexOutOfBoundsException iob) {
                    return;
                }
                final String name = (String)OutputPanel.this.mOutputTable.getModel().getValueAt(cRow, 0);
                class FileLoader
                extends SwingWorker<String, Object> {
                    String fuzzerLineOutput = new String();

                    FileLoader() {
                    }

                    @Override
                    public String doInBackground() {
                        String directory = OutputPanel.this.fp.getFrame().getJBroFuzz().getStorageHandler().getLocationURIString();
                        File selFile = new File(directory, name + ".html");
                        this.fuzzerLineOutput = FileHandler.readFile(selFile);
                        return "done";
                    }

                    @Override
                    protected void done() {
                        String dbType = JBroFuzz.PREFS.get(JBroFuzzPrefs.DBSETTINGS[11].getId(), "-1");
                        String request = new String();
                        String response = new String();
                        if (dbType.equals("None")) {
                            response = FuzzFileUtils.getResponse(this.fuzzerLineOutput);
                            request = FuzzFileUtils.getRequest(this.fuzzerLineOutput);
                        } else if (dbType.equals("SQLite")) {
                            String[] result2;
                            String sqlStatement1 = "Select payload from message where filename='" + name + "' and sessionId ='" + OutputPanel.this.fp.getSessionName() + "'";
                            String sqlStatement2 = "Select reply from message where filename='" + name + "' and sessionId ='" + OutputPanel.this.fp.getSessionName() + "'";
                            String[] result = OutputPanel.this.fp.getFrame().getJBroFuzz().getStorageHandler().readTableRow(sqlStatement1);
                            if (result.length > 0) {
                                request = result[0];
                            }
                            if ((result2 = OutputPanel.this.fp.getFrame().getJBroFuzz().getStorageHandler().readTableRow(sqlStatement2)).length > 0) {
                                response = result2[0];
                            }
                        } else {
                            Logger.log("COUCHDB database not implement - use none", 3);
                        }
                        OutputPanel.this.outputResponsePane.setText(response);
                        OutputPanel.this.outputRequestPane.setText(request);
                        OutputPanel.this.outputResponsePane.setCaretPosition(0);
                        OutputPanel.this.outputResponsePane.setCaretPosition(0);
                        OutputPanel.this.outputResponsePane.repaint();
                        OutputPanel.this.outputRequestPane.repaint();
                    }
                }
                new FileLoader().execute();
            }
        });
        this.setLayout(new BorderLayout());
        this.add(outputMainPane);
    }

    private void outputSearch(JTextPane toSearch, JTextField entry, boolean ignoreCase) {
        DefaultHighlighter hilit = new DefaultHighlighter();
        toSearch.setHighlighter(hilit);
        DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(this.HILIT_COLOR);
        String s = entry.getText();
        try {
            String content = toSearch.getDocument().getText(0, toSearch.getDocument().getLength());
            int index = -1;
            index = ignoreCase ? content.toLowerCase().indexOf(s.toLowerCase(), 0) : content.indexOf(s, 0);
            if (this.lastIndex != 0 && this.lastIndex >= index) {
                int tempIndex;
                index = ignoreCase ? (tempIndex = content.toLowerCase().indexOf(s.toLowerCase(), this.lastIndex + 1)) : (tempIndex = content.indexOf(s, this.lastIndex + 1));
            }
            if (index >= 0) {
                int end = index + s.length();
                hilit.addHighlight(index, end, painter);
                toSearch.setCaretPosition(index);
                this.lastIndex = index;
            } else if (this.lastIndex > 0) {
                this.lastIndex = 0;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }
}

