/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.fuzz.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.Document;
import javax.swing.text.StyledEditorKit;
import org.apache.commons.lang.StringUtils;
import org.owasp.jbrofuzz.JBroFuzz;
import org.owasp.jbrofuzz.core.Fuzzer;
import org.owasp.jbrofuzz.core.NoSuchFuzzerException;
import org.owasp.jbrofuzz.encode.EncoderHashCore;
import org.owasp.jbrofuzz.fuzz.Connection;
import org.owasp.jbrofuzz.fuzz.ConnectionException;
import org.owasp.jbrofuzz.fuzz.MessageContainer;
import org.owasp.jbrofuzz.fuzz.MessageCreator;
import org.owasp.jbrofuzz.fuzz.ui.FuzzSplitPane;
import org.owasp.jbrofuzz.fuzz.ui.FuzzersPanel;
import org.owasp.jbrofuzz.fuzz.ui.OutputPanel;
import org.owasp.jbrofuzz.fuzz.ui.RightClickPopups;
import org.owasp.jbrofuzz.fuzz.ui.TransformsPanel;
import org.owasp.jbrofuzz.fuzz.ui.TransformsTableModel;
import org.owasp.jbrofuzz.fuzz.ui.TransformsToolBar;
import org.owasp.jbrofuzz.fuzz.ui.WireTextArea;
import org.owasp.jbrofuzz.payloads.PayloadsDialog;
import org.owasp.jbrofuzz.system.Logger;
import org.owasp.jbrofuzz.ui.AbstractPanel;
import org.owasp.jbrofuzz.ui.JBroFuzzWindow;
import org.owasp.jbrofuzz.util.NonWrappingTextPane;
import org.owasp.jbrofuzz.util.TextHighlighter;
import org.owasp.jbrofuzz.version.JBroFuzzFormat;
import org.owasp.jbrofuzz.version.JBroFuzzPrefs;

public class FuzzingPanel
extends AbstractPanel {
    private static final long serialVersionUID = 6520864430220861584L;
    private final JTextField urlField;
    private JTextPane requestPane;
    private int counter = 0;
    private final WireTextArea mWireTextArea;
    private final FuzzSplitPane mainPane;
    private final FuzzSplitPane bottomPane;
    private final JTabbedPane fuzzerWindowPane;
    private boolean stopped = true;
    private String payload = "";
    private String encodedPayload;
    private JPanel topPanel;
    private TransformsPanel transformsPanel;
    private FuzzersPanel fuzzersPanel;
    private OutputPanel outputPanel;
    private static final SimpleDateFormat SD_FORMAT = new SimpleDateFormat("zzz-yyyy-MM-dd-HH-mm-ss-SSS", Locale.ENGLISH);
    private static final SimpleDateFormat SH_FORMAT = new SimpleDateFormat("DDD-HH-mm-ss-SSS", Locale.ENGLISH);
    private String sessionName = null;

    public FuzzingPanel(JBroFuzzWindow mWindow) {
        super(" Fuzzing ", mWindow);
        this.setOptionsAvailable(true, false, false, true, false);
        JPanel targetPanel = new JPanel(new BorderLayout());
        targetPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Target "), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        this.urlField = new JTextField();
        this.urlField.setEditable(true);
        this.urlField.setVisible(true);
        this.urlField.setFont(new Font("Verdana", 1, 12));
        this.urlField.setToolTipText("[{Protocol} :// {Host} [:{Port}]]");
        this.urlField.setMargin(new Insets(1, 1, 1, 1));
        this.urlField.setBackground(Color.WHITE);
        this.urlField.setForeground(Color.BLACK);
        this.requestPane = this.createEditablePane();
        AbstractPanel.popupText(this.urlField, true, true, true, true);
        targetPanel.add(this.urlField);
        this.fuzzersPanel = new FuzzersPanel(this);
        JPanel onTheWirePanel = new JPanel();
        onTheWirePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Requests "), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.mWireTextArea = new WireTextArea();
        RightClickPopups.rightClickOnTheWireTextComponent(this, this.mWireTextArea);
        JScrollPane consoleScrollPane = new JScrollPane(this.mWireTextArea, 22, 31);
        onTheWirePanel.setLayout(new BorderLayout());
        onTheWirePanel.add((Component)consoleScrollPane, "Center");
        this.topPanel = new JPanel(new BorderLayout());
        this.topPanel.add((Component)targetPanel, "First");
        this.topPanel.add((Component)FuzzingPanel.createScrollingPanel(" Request ", this.requestPane), "Center");
        this.fuzzerWindowPane = new JTabbedPane();
        this.bottomPane = new FuzzSplitPane(1, 5);
        this.bottomPane.setLeftComponent(this.fuzzersPanel);
        this.transformsPanel = new TransformsPanel(this);
        this.bottomPane.setRightComponent(this.transformsPanel);
        this.mainPane = new FuzzSplitPane(0, 4);
        this.mainPane.setOneTouchExpandable(false);
        this.mainPane.setTopComponent(this.topPanel);
        this.mainPane.setBottomComponent(this.bottomPane);
        this.topPanel.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        this.bottomPane.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        this.outputPanel = new OutputPanel(this);
        this.fuzzerWindowPane.addTab("Input", this.mainPane);
        this.fuzzerWindowPane.addTab("Output", this.outputPanel);
        this.fuzzerWindowPane.addTab("On the wire", onTheWirePanel);
        this.add((Component)this.fuzzerWindowPane, "Center");
        this.setTextURL(JBroFuzz.PREFS.get("fuzz.ui.url_text", ""));
        this.setTextRequest(JBroFuzz.PREFS.get("fuzz.ui.request_text", ""));
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setSessionName(String sessionId) {
        this.sessionName = sessionId;
    }

    public static JPanel createScrollingPanel(String title, JTextPane textPane) {
        JPanel panel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(textPane, 22, 30);
        panel.add(scrollPane);
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(title), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        return panel;
    }

    private JTextPane createEditablePane() {
        JTextPane textPane = new JTextPane();
        boolean wrapText = JBroFuzz.PREFS.getBoolean(JBroFuzzPrefs.FUZZING[2].getId(), false);
        textPane = wrapText ? new JTextPane() : new NonWrappingTextPane();
        textPane.putClientProperty("charset", "UTF-8");
        textPane.setEditable(true);
        textPane.setVisible(true);
        textPane.setFont(new Font("Verdana", 0, 12));
        textPane.setMargin(new Insets(1, 1, 1, 1));
        textPane.setBackground(Color.WHITE);
        textPane.setForeground(Color.BLACK);
        textPane.setEditorKit(new StyledEditorKit(){
            private static final long serialVersionUID = -6085642347022880064L;

            @Override
            public Document createDefaultDocument() {
                return new TextHighlighter();
            }
        });
        RightClickPopups.rightClickRequestTextComponent(this, textPane);
        return textPane;
    }

    JTextPane createSimplePane() {
        JTextPane textPane = new JTextPane();
        textPane.setMargin(new Insets(1, 1, 1, 1));
        textPane.setBackground(Color.WHITE);
        textPane.setForeground(Color.BLACK);
        return textPane;
    }

    @Override
    public void add() {
        try {
            this.requestPane.getSelectedText();
        }
        catch (IllegalArgumentException e) {
            JOptionPane.showInputDialog(this, "An exception was thrown while attempting to get the selected text", "Add Fuzzer", 0);
        }
        int sPoint = this.requestPane.getSelectionStart();
        int fPoint = this.requestPane.getSelectionEnd();
        new PayloadsDialog(this, sPoint, fPoint);
    }

    public void clearAllFields() {
        this.urlField.setText("");
        this.requestPane.setText("");
        this.mWireTextArea.setText("");
        this.transformsPanel.clear();
        this.fuzzersPanel.clear();
        this.outputPanel.getOutputTableModel().clearAllRows();
        this.urlField.requestFocusInWindow();
    }

    public void clearOutputTable() {
        this.outputPanel.clear();
    }

    public void clearOnTheWire() {
        this.mWireTextArea.setText("");
        this.urlField.requestFocusInWindow();
    }

    @Override
    public void pause() {
    }

    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public void remove() {
    }

    public final void setTextURL(String input) {
        this.urlField.setText(input);
    }

    @Override
    public void start() {
        if (!this.stopped) {
            return;
        }
        this.stopped = false;
        this.setOptionsAvailable(false, true, false, false, false);
        this.urlField.setEditable(false);
        this.urlField.setBackground(Color.BLACK);
        this.urlField.setForeground(Color.WHITE);
        int fuzzers_added = this.fuzzersPanel.getRowCount();
        if (this.sessionName == null) {
            this.sessionName = SD_FORMAT.format(new Date());
        }
        for (int i = 0; i < Math.max(fuzzers_added, 1); ++i) {
            int start;
            int end;
            TransformsTableModel transforms;
            String category;
            if (fuzzers_added < 1) {
                category = "000-ZER-ONE";
                transforms = new TransformsTableModel();
                end = 0;
                start = 0;
            } else {
                category = this.fuzzersPanel.getCategory(i);
                transforms = this.transformsPanel.getTransforms(i);
                start = this.fuzzersPanel.getStart(i);
                end = this.fuzzersPanel.getEnd(i);
            }
            try {
                Fuzzer f = this.getFrame().getJBroFuzz().getDatabase().createFuzzer(category, Math.abs(end - start));
                while (f.hasNext()) {
                    if (this.stopped) {
                        return;
                    }
                    int showOnTheWire = JBroFuzz.PREFS.getInt(JBroFuzzPrefs.FUZZINGONTHEWIRE[1].getId(), 3);
                    this.payload = f.next();
                    this.encodedPayload = EncoderHashCore.encodeMany(this.payload, transforms);
                    MessageCreator currentMessage = new MessageCreator(this.getTextURL(), this.getTextRequest(), this.encodedPayload, start, end);
                    MessageContainer outputMessage = new MessageContainer(this);
                    outputMessage.setTextRequest(currentMessage.getMessageForDisplayPurposes());
                    if (showOnTheWire == 1 || showOnTheWire == 3) {
                        this.mWireTextArea.setText(currentMessage.getMessageForDisplayPurposes());
                    }
                    try {
                        Connection connection = new Connection(this.getTextURL(), currentMessage.getMessage());
                        outputMessage.setReply(connection.getReply());
                        Logger.log("received: " + outputMessage.getReply(), 3);
                        outputMessage.setConnection(connection);
                        if (showOnTheWire == 2 || showOnTheWire == 3) {
                            this.mWireTextArea.setText(connection.getReply());
                        }
                        this.outputPanel.getOutputTableModel().addNewRow(outputMessage);
                    }
                    catch (ConnectionException e1) {
                        outputMessage.setException(e1);
                        if (showOnTheWire == 2 || showOnTheWire == 3) {
                            this.mWireTextArea.setText("A connection exception occurred.");
                            outputMessage.setReply(this.mWireTextArea.getText());
                            Logger.log("reply set to: " + outputMessage.getReply(), 3);
                        }
                        this.outputPanel.getOutputTableModel().addNewRow(outputMessage);
                    }
                    this.getFrame().getJBroFuzz().getStorageHandler().writeFuzzFile(outputMessage, this.sessionName);
                }
                continue;
            }
            catch (NoSuchFuzzerException exp) {
                Logger.log("The fuzzer could not be found...", 3);
            }
        }
    }

    @Override
    public void stop() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        this.setOptionsAvailable(true, false, false, true, true);
        int total = this.fuzzersPanel.getRowCount();
        if (total > 0) {
            this.setOptionRemove(true);
        } else {
            this.setOptionRemove(false);
        }
        this.urlField.setEditable(true);
        this.urlField.setBackground(Color.WHITE);
        this.urlField.setForeground(Color.BLACK);
    }

    public String getPayload() {
        return this.payload;
    }

    public String getEncodedPayload() {
        return this.encodedPayload;
    }

    public TransformsPanel getTransformsPanel() {
        return this.transformsPanel;
    }

    public TransformsToolBar getControlPanel() {
        return this.transformsPanel.getTransformsToolBar();
    }

    public OutputPanel getOutputPanel() {
        return this.outputPanel;
    }

    public void setOutputPanel(OutputPanel op) {
        this.outputPanel = op;
    }

    public JComponent getUrlField() {
        return this.urlField;
    }

    public FuzzersPanel getFuzzersPanel() {
        return this.fuzzersPanel;
    }

    public String getCounter() {
        if (this.counter < 0 || this.counter > 1000000000) {
            this.counter = 1;
        }
        ++this.counter;
        return StringUtils.leftPad((String)Integer.toString(this.counter), (int)10, (char)'0');
    }

    public String getTextRequest() {
        return StringUtils.abbreviate((String)this.requestPane.getText(), (int)16384);
    }

    public String getTextURL() {
        return StringUtils.abbreviate((String)this.urlField.getText(), (int)1024);
    }

    public final void setTextRequest(String input) {
        this.requestPane.setText(input);
        this.requestPane.setCaretPosition(0);
    }
}

