/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.encode;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.BinaryCodec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.net.QuotedPrintableCodec;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang.StringEscapeUtils;
import org.owasp.jbrofuzz.encode.Base32;
import org.owasp.jbrofuzz.encode.UUEncode;
import org.owasp.jbrofuzz.encode.ZBase32;
import org.owasp.jbrofuzz.fuzz.ui.TransformsTableModel;

public class EncoderHashCore {
    public static final String[] CODES = new String[]{"Plain Text", "URL Cp1252", "URL UTF-8", "URL UTF-16BE", "URL UTF-16LE", "Double URL Cp1252", "Double URL UTF-8", "Double URL UTF-16BE", "Double URL UTF-16LE", "Base64", "Base32", "Z-Base32", "MD5 Hash", "SHA-1 Hash", "SHA-256 Hash", "SHA-384 Hash", "SHA-512 Hash", "Hexadecimal (low)", "Hexadecimal (UPP)", "Binary", "www-form-urlencoded", "RFC 1521 MIME (eMail)", "Escape: HTML", "Escape: CSV", "Escape: Java", "Escape: JavaScript", "Escape: SQL", "Escape: XML", "UUencode"};
    private static final String[] IS_DECODABLE = new String[]{"Plain Text", "URL Cp1252", "URL UTF-8", "URL UTF-16BE", "URL UTF-16LE", "Double URL Cp1252", "Double URL UTF-8", "Double URL UTF-16BE", "Double URL UTF-16LE", "Base64", "Base32", "Z-Base32", "Hexadecimal (low)", "Hexadecimal (UPP)", "Binary", "www-form-urlencoded", "RFC 1521 MIME (eMail)", "Escape: HTML", "Escape: CSV", "Escape: Java", "Escape: JavaScript", "Escape: XML", "UUencode"};
    private static final String[] COMMENTS = new String[]{"This is a null encoder/decoder", "This is using the java URL decoder, but with: URLDecoder.decode(decodeText, \"windows-1252\");", "This is using the java URL decoder, but with: URLEncoder.encode(encodeText, \"UTF-8\");", "This is using the java URL decoder, but with: URLEncoder.encode(encodeText, \"UTF-16LE\");", "This is using the java URL decoder, but with: URLEncoder.encode(encodeText, \"UTF-16BE\");", "This is using the java URL decoder twice, but with: URLDecoder.decode(URLDecoder.decode(decodeText, \"windows-1252\"));", "This is using the java URL decoder twice, but with: URLEncoder.encode(URLEncoder.encode(encodeText, \"UTF-8\"));", "This is using the java URL decoder twice, but with: URLEncoder.encode(URLEncoder.encode(encodeText, \"UTF-16LE\"));", "This is using the java URL decoder twice, but with: URLEncoder.encode(URLEncoder.encode(encodeText, \"UTF-16BE\"));", "MIME Base64 uses a 64-character alphabet consisting of upper- and lower-case Roman alphabet characters (A-Z, a-z), the numerals (0-9), and the \"+\" and \"/\" symbols. The \"=\" symbol is also used as a special suffix code.", "MIME Base32 uses a 32-character alphabet, as defined by RFC 4648, consisting of upper-case Roman alphabet characters (A-Z), the numerals (2-7), and the \"=\" symbol.", "Z-Base32 is a Base32 encoding designed to be easier for human use and more compact, currently used in Phil Zimmermann's ZRTP protocol.", "The 128-bit (16-byte) MD5 hashes (also termed message digests) are typically represented as a sequence of 32 hexadecimal digits. The hash of the zero-length string is: MD5(\"\") = d41d8cd98f00b204e9800998ecf8427e", "SHA-1 (as well as SHA-0) produces a 160-bit digest from a message with a maximum length of (2^64 - 1) bits.  Encoding is performed parsing by getting the bytes in encodeText.getBytes() standard. ", "SHA-256 produces a 256-bit digest from a message with a maximum length of (2^64-1) bits. Encoding is performed parsing by getting the bytes in encodeText.getBytes() standard. ", "SHA-384 produces a 384-bit digest from a message with a maximum length of (2^128-1) bits. Encoding is performed parsing by getting the bytes in encodeText.getBytes() standard. ", "SHA-512 produces a 512-bit digest from a message with a maximum length of (2^128-1) bits. Encoding is performed parsing by getting the bytes in encodeText.getBytes() standard. ", "Hexadecimal (low)", "Hexadecimal (UPP)", "Binary : BinaryCodec.toAsciiChars(encodeText.getBytes()", "www-form-urlencoded", "RFC 1521 MIME (eMail) using QuotedPrintableCodec with codec.encode(encodeText);", "Supports all known HTML 4.0 entities, including funky accents. Note that the commonly used apostrophe escape character (&apos;) is not a legal entity and so is not supported). ", "Returns a String value for a CSV column enclosed in double quotes, if required. If the value contains a comma, newline or double quote, then the String value is returned enclosed in double quotes. Any double quote characters in the value are escaped with another double quote. If the value does not contain a comma, newline or double quote, then the String value is returned unchanged. See RFC 4180. ", "Escapes the characters in a String using Java String rules. Deals correctly with quotes and control-chars (tab, backslash, cr, ff, etc.) So a tab becomes the characters '\\' and 't'. The only difference between Java strings and JavaScript strings is that in JavaScript, a single quote and forward-slash (/) are escaped.", "Escapes the characters in a String using JavaScript String rules. The only difference between Java strings and JavaScript strings is that in JavaScript, a single quote must be escaped.", "Escapes the characters in a String to be suitable to pass to an SQL query. \nFor example, \n\nstatement.executeQuery(\"SELECT * FROM MOVIES WHERE TITLE='\" + StringEscapeUtils.escapeSql(\"McHale's Navy\")  At present, this method only turns single-quotes into doubled single-quotes (\"McHale's Navy\" => \"McHale''s Navy\"). It does not handle the cases of percent (%) or underscore (_) for use in LIKE clauses.\n\nsee http://www.jguru.com/faq/view.jsp?EID=8881 ", "Escapes the characters in a String using XML entities. For example: \"bread\" & \"butter\" => &quot;bread&quot; &amp; &quot;butter&quot;. Supports only the five basic XML entities (gt, lt, quot, amp, apos). Does not support DTDs or external entities. Note that unicode characters greater than 0x7f are as of 3.0, no longer escaped. ", "UUencoder: Uuencoding is a form of binary-to-text encoding that originated in the Unix program uuencode, for encoding binary data for transmission over the uucp mail system."};

    public static boolean isDecoded(String type) {
        for (int i = 0; i < IS_DECODABLE.length; ++i) {
            if (!type.equalsIgnoreCase(IS_DECODABLE[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidCode(String code) {
        for (String loopingString : CODES) {
            if (!loopingString.equals(code)) continue;
            return true;
        }
        return false;
    }

    protected static String getComment(String type) {
        for (int i = 0; i < CODES.length; ++i) {
            if (!type.equalsIgnoreCase(CODES[i])) continue;
            return COMMENTS[i];
        }
        return "";
    }

    public static String decode(String decodeText, String type) {
        if (!EncoderHashCore.isDecoded(type)) {
            return "Error: String cannot be decoded...";
        }
        if (type.equalsIgnoreCase("Plain Text")) {
            return decodeText;
        }
        if (type.equalsIgnoreCase("URL Cp1252")) {
            return EncoderHashCore.decodeUrlWindows1252(decodeText);
        }
        if (type.equalsIgnoreCase("URL UTF-8")) {
            return EncoderHashCore.decodeUrlUtf8(decodeText);
        }
        if (type.equalsIgnoreCase("URL UTF-16BE")) {
            return EncoderHashCore.decodeUrlUtf16BE(decodeText);
        }
        if (type.equalsIgnoreCase("URL UTF-16LE")) {
            return EncoderHashCore.decodeUrlUtf16LE(decodeText);
        }
        if (type.equalsIgnoreCase("Double URL Cp1252")) {
            return EncoderHashCore.decodeUrlWindows1252(EncoderHashCore.decodeUrlWindows1252(decodeText));
        }
        if (type.equalsIgnoreCase("Double URL UTF-8")) {
            return EncoderHashCore.decodeUrlUtf8(EncoderHashCore.decodeUrlUtf8(decodeText));
        }
        if (type.equalsIgnoreCase("Double URL UTF-16BE")) {
            return EncoderHashCore.decodeUrlUtf16BE(EncoderHashCore.decodeUrlUtf16BE(decodeText));
        }
        if (type.equalsIgnoreCase("Double URL UTF-16LE")) {
            return EncoderHashCore.decodeUrlUtf16LE(EncoderHashCore.decodeUrlUtf16LE(decodeText));
        }
        if (type.equalsIgnoreCase("Base64")) {
            return EncoderHashCore.decodeBase64(decodeText);
        }
        if (type.equalsIgnoreCase("Base32")) {
            return EncoderHashCore.decodeBase32(decodeText);
        }
        if (type.equalsIgnoreCase("Z-Base32")) {
            return EncoderHashCore.decodeZBase32(decodeText);
        }
        if (type.equalsIgnoreCase("Hexadecimal (low)")) {
            return EncoderHashCore.decodeHexLow(decodeText);
        }
        if (type.equalsIgnoreCase("Hexadecimal (UPP)")) {
            return EncoderHashCore.decodeHexUpp(decodeText);
        }
        if (type.equalsIgnoreCase("Binary")) {
            return EncoderHashCore.decodeBinary(decodeText);
        }
        if (type.equalsIgnoreCase("www-form-urlencoded")) {
            return EncoderHashCore.decodeUrlCodec(decodeText);
        }
        if (type.equalsIgnoreCase("RFC 1521 MIME (eMail)")) {
            return EncoderHashCore.decodeRfc1521(decodeText);
        }
        if (type.equalsIgnoreCase("Escape: HTML")) {
            return EncoderHashCore.decodeEscHtml(decodeText);
        }
        if (type.equalsIgnoreCase("Escape: CSV")) {
            return EncoderHashCore.decodeEscCsv(decodeText);
        }
        if (type.equalsIgnoreCase("Escape: Java")) {
            return EncoderHashCore.decodeEscJava(decodeText);
        }
        if (type.equalsIgnoreCase("Escape: JavaScript")) {
            return EncoderHashCore.decodeEscJavaScript(decodeText);
        }
        if (type.equalsIgnoreCase("Escape: Xml")) {
            return EncoderHashCore.decodeEscXml(decodeText);
        }
        if (type.equalsIgnoreCase("UUencode")) {
            return EncoderHashCore.decodeUU(decodeText);
        }
        return "Error: Decoding type not found...";
    }

    private static String decodeUU(String decodeText) {
        return new String(UUEncode.decode(decodeText));
    }

    private static String decodeBase64(String decodeText) {
        return new String(Base64.decodeBase64((byte[])decodeText.getBytes()));
    }

    private static String decodeBase32(String decodeText) {
        return new String(Base32.decode(decodeText));
    }

    private static String decodeZBase32(String decodeText) {
        return ZBase32.decode(decodeText);
    }

    private static String decodeBinary(String decodeText) {
        return new String(BinaryCodec.fromAscii((byte[])decodeText.getBytes()));
    }

    private static String decodeEscCsv(String decodeText) {
        return StringEscapeUtils.unescapeCsv((String)decodeText);
    }

    private static String decodeEscHtml(String decodeText) {
        return StringEscapeUtils.unescapeHtml((String)decodeText);
    }

    private static String decodeEscJava(String decodeText) {
        return StringEscapeUtils.unescapeJava((String)decodeText);
    }

    private static String decodeEscJavaScript(String decodeText) {
        return StringEscapeUtils.unescapeJavaScript((String)decodeText);
    }

    private static String decodeEscXml(String decodeText) {
        return StringEscapeUtils.unescapeXml((String)decodeText);
    }

    private static String decodeHexLow(String decodeText) {
        try {
            return new String(Hex.decodeHex((char[])decodeText.toCharArray()));
        }
        catch (DecoderException e) {
            return "Error: Hex value cannot be decoded...";
        }
    }

    private static String decodeHexUpp(String decodeText) {
        return EncoderHashCore.decodeHexLow(decodeText);
    }

    private static String decodeRfc1521(String decodeText) {
        QuotedPrintableCodec codec = new QuotedPrintableCodec();
        try {
            return codec.decode(decodeText);
        }
        catch (DecoderException e) {
            return "Error: RFC 1521 MIME value cannot be decoded...";
        }
    }

    private static String decodeUrlCodec(String decodeText) {
        URLCodec codec = new URLCodec();
        try {
            return codec.decode(decodeText, "UTF-8");
        }
        catch (DecoderException e) {
            return "Error: www-form-urlencoded value cannot be decoded...";
        }
        catch (UnsupportedEncodingException e) {
            return "Error: www-form-urlencoded value cannot be decoded...";
        }
    }

    private static String decodeUrlUtf16BE(String decodeText) {
        try {
            return URLDecoder.decode(decodeText, "UTF-16BE");
        }
        catch (UnsupportedEncodingException e) {
            return "Error: String cannot be encoded...";
        }
    }

    private static String decodeUrlUtf16LE(String decodeText) {
        try {
            return URLDecoder.decode(decodeText, "UTF-16LE");
        }
        catch (UnsupportedEncodingException e) {
            return "Error: String cannot be encoded...";
        }
    }

    private static String decodeUrlUtf8(String decodeText) {
        try {
            return URLDecoder.decode(decodeText, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "Error: String cannot be encoded...";
        }
    }

    private static String decodeUrlWindows1252(String decodeText) {
        try {
            return URLDecoder.decode(decodeText, "windows-1252");
        }
        catch (UnsupportedEncodingException e) {
            return "Error: String cannot be encoded...";
        }
    }

    public static String encode(String encodeText, String type) {
        if (type.equalsIgnoreCase("Plain Text")) {
            return encodeText;
        }
        if (type.equalsIgnoreCase("URL Cp1252")) {
            return EncoderHashCore.encodeUrlWindows1252(encodeText);
        }
        if (type.equalsIgnoreCase("URL UTF-8")) {
            return EncoderHashCore.encodeUrlUtf8(encodeText);
        }
        if (type.equalsIgnoreCase("URL UTF-16BE")) {
            return EncoderHashCore.encodeUrlUtf16BE(encodeText);
        }
        if (type.equalsIgnoreCase("URL UTF-16LE")) {
            return EncoderHashCore.encodeUrlUtf16LE(encodeText);
        }
        if (type.equalsIgnoreCase("Double URL Cp1252")) {
            return EncoderHashCore.encodeUrlWindows1252(EncoderHashCore.encodeUrlWindows1252(encodeText));
        }
        if (type.equalsIgnoreCase("Double URL UTF-8")) {
            return EncoderHashCore.encodeUrlUtf8(EncoderHashCore.encodeUrlUtf8(encodeText));
        }
        if (type.equalsIgnoreCase("Double URL UTF-16BE")) {
            return EncoderHashCore.encodeUrlUtf16BE(EncoderHashCore.encodeUrlUtf16BE(encodeText));
        }
        if (type.equalsIgnoreCase("Double URL UTF-16LE")) {
            return EncoderHashCore.encodeUrlUtf16LE(EncoderHashCore.encodeUrlUtf16LE(encodeText));
        }
        if (type.equalsIgnoreCase("Base64")) {
            return EncoderHashCore.encodeBase64(encodeText);
        }
        if (type.equalsIgnoreCase("Base32")) {
            return EncoderHashCore.encodeBase32(encodeText);
        }
        if (type.equalsIgnoreCase("Z-Base32")) {
            return EncoderHashCore.encodeZBase32(encodeText);
        }
        if (type.equalsIgnoreCase("MD5 Hash")) {
            return EncoderHashCore.encodeMd5Hash(encodeText);
        }
        if (type.equalsIgnoreCase("SHA-1 Hash")) {
            return EncoderHashCore.encodeSha1Hash(encodeText);
        }
        if (type.equalsIgnoreCase("SHA-256 Hash")) {
            return EncoderHashCore.encodeSha256Hash(encodeText);
        }
        if (type.equalsIgnoreCase("SHA-384 Hash")) {
            return EncoderHashCore.encodeSha384Hash(encodeText);
        }
        if (type.equalsIgnoreCase("SHA-512 Hash")) {
            return EncoderHashCore.encodeSha512Hash(encodeText);
        }
        if (type.equalsIgnoreCase("Hexadecimal (low)")) {
            return EncoderHashCore.encodeHexLow(encodeText);
        }
        if (type.equalsIgnoreCase("Hexadecimal (UPP)")) {
            return EncoderHashCore.encodeHexUpp(encodeText);
        }
        if (type.equalsIgnoreCase("Binary")) {
            return EncoderHashCore.encodeBinary(encodeText);
        }
        if (type.equalsIgnoreCase("www-form-urlencoded")) {
            return EncoderHashCore.encodeUrlCodec(encodeText);
        }
        if (type.equalsIgnoreCase("RFC 1521 MIME (eMail)")) {
            return EncoderHashCore.encodeRfc1521(encodeText);
        }
        if (type.equalsIgnoreCase("Escape: HTML")) {
            return EncoderHashCore.encodeEscHtml(encodeText);
        }
        if (type.equalsIgnoreCase("Escape: CSV")) {
            return EncoderHashCore.encodeEscCsv(encodeText);
        }
        if (type.equalsIgnoreCase("Escape: Java")) {
            return EncoderHashCore.encodeEscJava(encodeText);
        }
        if (type.equalsIgnoreCase("Escape: JavaScript")) {
            return EncoderHashCore.encodeEscJavaScript(encodeText);
        }
        if (type.equalsIgnoreCase("Escape: SQL")) {
            return EncoderHashCore.encodeEscSql(encodeText);
        }
        if (type.equalsIgnoreCase("Escape: XML")) {
            return EncoderHashCore.encodeEscXml(encodeText);
        }
        if (type.equalsIgnoreCase("UUencode")) {
            return EncoderHashCore.encodeUU(encodeText);
        }
        return "Error: Encoding type not found...";
    }

    private static String encodeUU(String encodeText) {
        return new String(UUEncode.encode(encodeText));
    }

    private static String encodeBase64(String encodeText) {
        return new String(Base64.encodeBase64((byte[])encodeText.getBytes()));
    }

    private static String encodeBase32(String encodeText) {
        return Base32.encode(encodeText.getBytes());
    }

    private static String encodeZBase32(String encodeText) {
        return ZBase32.encode(encodeText);
    }

    private static String encodeBinary(String encodeText) {
        return new String(BinaryCodec.toAsciiChars((byte[])encodeText.getBytes()));
    }

    private static String encodeEscCsv(String encodeText) {
        return StringEscapeUtils.escapeCsv((String)encodeText);
    }

    private static String encodeEscHtml(String encodeText) {
        return StringEscapeUtils.escapeHtml((String)encodeText);
    }

    private static String encodeEscJava(String encodeText) {
        return StringEscapeUtils.escapeJava((String)encodeText);
    }

    private static String encodeEscJavaScript(String encodeText) {
        return StringEscapeUtils.escapeJavaScript((String)encodeText);
    }

    private static String encodeEscSql(String encodeText) {
        return StringEscapeUtils.escapeSql((String)encodeText);
    }

    private static String encodeEscXml(String encodeText) {
        return StringEscapeUtils.escapeXml((String)encodeText);
    }

    private static String encodeHexLow(String encodeText) {
        return new String(Hex.encodeHex((byte[])encodeText.getBytes()));
    }

    private static String encodeHexUpp(String encodeText) {
        return EncoderHashCore.encodeHexLow(encodeText).toUpperCase();
    }

    private static String encodeMd5Hash(String encodeText) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(encodeText.getBytes(), 0, encodeText.length());
            byte[] hash = md5.digest();
            return new String(Hex.encodeHex((byte[])hash)).toUpperCase();
        }
        catch (NoSuchAlgorithmException e1) {
            return "Error: MD5 could not be found...";
        }
    }

    private static String encodeRfc1521(String encodeText) {
        QuotedPrintableCodec codec = new QuotedPrintableCodec();
        try {
            return codec.encode(encodeText);
        }
        catch (EncoderException e) {
            return "Error: Sting input cannot be decoded";
        }
    }

    private static String encodeSha1Hash(String encodeText) {
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            sha1.update(encodeText.getBytes(), 0, encodeText.length());
            byte[] hash = sha1.digest();
            return new String(Hex.encodeHex((byte[])hash)).toUpperCase();
        }
        catch (NoSuchAlgorithmException e1) {
            return "Error: SHA-1 could not be found...";
        }
    }

    private static String encodeSha256Hash(String encodeText) {
        try {
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            sha256.update(encodeText.getBytes(), 0, encodeText.length());
            byte[] hash = sha256.digest();
            return new String(Hex.encodeHex((byte[])hash)).toUpperCase();
        }
        catch (NoSuchAlgorithmException e1) {
            return "Error: SHA-256 could not be found...";
        }
    }

    private static String encodeSha384Hash(String encodeText) {
        try {
            MessageDigest sha384 = MessageDigest.getInstance("SHA-384");
            sha384.update(encodeText.getBytes(), 0, encodeText.length());
            byte[] hash = sha384.digest();
            return new String(Hex.encodeHex((byte[])hash)).toUpperCase();
        }
        catch (NoSuchAlgorithmException e1) {
            return "Error: SHA-384 could not be found...";
        }
    }

    private static String encodeSha512Hash(String encodeText) {
        try {
            MessageDigest sha512 = MessageDigest.getInstance("SHA-512");
            sha512.update(encodeText.getBytes(), 0, encodeText.length());
            byte[] hash = sha512.digest();
            return new String(Hex.encodeHex((byte[])hash)).toUpperCase();
        }
        catch (NoSuchAlgorithmException e1) {
            return "Error: SHA-512 could not be found...";
        }
    }

    private static String encodeUrlCodec(String encodeText) {
        URLCodec codec = new URLCodec();
        try {
            return codec.encode(encodeText, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "Error: Sting input cannot be decoded";
        }
    }

    private static String encodeUrlUtf16BE(String encodeText) {
        try {
            return URLEncoder.encode(encodeText, "UTF-16BE");
        }
        catch (UnsupportedEncodingException e) {
            return "Error: String cannot be encoded...";
        }
    }

    private static String encodeUrlUtf16LE(String encodeText) {
        try {
            return URLEncoder.encode(encodeText, "UTF-16LE");
        }
        catch (UnsupportedEncodingException e) {
            return "Error: String cannot be encoded...";
        }
    }

    private static String encodeUrlUtf8(String encodeText) {
        try {
            return URLEncoder.encode(encodeText, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "Error: String cannot be encoded...";
        }
    }

    private static String encodeUrlWindows1252(String encodeText) {
        try {
            return URLEncoder.encode(encodeText, "windows-1252");
        }
        catch (UnsupportedEncodingException e) {
            return "Error: String cannot be encoded...";
        }
    }

    public static String encodeMany(String payload, TransformsTableModel encoding) {
        String encoded = payload;
        for (int i = 0; i < encoding.getRowCount(); ++i) {
            String encoder = encoding.getRow(i).getEncoder();
            String pom = EncoderHashCore.timeControl(encoding.getRow(i).getPrefixOrMatch());
            String sor = EncoderHashCore.timeControl(encoding.getRow(i).getSuffixOrReplace());
            String payloadTemp = encoder.equals("Match & Replace") ? EncoderHashCore.matchAndReplace(pom, sor, encoded) : (encoder.equals("Prefix & Suffix") ? EncoderHashCore.prefixAndSuffix(pom, sor, encoded) : EncoderHashCore.encode(encoded, encoder));
            encoded = payloadTemp;
        }
        return encoded;
    }

    private static String timeControl(String in) {
        if (in.equals("Epoch Time")) {
            long ts = new Date().getTime();
            String out = String.valueOf(ts);
            return out;
        }
        if (in.equals("DateFormat Time")) {
            return in;
        }
        return in;
    }

    private static String matchAndReplace(String match, String replace, String input) {
        return input.replaceAll(match, replace);
    }

    private static String prefixAndSuffix(String prefix, String suffix, String input) {
        return prefix + input + suffix;
    }
}

