/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.encoder.esapi;

import java.io.IOException;
import java.net.URI;
import org.owasp.encoder.Encode;
import org.owasp.esapi.Encoder;
import org.owasp.esapi.codecs.Codec;
import org.owasp.esapi.errors.EncodingException;
import org.owasp.esapi.reference.DefaultEncoder;

public final class ESAPIEncoder {
    private ESAPIEncoder() {
    }

    public static Encoder getInstance() {
        return Impl.INSTANCE;
    }

    private static enum Impl implements Encoder
    {
        INSTANCE;

        private final Encoder _referenceEncoder = DefaultEncoder.getInstance();

        public String canonicalize(String s) {
            return this._referenceEncoder.canonicalize(s);
        }

        public String canonicalize(String s, boolean strict) {
            return this._referenceEncoder.canonicalize(s, strict);
        }

        public String canonicalize(String s, boolean restrictMultiple, boolean restrictMixed) {
            return this._referenceEncoder.canonicalize(s, restrictMultiple, restrictMixed);
        }

        public String getCanonicalizedURI(URI dirtyUri) {
            return this._referenceEncoder.getCanonicalizedURI(dirtyUri);
        }

        public String encodeForCSS(String s) {
            return Encode.forCssString((String)s);
        }

        public String encodeForHTML(String s) {
            return Encode.forHtml((String)s);
        }

        public String decodeForHTML(String s) {
            return this._referenceEncoder.decodeForHTML(s);
        }

        public String encodeForHTMLAttribute(String s) {
            return Encode.forHtmlAttribute((String)s);
        }

        public String encodeForJavaScript(String s) {
            return Encode.forJavaScript((String)s);
        }

        public String encodeForVBScript(String s) {
            return this._referenceEncoder.encodeForVBScript(s);
        }

        public String encodeForSQL(Codec codec, String s) {
            return this._referenceEncoder.encodeForSQL(codec, s);
        }

        public String encodeForOS(Codec codec, String s) {
            return this._referenceEncoder.encodeForOS(codec, s);
        }

        public String encodeForLDAP(String s) {
            return this._referenceEncoder.encodeForLDAP(s);
        }

        public String encodeForLDAP(String s, boolean b) {
            return this._referenceEncoder.encodeForLDAP(s, b);
        }

        public String encodeForDN(String s) {
            return this._referenceEncoder.encodeForDN(s);
        }

        public String encodeForXPath(String s) {
            return this._referenceEncoder.encodeForXPath(s);
        }

        public String encodeForXML(String s) {
            return Encode.forXml((String)s);
        }

        public String encodeForXMLAttribute(String s) {
            return Encode.forXmlAttribute((String)s);
        }

        public String encodeForURL(String s) throws EncodingException {
            return Encode.forUri((String)s);
        }

        public String decodeFromURL(String s) throws EncodingException {
            return this._referenceEncoder.decodeFromURL(s);
        }

        public String encodeForBase64(byte[] bytes, boolean wrap) {
            return this._referenceEncoder.encodeForBase64(bytes, wrap);
        }

        public byte[] decodeFromBase64(String s) throws IOException {
            return this._referenceEncoder.decodeFromBase64(s);
        }

        public String encodeForJSON(String s) {
            return this._referenceEncoder.encodeForJSON(s);
        }

        public String decodeFromJSON(String s) {
            return this._referenceEncoder.decodeFromJSON(s);
        }
    }
}

