/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);
    private static final String BIT_BUCKET_UNIX = "/dev/null";
    private static final String BIT_BUCKET_WIN = "NUL";

    private FileUtils() {
    }

    @Nullable
    public static String getFileExtension(@NotNull String fileName) {
        @Nullable String fileExt = FilenameUtils.getExtension((String)fileName);
        return StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{fileExt}) ? StringUtils.lowerCase((String)fileExt) : null;
    }

    public static boolean delete(@Nullable File file) {
        if (file == null) {
            LOGGER.warn("cannot delete null File");
            return false;
        }
        try {
            org.apache.commons.io.FileUtils.forceDelete((File)file);
        }
        catch (IOException ex) {
            LOGGER.trace(ex.getMessage(), (Throwable)ex);
            LOGGER.debug("Failed to delete file: {} (error message: {}); attempting to delete on exit.", (Object)file.getPath(), (Object)ex.getMessage());
            file.deleteOnExit();
            return false;
        }
        return true;
    }

    @NotNull
    public static File createTempDirectory(@Nullable File base) throws IOException {
        File tempDir = new File(base, "dctemp" + UUID.randomUUID().toString());
        if (tempDir.exists()) {
            return FileUtils.createTempDirectory(base);
        }
        if (!tempDir.mkdirs()) {
            throw new IOException("Could not create temp directory `" + tempDir.getAbsolutePath() + "`");
        }
        LOGGER.debug("Temporary directory is `{}`", (Object)tempDir.getAbsolutePath());
        return tempDir;
    }

    @NotNull
    public static String getBitBucket() {
        return SystemUtils.IS_OS_WINDOWS ? BIT_BUCKET_WIN : BIT_BUCKET_UNIX;
    }

    public static void close(@Nullable Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (IOException ex) {
                LOGGER.trace("", (Throwable)ex);
            }
        }
    }

    @Nullable
    public static InputStream getResourceAsStream(@NotNull String resource) {
        InputStream inputStream;
        ClassLoader classLoader = FileUtils.class.getClassLoader();
        InputStream inputStream2 = inputStream = classLoader != null ? classLoader.getResourceAsStream(resource) : ClassLoader.getSystemResourceAsStream(resource);
        if (inputStream == null) {
            try {
                return new FileInputStream(resource);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("Unable to create an Input Stream for " + resource, (Throwable)e);
            }
        }
        return inputStream;
    }

    public static File getResourceAsFile(String resource) {
        ClassLoader classLoader = FileUtils.class.getClassLoader();
        String path = null;
        if (classLoader != null) {
            URL url = classLoader.getResource(resource);
            if (url != null) {
                path = url.getFile();
            }
        } else {
            path = ClassLoader.getSystemResource(resource).getFile();
        }
        if (path == null) {
            return new File(resource);
        }
        return new File(path);
    }
}

