/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.lang3.StringUtils;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.SSLSocketFactoryEx;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.URLConnectionFailureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class URLConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(URLConnectionFactory.class);
    private final Settings settings;

    public URLConnectionFactory(Settings settings) {
        this.settings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(justification="yes, there is a redundant null check in the catch - to suppress warnings we are leaving the null check", value={"RCN_REDUNDANT_NULLCHECK_OF_NULL_VALUE"})
    public HttpURLConnection createHttpURLConnection(URL url) throws URLConnectionFailureException {
        HttpURLConnection conn = null;
        final String proxyHost = this.settings.getString("proxy.server");
        try {
            if (proxyHost != null && !this.matchNonProxy(url)) {
                int proxyPort = this.settings.getInt("proxy.port");
                InetSocketAddress address = new InetSocketAddress(proxyHost, proxyPort);
                final String username = this.settings.getString("proxy.username");
                final String password = this.settings.getString("proxy.password");
                if (username != null && password != null) {
                    Authenticator auth = new Authenticator(){

                        @Override
                        public PasswordAuthentication getPasswordAuthentication() {
                            if (proxyHost.equals(this.getRequestingHost()) || this.getRequestorType().equals((Object)Authenticator.RequestorType.PROXY)) {
                                LOGGER.debug("Using the configured proxy username and password");
                                try {
                                    if (URLConnectionFactory.this.settings.getBoolean("proxy.disableSchemas", true)) {
                                        System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
                                    }
                                }
                                catch (InvalidSettingException ex) {
                                    LOGGER.trace("This exception can be ignored", (Throwable)ex);
                                }
                                return new PasswordAuthentication(username, password.toCharArray());
                            }
                            return super.getPasswordAuthentication();
                        }
                    };
                    Authenticator.setDefault(auth);
                }
                Proxy proxy = new Proxy(Proxy.Type.HTTP, address);
                conn = (HttpURLConnection)url.openConnection(proxy);
            } else {
                conn = (HttpURLConnection)url.openConnection();
            }
            int connectionTimeout = this.settings.getInt("connection.timeout", 10000);
            conn.setConnectTimeout(connectionTimeout);
            conn.setInstanceFollowRedirects(true);
        }
        catch (IOException ex) {
            if (conn != null) {
                try {
                    conn.disconnect();
                }
                finally {
                    conn = null;
                }
            }
            throw new URLConnectionFailureException("Error getting connection.", ex);
        }
        this.configureTLS(url, conn);
        return conn;
    }

    private boolean matchNonProxy(URL url) {
        String host = url.getHost();
        String nonProxyHosts = this.settings.getString("proxy.nonproxyhosts");
        if (null != nonProxyHosts) {
            String[] nonProxies;
            for (String nonProxyHost : nonProxies = nonProxyHosts.split("(,)|(;)|(\\|)")) {
                if (null != nonProxyHost && nonProxyHost.contains("*")) {
                    int pos = nonProxyHost.indexOf(42);
                    String nonProxyHostPrefix = nonProxyHost.substring(0, pos);
                    String nonProxyHostSuffix = nonProxyHost.substring(pos + 1);
                    if (!StringUtils.isEmpty((CharSequence)nonProxyHostPrefix) && host.startsWith(nonProxyHostPrefix) && StringUtils.isEmpty((CharSequence)nonProxyHostSuffix)) {
                        return true;
                    }
                    if (StringUtils.isEmpty((CharSequence)nonProxyHostPrefix) && !StringUtils.isEmpty((CharSequence)nonProxyHostSuffix) && host.endsWith(nonProxyHostSuffix)) {
                        return true;
                    }
                    if (StringUtils.isEmpty((CharSequence)nonProxyHostPrefix) || !host.startsWith(nonProxyHostPrefix) || StringUtils.isEmpty((CharSequence)nonProxyHostSuffix) || !host.endsWith(nonProxyHostSuffix)) continue;
                    return true;
                }
                if (!host.equals(nonProxyHost)) continue;
                return true;
            }
        }
        return false;
    }

    public HttpURLConnection createHttpURLConnection(URL url, boolean proxy) throws URLConnectionFailureException {
        if (proxy) {
            return this.createHttpURLConnection(url);
        }
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            int timeout = this.settings.getInt("connection.timeout", 10000);
            conn.setConnectTimeout(timeout);
            conn.setInstanceFollowRedirects(true);
        }
        catch (IOException ioe) {
            throw new URLConnectionFailureException("Error getting connection.", ioe);
        }
        this.configureTLS(url, conn);
        return conn;
    }

    private void configureTLS(URL url, URLConnection conn) {
        if ("https".equals(url.getProtocol())) {
            try {
                HttpsURLConnection secCon = (HttpsURLConnection)conn;
                SSLSocketFactoryEx factory = new SSLSocketFactoryEx(this.settings);
                secCon.setSSLSocketFactory(factory);
            }
            catch (NoSuchAlgorithmException ex) {
                LOGGER.debug("Unsupported algorithm in SSLSocketFactoryEx", (Throwable)ex);
            }
            catch (KeyManagementException ex) {
                LOGGER.debug("Key management exception in SSLSocketFactoryEx", (Throwable)ex);
            }
        }
    }
}

