/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.SSLHandshakeException;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.CredentialsStore;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.SystemDefaultCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.BasicHttpClientResponseHandler;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.BasicHttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.jetbrains.annotations.NotNull;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.ExplicitEncodingToStringResponseHandler;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.ResourceNotFoundException;
import org.owasp.dependencycheck.utils.SaveToFileResponseHandler;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.TooManyRequestsException;
import org.owasp.dependencycheck.utils.URLConnectionFailureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Downloader {
    private final HttpClientBuilder httpClientBuilder;
    private final HttpClientBuilder httpClientBuilderExplicitNoproxy;
    private Settings settings;
    private static final Logger LOGGER = LoggerFactory.getLogger(Downloader.class);
    private static final Downloader INSTANCE = new Downloader();

    private Downloader() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        this.httpClientBuilder = HttpClientBuilder.create().useSystemProperties().setConnectionManager((HttpClientConnectionManager)connectionManager).setConnectionManagerShared(true);
        this.httpClientBuilderExplicitNoproxy = HttpClientBuilder.create().useSystemProperties().setConnectionManager((HttpClientConnectionManager)connectionManager).setConnectionManagerShared(true).setProxySelector(new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                return Collections.singletonList(Proxy.NO_PROXY);
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            }
        });
    }

    public static Downloader getInstance() {
        return INSTANCE;
    }

    public void configure(Settings settings) throws InvalidSettingException {
        this.settings = settings;
        SystemDefaultCredentialsProvider credentialsProvider = new SystemDefaultCredentialsProvider();
        if (settings.getString("proxy.server") != null) {
            String proxyHost = settings.getString("proxy.server");
            int proxyPort = settings.getInt("proxy.port", -1);
            String nonProxyHosts = settings.getString("proxy.nonproxyhosts");
            if (nonProxyHosts != null && !nonProxyHosts.isEmpty()) {
                SelectiveProxySelector selector = new SelectiveProxySelector(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort)), nonProxyHosts.split("\\|"));
                this.httpClientBuilder.setProxySelector((ProxySelector)selector);
            } else {
                this.httpClientBuilder.setProxy(new HttpHost(proxyHost, proxyPort));
            }
            if (settings.getString("proxy.username") != null) {
                String proxyuser = settings.getString("proxy.username");
                char[] proxypass = settings.getString("proxy.password").toCharArray();
                credentialsProvider.setCredentials(new AuthScope(null, proxyHost, proxyPort, null, null), (Credentials)new UsernamePasswordCredentials(proxyuser, proxypass));
            }
        }
        this.tryAddRetireJSCredentials(settings, (CredentialsStore)credentialsProvider);
        this.tryAddHostedSuppressionCredentials(settings, (CredentialsStore)credentialsProvider);
        this.tryAddKEVCredentials(settings, (CredentialsStore)credentialsProvider);
        this.tryAddNexusAnalyzerCredentials(settings, (CredentialsStore)credentialsProvider);
        this.tryAddNVDApiDatafeed(settings, (CredentialsStore)credentialsProvider);
        this.httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        this.httpClientBuilderExplicitNoproxy.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
    }

    private void tryAddRetireJSCredentials(Settings settings, CredentialsStore credentialsStore) throws InvalidSettingException {
        if (settings.getString("analyzer.retirejs.repo.js.password") != null) {
            this.addUserPasswordCreds(settings, credentialsStore, "analyzer.retirejs.repo.js.username", "analyzer.retirejs.repo.js.url", "analyzer.retirejs.repo.js.password", "RetireJS repo.js");
        }
    }

    private void tryAddHostedSuppressionCredentials(Settings settings, CredentialsStore credentialsStore) throws InvalidSettingException {
        if (settings.getString("hosted.suppressions.password") != null) {
            this.addUserPasswordCreds(settings, credentialsStore, "hosted.suppressions.user", "hosted.suppressions.url", "hosted.suppressions.password", "Hosted suppressions");
        }
    }

    private void tryAddKEVCredentials(Settings settings, CredentialsStore credentialsStore) throws InvalidSettingException {
        if (settings.getString("kev.password") != null) {
            this.addUserPasswordCreds(settings, credentialsStore, "kev.user", "kev.url", "kev.password", "Known Exploited Vulnerabilities");
        }
    }

    private void tryAddNexusAnalyzerCredentials(Settings settings, CredentialsStore credentialsStore) throws InvalidSettingException {
        if (settings.getString("analyzer.nexus.password") != null) {
            this.addUserPasswordCreds(settings, credentialsStore, "analyzer.nexus.username", "analyzer.nexus.url", "analyzer.nexus.password", "Nexus Analyzer");
        }
    }

    private void tryAddNVDApiDatafeed(Settings settings, CredentialsStore credentialsStore) throws InvalidSettingException {
        if (settings.getString("nvd.api.datafeed.password") != null) {
            this.addUserPasswordCreds(settings, credentialsStore, "nvd.api.datafeed.user", "nvd.api.datafeed.url", "nvd.api.datafeed.password", "NVD API Datafeed");
        }
    }

    private void addUserPasswordCreds(Settings settings, CredentialsStore store, String userKey, String urlKey, String passwordKey, String desc) throws InvalidSettingException {
        String theUser = settings.getString(userKey);
        String theURL = settings.getString(urlKey);
        char[] thePass = settings.getString(passwordKey, "").toCharArray();
        if (theUser == null || theURL == null || thePass.length == 0) {
            throw new InvalidSettingException(desc + " URL and username are required when setting " + desc + " password");
        }
        try {
            URL parsedURL = new URL(theURL);
            Downloader.addCredentials(store, desc, parsedURL, theUser, thePass);
        }
        catch (MalformedURLException e) {
            throw new InvalidSettingException(desc + " URL must be a valid URL", e);
        }
    }

    private static void addCredentials(CredentialsStore credentialsStore, String messageScope, URL parsedURL, String theUser, char[] thePass) throws InvalidSettingException {
        String theProtocol = parsedURL.getProtocol();
        if ("file".equals(theProtocol)) {
            LOGGER.warn("Credentials are not supported for file-protocol, double-check your configuration options for {}.", (Object)messageScope);
            return;
        }
        if ("http".equals(theProtocol)) {
            LOGGER.warn("Insecure configuration: Basic Credentials are configured to be used over a plain http connection for {}. Consider migrating to https to guard the credentials.", (Object)messageScope);
        } else if (!"https".equals(theProtocol)) {
            throw new InvalidSettingException("Unsupported protocol in the " + messageScope + " URL; only file, http and https are supported");
        }
        String theHost = parsedURL.getHost();
        int thePort = parsedURL.getPort();
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(theUser, thePass);
        AuthScope scope = new AuthScope(theProtocol, theHost, thePort, null, null);
        credentialsStore.setCredentials(scope, (Credentials)creds);
    }

    public void fetchFile(URL url, File outputPath) throws DownloadFailedException, TooManyRequestsException, ResourceNotFoundException, URLConnectionFailureException {
        this.fetchFile(url, outputPath, true);
    }

    public void fetchFile(URL url, File outputPath, boolean useProxy) throws DownloadFailedException, TooManyRequestsException, ResourceNotFoundException, URLConnectionFailureException {
        block12: {
            try {
                if ("file".equals(url.getProtocol())) {
                    Path p = Paths.get(url.toURI());
                    Files.copy(p, outputPath.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    break block12;
                }
                BasicClassicHttpRequest req = new BasicClassicHttpRequest(Method.GET, url.toURI());
                try (CloseableHttpClient hc = useProxy ? this.httpClientBuilder.build() : this.httpClientBuilderExplicitNoproxy.build();){
                    SaveToFileResponseHandler responseHandler = new SaveToFileResponseHandler(outputPath);
                    hc.execute((ClassicHttpRequest)req, (HttpClientResponseHandler)responseHandler);
                }
            }
            catch (HttpResponseException hre) {
                Downloader.wrapAndThrowHttpResponseException(url.toString(), hre);
            }
            catch (SSLHandshakeException ex) {
                if (ex.getMessage().contains("unable to find valid certification path to requested target")) {
                    String msg = String.format("Unable to connect to '%s' - the Java trust store does not contain a trusted root for the cert. Please see https://github.com/jeremylong/InstallCert for one method of updating the trusted certificates.", url);
                    throw new URLConnectionFailureException(msg, ex);
                }
                String msg = String.format("Download failed, unable to copy '%s' to '%s'; %s", url, outputPath.getAbsolutePath(), ex.getMessage());
                throw new DownloadFailedException(msg, ex);
            }
            catch (IOException | RuntimeException | URISyntaxException ex) {
                String msg = String.format("Download failed, unable to copy '%s' to '%s'; %s", url, outputPath.getAbsolutePath(), ex.getMessage());
                throw new DownloadFailedException(msg, ex);
            }
        }
    }

    private static void wrapAndThrowHttpResponseException(String url, HttpResponseException hre) throws ResourceNotFoundException, TooManyRequestsException, DownloadFailedException {
        String messageFormat = "%s - Server status: %d - Server reason: %s";
        switch (hre.getStatusCode()) {
            case 404: {
                throw new ResourceNotFoundException(String.format("%s - Server status: %d - Server reason: %s", url, hre.getStatusCode(), hre.getReasonPhrase()), hre);
            }
            case 429: {
                throw new TooManyRequestsException(String.format("%s - Server status: %d - Server reason: %s", url, hre.getStatusCode(), hre.getReasonPhrase()), hre);
            }
        }
        throw new DownloadFailedException(String.format("%s - Server status: %d - Server reason: %s", url, hre.getStatusCode(), hre.getReasonPhrase()), hre);
    }

    public void fetchFile(URL url, File outputPath, boolean useProxy, String userKey, String passwordKey) throws DownloadFailedException, TooManyRequestsException, ResourceNotFoundException, URLConnectionFailureException {
        if ("file".equals(url.getProtocol()) || userKey == null || this.settings.getString(userKey) == null || passwordKey == null || this.settings.getString(passwordKey) == null) {
            this.fetchFile(url, outputPath, useProxy);
            return;
        }
        String theProtocol = url.getProtocol();
        if (!"http".equals(theProtocol) && !"https".equals(theProtocol)) {
            throw new DownloadFailedException("Unsupported protocol in the URL; only file, http and https are supported");
        }
        try {
            HttpClientContext context = HttpClientContext.create();
            BasicCredentialsProvider localCredentials = new BasicCredentialsProvider();
            Downloader.addCredentials((CredentialsStore)localCredentials, url.toString(), url, this.settings.getString(userKey), this.settings.getString(passwordKey).toCharArray());
            context.setCredentialsProvider((CredentialsProvider)localCredentials);
            try (CloseableHttpClient hc = useProxy ? this.httpClientBuilder.build() : this.httpClientBuilderExplicitNoproxy.build();){
                BasicClassicHttpRequest req = new BasicClassicHttpRequest(Method.GET, url.toURI());
                SaveToFileResponseHandler responseHandler = new SaveToFileResponseHandler(outputPath);
                hc.execute((ClassicHttpRequest)req, (HttpContext)context, (HttpClientResponseHandler)responseHandler);
            }
        }
        catch (HttpResponseException hre) {
            Downloader.wrapAndThrowHttpResponseException(url.toString(), hre);
        }
        catch (SSLHandshakeException ex) {
            if (ex.getMessage().contains("unable to find valid certification path to requested target")) {
                String msg = String.format("Unable to connect to '%s' - the Java trust store does not contain a trusted root for the cert. Please see https://github.com/jeremylong/InstallCert for one method of updating the trusted certificates.", url);
                throw new URLConnectionFailureException(msg, ex);
            }
            String msg = String.format("Download failed, unable to copy '%s' to '%s'; %s", url, outputPath.getAbsolutePath(), ex.getMessage());
            throw new DownloadFailedException(msg, ex);
        }
        catch (IOException | RuntimeException | URISyntaxException ex) {
            String msg = String.format("Download failed, unable to copy '%s' to '%s'; %s", url, outputPath.getAbsolutePath(), ex.getMessage());
            throw new DownloadFailedException(msg, ex);
        }
    }

    public String postBasedFetchContent(URI url, String payload, ContentType payloadType, List<Header> hdr) throws DownloadFailedException, TooManyRequestsException, ResourceNotFoundException, URLConnectionFailureException {
        try {
            String result;
            if (url.getScheme() == null || !url.getScheme().toLowerCase(Locale.ROOT).matches("^https?")) {
                throw new IllegalArgumentException("Unsupported protocol in the URL; only http and https are supported");
            }
            BasicClassicHttpRequest req = new BasicClassicHttpRequest(Method.POST, url);
            req.setEntity((HttpEntity)new StringEntity(payload, payloadType));
            for (Header h : hdr) {
                req.addHeader(h);
            }
            try (CloseableHttpClient hc = this.httpClientBuilder.build();){
                result = (String)hc.execute((ClassicHttpRequest)req, (HttpClientResponseHandler)new BasicHttpClientResponseHandler());
            }
            return result;
        }
        catch (HttpResponseException hre) {
            Downloader.wrapAndThrowHttpResponseException(url.toString(), hre);
            throw new InternalError("wrapAndThrowHttpResponseException will always throw an exception but Java compiler fails to spot it");
        }
        catch (SSLHandshakeException ex) {
            if (ex.getMessage().contains("unable to find valid certification path to requested target")) {
                String msg = String.format("Unable to connect to '%s' - the Java trust store does not contain a trusted root for the cert. Please see https://github.com/jeremylong/InstallCert for one method of updating the trusted certificates.", url);
                throw new URLConnectionFailureException(msg, ex);
            }
            String msg = String.format("Download failed, error downloading '%s'; %s", url, ex.getMessage());
            throw new DownloadFailedException(msg, ex);
        }
        catch (IOException | RuntimeException ex) {
            String msg = String.format("Download failed, error downloading '%s'; %s", url, ex.getMessage());
            throw new DownloadFailedException(msg, ex);
        }
    }

    public String fetchContent(URL url, Charset charset) throws DownloadFailedException, TooManyRequestsException, ResourceNotFoundException {
        return this.fetchContent(url, true, charset);
    }

    public String fetchContent(URL url, boolean useProxy, Charset charset) throws DownloadFailedException, TooManyRequestsException, ResourceNotFoundException {
        try {
            String result;
            if ("file".equals(url.getProtocol())) {
                Path p = Paths.get(url.toURI());
                result = Files.readString(p, charset);
            } else {
                BasicClassicHttpRequest req = new BasicClassicHttpRequest(Method.GET, url.toURI());
                try (CloseableHttpClient hc = useProxy ? this.httpClientBuilder.build() : this.httpClientBuilderExplicitNoproxy.build();){
                    ExplicitEncodingToStringResponseHandler responseHandler = new ExplicitEncodingToStringResponseHandler(charset);
                    result = (String)hc.execute((ClassicHttpRequest)req, (HttpClientResponseHandler)responseHandler);
                }
            }
            return result;
        }
        catch (HttpResponseException hre) {
            Downloader.wrapAndThrowHttpResponseException(url.toString(), hre);
            throw new InternalError("wrapAndThrowHttpResponseException will always throw an exception but Java compiler fails to spot it");
        }
        catch (IOException | RuntimeException | URISyntaxException ex) {
            String msg = String.format("Download failed, error downloading '%s'; %s", url, ex.getMessage());
            throw new DownloadFailedException(msg, ex);
        }
    }

    public <T> T fetchAndHandle(@NotNull URL url, @NotNull HttpClientResponseHandler<T> handler) throws IOException, TooManyRequestsException, ResourceNotFoundException {
        return this.fetchAndHandle(url, handler, Collections.emptyList(), true);
    }

    public <T> T fetchAndHandle(@NotNull URL url, @NotNull HttpClientResponseHandler<T> handler, @NotNull List<Header> hdr) throws IOException, TooManyRequestsException, ResourceNotFoundException {
        return this.fetchAndHandle(url, handler, hdr, true);
    }

    public <T> T fetchAndHandle(@NotNull URL url, @NotNull HttpClientResponseHandler<T> handler, @NotNull List<Header> hdr, boolean useProxy) throws IOException, TooManyRequestsException, ResourceNotFoundException {
        try {
            Object data;
            block24: {
                if ("file".equals(url.getProtocol())) {
                    Path p = Paths.get(url.toURI());
                    try (InputStream is = Files.newInputStream(p, new OpenOption[0]);){
                        BasicHttpEntity dummyEntity = new BasicHttpEntity(is, ContentType.APPLICATION_JSON);
                        BasicClassicHttpResponse dummyResponse = new BasicClassicHttpResponse(200);
                        dummyResponse.setEntity((HttpEntity)dummyEntity);
                        data = handler.handleResponse((ClassicHttpResponse)dummyResponse);
                        break block24;
                    }
                    catch (HttpException e) {
                        throw new IllegalStateException("HttpException encountered without HTTP traffic", e);
                    }
                }
                String theProtocol = url.getProtocol();
                if (!"http".equals(theProtocol) && !"https".equals(theProtocol)) {
                    throw new DownloadFailedException("Unsupported protocol in the URL; only file, http and https are supported");
                }
                try (CloseableHttpClient hc = useProxy ? this.httpClientBuilder.build() : this.httpClientBuilderExplicitNoproxy.build();){
                    BasicClassicHttpRequest req = new BasicClassicHttpRequest(Method.GET, url.toURI());
                    for (Header h : hdr) {
                        req.addHeader(h);
                    }
                    data = hc.execute((ClassicHttpRequest)req, handler);
                }
            }
            return (T)data;
        }
        catch (HttpResponseException hre) {
            String messageFormat = "%s - Server status: %d - Server reason: %s";
            switch (hre.getStatusCode()) {
                case 404: {
                    throw new ResourceNotFoundException(String.format("%s - Server status: %d - Server reason: %s", url, hre.getStatusCode(), hre.getReasonPhrase()));
                }
                case 429: {
                    throw new TooManyRequestsException(String.format("%s - Server status: %d - Server reason: %s", url, hre.getStatusCode(), hre.getReasonPhrase()));
                }
            }
            throw new IOException(String.format("%s - Server status: %d - Server reason: %s", url, hre.getStatusCode(), hre.getReasonPhrase()));
        }
        catch (RuntimeException | URISyntaxException ex) {
            String msg = String.format("Download failed, unable to retrieve and parse '%s'; %s", url, ex.getMessage());
            throw new IOException(msg, ex);
        }
    }

    private static class SelectiveProxySelector
    extends ProxySelector {
        private final List<String> suffixMatch = new ArrayList<String>();
        private final List<String> fullmatch = new ArrayList<String>();
        private final Proxy configuredProxy;

        SelectiveProxySelector(Proxy httpHost, String[] nonProxyHostsPatterns) {
            for (String nonProxyHostPattern : nonProxyHostsPatterns) {
                if (nonProxyHostPattern.startsWith("*")) {
                    this.suffixMatch.add(nonProxyHostPattern.substring(1));
                    continue;
                }
                this.fullmatch.add(nonProxyHostPattern);
            }
            this.configuredProxy = httpHost;
        }

        @Override
        public List<Proxy> select(URI uri) {
            String theHost = uri.getHost();
            if (this.fullmatch.contains(theHost)) {
                return Collections.singletonList(Proxy.NO_PROXY);
            }
            for (String suffix : this.suffixMatch) {
                if (!theHost.endsWith(suffix)) continue;
                return Collections.singletonList(Proxy.NO_PROXY);
            }
            return List.of(this.configuredProxy);
        }

        @Override
        public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        }
    }
}

