/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Checksum {
    private static final Logger LOGGER = LoggerFactory.getLogger(Checksum.class);
    private static final String HEXES = "0123456789abcdef";

    private Checksum() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getChecksum(String algorithm, File file) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        FileInputStream fis = null;
        AbstractInterruptibleChannel ch = null;
        try {
            fis = new FileInputStream(file);
            ch = fis.getChannel();
            ByteBuffer buf = ByteBuffer.allocateDirect(8192);
            int b = ((FileChannel)ch).read(buf);
            while (b != -1 && b != 0) {
                buf.flip();
                byte[] bytes = new byte[b];
                buf.get(bytes);
                md.update(bytes, 0, b);
                buf.clear();
                b = ((FileChannel)ch).read(buf);
            }
            byte[] byArray = md.digest();
            return byArray;
        }
        finally {
            if (ch != null) {
                try {
                    ch.close();
                }
                catch (IOException ex) {
                    LOGGER.trace("Error closing channel '{}'.", (Object)file.getName(), (Object)ex);
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    LOGGER.trace("Error closing file '{}'.", (Object)file.getName(), (Object)ex);
                }
            }
        }
    }

    public static String getMD5Checksum(File file) throws IOException, NoSuchAlgorithmException {
        byte[] b = Checksum.getChecksum("MD5", file);
        return Checksum.getHex(b);
    }

    public static String getSHA1Checksum(File file) throws IOException, NoSuchAlgorithmException {
        byte[] b = Checksum.getChecksum("SHA1", file);
        return Checksum.getHex(b);
    }

    public static String getHex(byte[] raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (byte b : raw) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }
}

