/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.maven;

import com.github.packageurl.MalformedPackageURLException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.License;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.shared.artifact.filter.PatternExcludesArtifactFilter;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.filter.ArtifactDependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.filter.DependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.internal.DefaultDependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.FilteringDependencyNodeVisitor;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.TransferUtils;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.codehaus.doxia.sink.Sink;
import org.eclipse.aether.artifact.ArtifactType;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.agent.DependencyCheckScanAgent;
import org.owasp.dependencycheck.analyzer.JarAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.Identifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.exception.DependencyNotFoundException;
import org.owasp.dependencycheck.exception.ExceptionCollection;
import org.owasp.dependencycheck.exception.ReportException;
import org.owasp.dependencycheck.maven.ArtifactScopeExcluded;
import org.owasp.dependencycheck.maven.ArtifactTypeExcluded;
import org.owasp.dependencycheck.maven.FilteringDependencyTransitiveNodeVisitor;
import org.owasp.dependencycheck.maven.Retirejs;
import org.owasp.dependencycheck.reporting.ReportGenerator;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.Filter;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.SeverityUtil;
import org.owasp.dependencycheck.xml.pom.Model;
import org.owasp.dependencycheck.xml.pom.PomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

public abstract class BaseDependencyCheckMojo
extends AbstractMojo
implements MavenReport {
    private static final String PROPERTIES_FILE = "mojo.properties";
    private static final String NEW_LINE = System.getProperty("line.separator", "\n").intern();
    private static final String INCLUDE_ALL = "**/*";
    private boolean generatingSite = false;
    private Settings settings = null;
    @Parameter(property="failOnError", defaultValue="true", required=true)
    private boolean failOnError;
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(readonly=true, required=true, property="reactorProjects")
    private List<MavenProject> reactorProjects;
    @Component
    private ArtifactResolver artifactResolver;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component
    private DependencyGraphBuilder dependencyGraphBuilder;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(property="project.reporting.outputDirectory", readonly=true)
    private File reportOutputDirectory;
    @Parameter(property="failBuildOnCVSS", defaultValue="11", required=true)
    private float failBuildOnCVSS = 11.0f;
    @Parameter(property="junitFailOnCVSS", defaultValue="0", required=true)
    private float junitFailOnCVSS = 0.0f;
    @Deprecated
    @Parameter(property="failBuildOnAnyVulnerability", defaultValue="false", required=true)
    private boolean failBuildOnAnyVulnerability = false;
    @Parameter(property="autoUpdate")
    private Boolean autoUpdate;
    @Parameter(property="enableExperimental")
    private Boolean enableExperimental;
    @Parameter(property="enableRetired")
    private Boolean enableRetired;
    @Parameter(property="golangDepEnabled")
    private Boolean golangDepEnabled;
    @Parameter(property="golangModEnabled")
    private Boolean golangModEnabled;
    @Parameter(property="pathToGo")
    private String pathToGo;
    @Parameter(property="dependency-check.virtualSnapshotsFromReactor", defaultValue="true")
    private Boolean virtualSnapshotsFromReactor;
    @Parameter(property="format", defaultValue="HTML", required=true)
    private String format = "HTML";
    @Parameter(property="prettyPrint")
    private Boolean prettyPrint;
    @Parameter(property="formats", required=true)
    private String[] formats;
    @Parameter(property="mavenSettings", defaultValue="${settings}")
    private org.apache.maven.settings.Settings mavenSettings;
    @Parameter(property="mavenSettingsProxyId")
    private String mavenSettingsProxyId;
    @Parameter(property="connectionTimeout")
    private String connectionTimeout;
    @Parameter(property="versionCheckEnabled", defaultValue="true")
    private boolean versionCheckEnabled;
    @Parameter(property="suppressionFiles")
    private String[] suppressionFiles;
    @Parameter(property="suppressionFile")
    private String suppressionFile;
    @Parameter(property="suppressionFileUser")
    private String suppressionFileUser;
    @Parameter(property="suppressionFilePassword")
    private String suppressionFilePassword;
    @Parameter(property="suppressionFileServerId")
    private String suppressionFileServerId;
    @Parameter(property="hintsFile")
    private String hintsFile;
    @Parameter(property="showSummary", defaultValue="true")
    private boolean showSummary = true;
    @Parameter(property="jarAnalyzerEnabled")
    private Boolean jarAnalyzerEnabled;
    @Parameter(property="archiveAnalyzerEnabled")
    private Boolean archiveAnalyzerEnabled;
    @Parameter(property="pyDistributionAnalyzerEnabled")
    private Boolean pyDistributionAnalyzerEnabled;
    @Parameter(property="pyPackageAnalyzerEnabled")
    private Boolean pyPackageAnalyzerEnabled;
    @Parameter(property="rubygemsAnalyzerEnabled")
    private Boolean rubygemsAnalyzerEnabled;
    @Parameter(property="opensslAnalyzerEnabled")
    private Boolean opensslAnalyzerEnabled;
    @Parameter(property="cmakeAnalyzerEnabled")
    private Boolean cmakeAnalyzerEnabled;
    @Parameter(property="autoconfAnalyzerEnabled")
    private Boolean autoconfAnalyzerEnabled;
    @Parameter(property="pipAnalyzerEnabled")
    private Boolean pipAnalyzerEnabled;
    @Parameter(property="pipfileAnalyzerEnabled")
    private Boolean pipfileAnalyzerEnabled;
    @Parameter(property="composerAnalyzerEnabled")
    private Boolean composerAnalyzerEnabled;
    @Parameter(property="nodeAnalyzerEnabled")
    private Boolean nodeAnalyzerEnabled;
    @Parameter(property="nodeAuditAnalyzerEnabled")
    private Boolean nodeAuditAnalyzerEnabled;
    @Parameter(property="nodeAuditAnalyzerUseCache")
    private Boolean nodeAuditAnalyzerUseCache;
    @Parameter(property="nodeAuditSkipDevDependencies")
    private Boolean nodeAuditSkipDevDependencies;
    @Parameter(property="retireJsAnalyzerEnabled")
    private Boolean retireJsAnalyzerEnabled;
    @Parameter(property="retireJsUrl")
    private String retireJsUrl;
    @Parameter(property="retireJsForceUpdate")
    private Boolean retireJsForceUpdate;
    @Parameter(property="assemblyAnalyzerEnabled")
    private Boolean assemblyAnalyzerEnabled;
    @Parameter(property="nuspecAnalyzerEnabled")
    private Boolean nuspecAnalyzerEnabled;
    @Parameter(property="nugetconfAnalyzerEnabled")
    private Boolean nugetconfAnalyzerEnabled;
    @Parameter(property="centralAnalyzerEnabled")
    private Boolean centralAnalyzerEnabled;
    @Parameter(property="centralAnalyzerUseCache")
    private Boolean centralAnalyzerUseCache;
    @Parameter(property="artifactoryAnalyzerEnabled")
    private Boolean artifactoryAnalyzerEnabled;
    @Parameter(property="artifactoryAnalyzerServerId")
    private String artifactoryAnalyzerServerId;
    @Parameter(property="artifactoryAnalyzerUsername")
    private String artifactoryAnalyzerUsername;
    @Parameter(property="artifactoryAnalyzerApiToken")
    private String artifactoryAnalyzerApiToken;
    @Parameter(property="artifactoryAnalyzerBearerToken")
    private String artifactoryAnalyzerBearerToken;
    @Parameter(property="artifactoryAnalyzerUrl")
    private String artifactoryAnalyzerUrl;
    @Parameter(property="artifactoryAnalyzerUseProxy")
    private Boolean artifactoryAnalyzerUseProxy;
    @Parameter(property="artifactoryAnalyzerParallelAnalysis", defaultValue="true")
    private Boolean artifactoryAnalyzerParallelAnalysis;
    @Parameter(property="nexusAnalyzerEnabled")
    private Boolean nexusAnalyzerEnabled;
    @Parameter(property="ossindexAnalyzerEnabled")
    private Boolean ossindexAnalyzerEnabled;
    @Parameter(property="ossindexAnalyzerUseCache")
    private Boolean ossindexAnalyzerUseCache;
    @Parameter(property="ossindexAnalyzerUrl")
    private String ossindexAnalyzerUrl;
    @Parameter(property="ossIndexServerId")
    private String ossIndexServerId;
    @Parameter(property="mixAuditAnalyzerEnabled")
    private Boolean mixAuditAnalyzerEnabled;
    @Parameter(property="mixAuditPath")
    private String mixAuditPath;
    @Parameter(property="bundleAuditAnalyzerEnabled")
    private Boolean bundleAuditAnalyzerEnabled;
    @Parameter(property="bundleAuditPath")
    private String bundleAuditPath;
    @Parameter(property="bundleAuditWorkingDirectory")
    private String bundleAuditWorkingDirectory;
    @Parameter(property="cocoapodsAnalyzerEnabled")
    private Boolean cocoapodsAnalyzerEnabled;
    @Parameter(property="swiftPackageManagerAnalyzerEnabled")
    private Boolean swiftPackageManagerAnalyzerEnabled;
    @Parameter(property="nexusUrl")
    private String nexusUrl;
    @Parameter(property="nexusServerId")
    private String nexusServerId;
    @Parameter(property="nexusUsesProxy")
    private Boolean nexusUsesProxy;
    @Parameter(property="connectionString")
    private String connectionString;
    @Parameter(property="databaseDriverName")
    private String databaseDriverName;
    @Parameter(property="databaseDriverPath")
    private String databaseDriverPath;
    @Parameter(property="serverId")
    private String serverId;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private org.apache.maven.settings.Settings settingsXml;
    @Component(role=SecDispatcher.class, hint="default")
    private SecDispatcher securityDispatcher;
    @Parameter(property="databaseUser")
    private String databaseUser;
    @Parameter(property="databasePassword")
    private String databasePassword;
    @Parameter(property="zipExtensions")
    private String zipExtensions;
    @Parameter(property="dependency-check.skip", defaultValue="false")
    private boolean skip = false;
    @Parameter(property="skipTestScope", defaultValue="true")
    private boolean skipTestScope = true;
    @Parameter(property="skipRuntimeScope", defaultValue="false")
    private boolean skipRuntimeScope = false;
    @Parameter(property="skipProvidedScope", defaultValue="false")
    private boolean skipProvidedScope = false;
    @Parameter(property="skipSystemScope", defaultValue="false")
    private boolean skipSystemScope = false;
    @Parameter(property="skipDependencyManagement", defaultValue="true")
    private boolean skipDependencyManagement = true;
    @Parameter(property="skipArtifactType")
    private String skipArtifactType;
    @Parameter(property="dataDirectory")
    private String dataDirectory;
    @Parameter(property="dbFilename")
    private String dbFilename;
    @Parameter(property="cveUrlModified")
    private String cveUrlModified;
    @Parameter(property="cveUrlBase")
    private String cveUrlBase;
    @Parameter(property="cveUser")
    private String cveUser;
    @Parameter(property="cvePassword")
    private String cvePassword;
    @Parameter(property="cveServerId")
    private String cveServerId;
    @Parameter(property="cveValidForHours")
    private Integer cveValidForHours;
    @Parameter(property="pathToCore")
    private String pathToCore;
    @Parameter(property="retirejs")
    private Retirejs retirejs;
    @Parameter
    private List<String> excludes;
    private Filter<String> artifactScopeExcluded;
    private Filter<String> artifactTypeExcluded;
    @Parameter
    private List<FileSet> scanSet;
    @Parameter(property="scanDirectory")
    private List<String> scanDirectory;

    private static boolean artifactsMatch(Dependency d, Artifact a) {
        return BaseDependencyCheckMojo.isEqualOrNull(a.getArtifactId(), d.getArtifactId()) && BaseDependencyCheckMojo.isEqualOrNull(a.getGroupId(), d.getGroupId()) && BaseDependencyCheckMojo.isEqualOrNull(a.getVersion(), d.getVersion());
    }

    private static boolean isEqualOrNull(String left, String right) {
        return left != null && left.equals(right) || left == null && right == null;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.generatingSite = false;
        boolean shouldSkip = Boolean.parseBoolean(System.getProperty("dependency-check.skip", Boolean.toString(this.skip)));
        if (shouldSkip) {
            this.getLog().info((CharSequence)("Skipping " + this.getName(Locale.US)));
        } else {
            this.project.setContextValue("dependency-check-output-dir", (Object)this.outputDirectory);
            this.runCheck();
        }
    }

    @Deprecated
    public final void generate(Sink sink, Locale locale) throws MavenReportException {
        this.generate((org.apache.maven.doxia.sink.Sink)sink, locale);
    }

    protected boolean isGeneratingSite() {
        return this.generatingSite;
    }

    protected String getConnectionString() {
        return this.connectionString;
    }

    protected boolean isFailOnError() {
        return this.failOnError;
    }

    public void generate(org.apache.maven.doxia.sink.Sink sink, Locale locale) throws MavenReportException {
        boolean shouldSkip = Boolean.parseBoolean(System.getProperty("dependency-check.skip", Boolean.toString(this.skip)));
        if (shouldSkip) {
            this.getLog().info((CharSequence)("Skipping report generation " + this.getName(Locale.US)));
            return;
        }
        this.generatingSite = true;
        this.project.setContextValue("dependency-check-output-dir", (Object)this.getReportOutputDirectory());
        try {
            this.runCheck();
        }
        catch (MojoExecutionException ex) {
            throw new MavenReportException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (MojoFailureException ex) {
            this.getLog().warn((CharSequence)"Vulnerabilities were identifies that exceed the CVSS threshold for failing the build");
        }
    }

    protected File getCorrectOutputDirectory() throws MojoExecutionException {
        return this.getCorrectOutputDirectory(this.project);
    }

    protected File getCorrectOutputDirectory(MavenProject current) {
        Object obj = current.getContextValue("dependency-check-output-dir");
        if (obj != null && obj instanceof File) {
            return (File)obj;
        }
        File target = new File(current.getBuild().getDirectory());
        if (target.getParentFile() != null && "target".equals(target.getParentFile().getName())) {
            target = target.getParentFile();
        }
        return target;
    }

    protected ExceptionCollection scanArtifacts(MavenProject project, Engine engine) {
        return this.scanArtifacts(project, engine, false);
    }

    protected ExceptionCollection scanArtifacts(MavenProject project, Engine engine, boolean aggregate) {
        try {
            List<String> filterItems = Collections.singletonList(String.format("%s:%s", project.getGroupId(), project.getArtifactId()));
            ProjectBuildingRequest buildingRequest = this.newResolveArtifactProjectBuildingRequest(project);
            DependencyNode dn = this.dependencyGraphBuilder.buildDependencyGraph(buildingRequest, null, this.reactorProjects);
            CollectingDependencyNodeVisitor collectorVisitor = new CollectingDependencyNodeVisitor();
            FilteringDependencyTransitiveNodeVisitor transitiveFilterVisitor = new FilteringDependencyTransitiveNodeVisitor((DependencyNodeVisitor)collectorVisitor, (DependencyNodeFilter)new ArtifactDependencyNodeFilter((ArtifactFilter)new PatternExcludesArtifactFilter(this.getExcludes())));
            FilteringDependencyNodeVisitor artifactFilter = new FilteringDependencyNodeVisitor((DependencyNodeVisitor)transitiveFilterVisitor, (DependencyNodeFilter)new ArtifactDependencyNodeFilter((ArtifactFilter)new ExcludesArtifactFilter(filterItems)));
            dn.accept((DependencyNodeVisitor)artifactFilter);
            ArrayList<DependencyNode> nodes = new ArrayList<DependencyNode>(collectorVisitor.getNodes());
            return this.collectDependencies(engine, project, nodes, buildingRequest, aggregate);
        }
        catch (DependencyGraphBuilderException ex) {
            String msg = String.format("Unable to build dependency graph on project %s", project.getName());
            this.getLog().debug((CharSequence)msg, (Throwable)ex);
            return new ExceptionCollection((Throwable)ex);
        }
    }

    private DependencyNode toDependencyNode(List<DependencyNode> nodes, ProjectBuildingRequest buildingRequest, DependencyNode parent, Dependency dependency) throws ArtifactResolverException {
        VersionRange vr;
        DefaultArtifactCoordinate coordinate = new DefaultArtifactCoordinate();
        coordinate.setGroupId(dependency.getGroupId());
        coordinate.setArtifactId(dependency.getArtifactId());
        String version = null;
        try {
            vr = VersionRange.createFromVersionSpec((String)dependency.getVersion());
        }
        catch (InvalidVersionSpecificationException ex) {
            throw new ArtifactResolverException("Invalid version specification: " + dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion(), (Exception)((Object)ex));
        }
        if (vr.hasRestrictions() && (version = this.findVersion(nodes, dependency.getGroupId(), dependency.getArtifactId())) == null) {
            if (vr.getRecommendedVersion() != null) {
                version = vr.getRecommendedVersion().toString();
            } else if (vr.hasRestrictions()) {
                for (Restriction restriction : vr.getRestrictions()) {
                    if (restriction.getLowerBound() != null) {
                        version = restriction.getLowerBound().toString();
                    }
                    if (restriction.getUpperBound() == null) continue;
                    version = restriction.getUpperBound().toString();
                }
            } else {
                version = vr.toString();
            }
        }
        if (version == null) {
            version = dependency.getVersion();
        }
        coordinate.setVersion(version);
        ArtifactType type = this.session.getRepositorySession().getArtifactTypeRegistry().get(dependency.getType());
        coordinate.setExtension(type.getExtension());
        coordinate.setClassifier(null == dependency.getClassifier() || dependency.getClassifier().isEmpty() ? type.getClassifier() : dependency.getClassifier());
        Artifact artifact = this.artifactResolver.resolveArtifact(buildingRequest, (ArtifactCoordinate)coordinate).getArtifact();
        artifact.setScope(dependency.getScope());
        return new DefaultDependencyNode(parent, artifact, dependency.getVersion(), dependency.getScope(), null);
    }

    private String findVersion(List<DependencyNode> nodes, String groupId, String artifactId) {
        Optional<DependencyNode> f = nodes.stream().filter(p -> groupId.equals(p.getArtifact().getGroupId()) && artifactId.equals(p.getArtifact().getArtifactId())).findFirst();
        if (f.isPresent()) {
            return f.get().getArtifact().getVersion();
        }
        return null;
    }

    private ExceptionCollection collectDependencyManagementDependencies(Engine engine, ProjectBuildingRequest buildingRequest, MavenProject project, List<DependencyNode> nodes, boolean aggregate) {
        if (this.skipDependencyManagement || project.getDependencyManagement() == null) {
            return null;
        }
        ExceptionCollection exCol = null;
        for (Dependency dependency : project.getDependencyManagement().getDependencies()) {
            try {
                nodes.add(this.toDependencyNode(nodes, buildingRequest, null, dependency));
            }
            catch (ArtifactResolverException ex) {
                this.getLog().debug((CharSequence)String.format("Aggregate : %s", aggregate));
                boolean addException = true;
                if (aggregate && this.addReactorDependency(engine, (Artifact)new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getScope(), dependency.getType(), dependency.getClassifier(), (ArtifactHandler)new DefaultArtifactHandler()))) {
                    addException = false;
                }
                if (!addException) continue;
                if (exCol == null) {
                    exCol = new ExceptionCollection();
                }
                exCol.addException((Throwable)ex);
            }
        }
        return exCol;
    }

    private ExceptionCollection collectMavenDependencies(Engine engine, MavenProject project, List<DependencyNode> nodes, ProjectBuildingRequest buildingRequest, boolean aggregate) {
        ExceptionCollection exCol = this.collectDependencyManagementDependencies(engine, buildingRequest, project, nodes, aggregate);
        for (DependencyNode dependencyNode : nodes) {
            if (this.artifactScopeExcluded.passes((Object)dependencyNode.getArtifact().getScope()) || this.artifactTypeExcluded.passes((Object)dependencyNode.getArtifact().getType())) continue;
            boolean isResolved = false;
            File artifactFile = null;
            String artifactId = null;
            String groupId = null;
            String version = null;
            List availableVersions = null;
            if ("system".equals(dependencyNode.getArtifact().getScope())) {
                Artifact a = dependencyNode.getArtifact();
                if (a.isResolved() && a.getFile().isFile()) {
                    artifactFile = a.getFile();
                    isResolved = artifactFile.isFile();
                    groupId = a.getGroupId();
                    artifactId = a.getArtifactId();
                    version = a.getVersion();
                    availableVersions = a.getAvailableVersions();
                } else {
                    for (Dependency d : project.getDependencies()) {
                        if (d.getSystemPath() == null || !BaseDependencyCheckMojo.artifactsMatch(d, a)) continue;
                        artifactFile = new File(d.getSystemPath());
                        isResolved = artifactFile.isFile();
                        groupId = a.getGroupId();
                        artifactId = a.getArtifactId();
                        version = a.getVersion();
                        availableVersions = a.getAvailableVersions();
                        break;
                    }
                }
                if (!isResolved) {
                    this.getLog().error((CharSequence)("Unable to resolve system scoped dependency: " + dependencyNode.toNodeString()));
                    if (exCol == null) {
                        exCol = new ExceptionCollection();
                    }
                    exCol.addException((Throwable)new DependencyNotFoundException("Unable to resolve system scoped dependency: " + dependencyNode.toNodeString()));
                }
            } else {
                Artifact result;
                Artifact dependencyArtifact = dependencyNode.getArtifact();
                if (dependencyArtifact.isResolved()) {
                    this.getLog().debug((CharSequence)String.format("Skipping artifact %s, already resolved", dependencyArtifact.getArtifactId()));
                    result = dependencyArtifact;
                } else {
                    ArtifactCoordinate coordinate = TransferUtils.toArtifactCoordinate((Artifact)dependencyNode.getArtifact());
                    try {
                        result = this.artifactResolver.resolveArtifact(buildingRequest, coordinate).getArtifact();
                    }
                    catch (ArtifactResolverException ex) {
                        this.getLog().debug((CharSequence)String.format("Aggregate : %s", aggregate));
                        boolean addException = true;
                        if (aggregate && this.addReactorDependency(engine, dependencyNode.getArtifact())) {
                            addException = false;
                        }
                        if (!addException) continue;
                        if (exCol == null) {
                            exCol = new ExceptionCollection();
                        }
                        exCol.addException((Throwable)ex);
                        continue;
                    }
                }
                if (aggregate && this.virtualSnapshotsFromReactor.booleanValue() && dependencyNode.getArtifact().isSnapshot() && this.addSnapshotReactorDependency(engine, dependencyNode.getArtifact())) continue;
                isResolved = result.isResolved();
                artifactFile = result.getFile();
                groupId = result.getGroupId();
                artifactId = result.getArtifactId();
                version = result.getVersion();
                availableVersions = result.getAvailableVersions();
            }
            if (isResolved && artifactFile != null) {
                String msg;
                org.owasp.dependencycheck.dependency.Dependency d;
                List deps = engine.scan(artifactFile.getAbsoluteFile(), this.createProjectReferenceName(project, dependencyNode));
                if (deps != null) {
                    d = null;
                    if (deps.size() == 1) {
                        d = (org.owasp.dependencycheck.dependency.Dependency)deps.get(0);
                    } else {
                        for (org.owasp.dependencycheck.dependency.Dependency possible : deps) {
                            if (!artifactFile.getAbsoluteFile().equals(possible.getActualFile())) continue;
                            d = possible;
                            break;
                        }
                    }
                    if (d != null) {
                        MavenArtifact ma = new MavenArtifact(groupId, artifactId, version);
                        d.addAsEvidence("pom", ma, Confidence.HIGHEST);
                        if (availableVersions != null) {
                            for (ArtifactVersion av : availableVersions) {
                                d.addAvailableVersion(av.toString());
                            }
                        }
                        this.getLog().debug((CharSequence)String.format("Adding project reference %s on dependency %s", project.getName(), d.getDisplayFileName()));
                        continue;
                    }
                    if (!this.getLog().isDebugEnabled()) continue;
                    String msg2 = String.format("More than 1 dependency was identified in first pass scan of '%s' in project %s", dependencyNode.getArtifact().getId(), project.getName());
                    this.getLog().debug((CharSequence)msg2);
                    continue;
                }
                if ("import".equals(dependencyNode.getArtifact().getScope())) {
                    msg = String.format("Skipping '%s:%s' in project %s as it uses an `import` scope", dependencyNode.getArtifact().getId(), dependencyNode.getArtifact().getScope(), project.getName());
                    this.getLog().debug((CharSequence)msg);
                    continue;
                }
                if ("pom".equals(dependencyNode.getArtifact().getType())) {
                    try {
                        d = new org.owasp.dependencycheck.dependency.Dependency(artifactFile.getAbsoluteFile());
                        Model pom = PomUtils.readPom((File)artifactFile.getAbsoluteFile());
                        JarAnalyzer.setPomEvidence((org.owasp.dependencycheck.dependency.Dependency)d, (Model)pom, null, (boolean)true);
                        engine.addDependency(d);
                    }
                    catch (AnalysisException ex) {
                        if (exCol == null) {
                            exCol = new ExceptionCollection();
                        }
                        exCol.addException((Throwable)ex);
                        this.getLog().debug((CharSequence)("Error reading pom " + artifactFile.getAbsoluteFile()), (Throwable)ex);
                    }
                    continue;
                }
                msg = String.format("No analyzer could be found for '%s:%s' in project %s", dependencyNode.getArtifact().getId(), dependencyNode.getArtifact().getScope(), project.getName());
                this.getLog().warn((CharSequence)msg);
                continue;
            }
            String msg = String.format("Unable to resolve '%s' in project %s", dependencyNode.getArtifact().getId(), project.getName());
            this.getLog().debug((CharSequence)msg);
            if (exCol != null) continue;
            exCol = new ExceptionCollection();
        }
        return exCol;
    }

    protected String createProjectReferenceName(MavenProject project, DependencyNode dependencyNode) {
        return project.getName() + ":" + dependencyNode.getArtifact().getScope();
    }

    private ExceptionCollection collectDependencies(Engine engine, MavenProject project, List<DependencyNode> nodes, ProjectBuildingRequest buildingRequest, boolean aggregate) {
        List<FileSet> projectScan;
        ExceptionCollection exCol = this.collectMavenDependencies(engine, project, nodes, buildingRequest, aggregate);
        if (this.scanDirectory != null && !this.scanDirectory.isEmpty()) {
            if (this.scanSet == null) {
                this.scanSet = new ArrayList<FileSet>();
            }
            this.scanDirectory.stream().forEach(d -> {
                FileSet fs = new FileSet();
                fs.setDirectory(d);
                fs.addInclude(INCLUDE_ALL);
                this.scanSet.add(fs);
            });
        }
        if (this.scanSet == null || this.scanSet.isEmpty()) {
            FileSet resourcesSet = new FileSet();
            FileSet filtersSet = new FileSet();
            FileSet webappSet = new FileSet();
            FileSet mixedLangSet = new FileSet();
            try {
                resourcesSet.setDirectory(new File(project.getBasedir(), "src/main/resources").getCanonicalPath());
                resourcesSet.addInclude(INCLUDE_ALL);
                filtersSet.setDirectory(new File(project.getBasedir(), "src/main/filters").getCanonicalPath());
                filtersSet.addInclude(INCLUDE_ALL);
                webappSet.setDirectory(new File(project.getBasedir(), "src/main/webapp").getCanonicalPath());
                webappSet.addInclude(INCLUDE_ALL);
                mixedLangSet.setDirectory(project.getBasedir().getCanonicalPath());
                mixedLangSet.addInclude("package.json");
                mixedLangSet.addInclude("package-lock.json");
                mixedLangSet.addInclude("npm-shrinkwrap.json");
                mixedLangSet.addInclude("Gopkg.lock");
                mixedLangSet.addInclude("go.mod");
            }
            catch (IOException ex) {
                if (exCol == null) {
                    exCol = new ExceptionCollection();
                }
                exCol.addException((Throwable)ex);
            }
            projectScan = new ArrayList<FileSet>();
            projectScan.add(resourcesSet);
            projectScan.add(filtersSet);
            projectScan.add(webappSet);
            projectScan.add(mixedLangSet);
        } else if (aggregate) {
            projectScan = new ArrayList<FileSet>();
            for (FileSet copyFrom : this.scanSet) {
                FileSet fsCopy = new FileSet();
                File f = new File(copyFrom.getDirectory());
                if (f.isAbsolute()) {
                    fsCopy.setDirectory(copyFrom.getDirectory());
                } else {
                    try {
                        fsCopy.setDirectory(new File(project.getBasedir(), copyFrom.getDirectory()).getCanonicalPath());
                    }
                    catch (IOException ex) {
                        if (exCol == null) {
                            exCol = new ExceptionCollection();
                        }
                        exCol.addException((Throwable)ex);
                        fsCopy.setDirectory(copyFrom.getDirectory());
                    }
                }
                fsCopy.setDirectoryMode(copyFrom.getDirectoryMode());
                fsCopy.setExcludes(copyFrom.getExcludes());
                fsCopy.setFileMode(copyFrom.getFileMode());
                fsCopy.setFollowSymlinks(copyFrom.isFollowSymlinks());
                fsCopy.setIncludes(copyFrom.getIncludes());
                fsCopy.setLineEnding(copyFrom.getLineEnding());
                fsCopy.setMapper(copyFrom.getMapper());
                fsCopy.setModelEncoding(copyFrom.getModelEncoding());
                fsCopy.setOutputDirectory(copyFrom.getOutputDirectory());
                fsCopy.setUseDefaultExcludes(copyFrom.isUseDefaultExcludes());
                projectScan.add(fsCopy);
            }
        } else {
            projectScan = this.scanSet;
        }
        FileSetManager fileSetManager = new FileSetManager();
        for (FileSet fileSet : projectScan) {
            String[] includedFiles;
            this.getLog().debug((CharSequence)("Scanning fileSet: " + fileSet.getDirectory()));
            for (String include : includedFiles = fileSetManager.getIncludedFiles(fileSet)) {
                File includeFile = new File(fileSet.getDirectory(), include).getAbsoluteFile();
                if (!includeFile.exists()) continue;
                engine.scan(includeFile, project.getName());
            }
        }
        return exCol;
    }

    private boolean addReactorDependency(Engine engine, Artifact artifact) {
        return this.addVirtualDependencyFromReactor(engine, artifact, "Unable to resolve %s as it has not been built yet - creating a virtual dependency instead.");
    }

    private boolean addVirtualDependencyFromReactor(Engine engine, Artifact artifact, String infoLogTemplate) {
        this.getLog().debug((CharSequence)String.format("Checking the reactor projects (%d) for %s:%s:%s", this.reactorProjects.size(), artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
        for (MavenProject prj : this.reactorProjects) {
            PurlIdentifier id;
            org.owasp.dependencycheck.dependency.Dependency d;
            this.getLog().debug((CharSequence)String.format("Comparing %s:%s:%s to %s:%s:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion(), prj.getGroupId(), prj.getArtifactId(), prj.getVersion()));
            if (!prj.getArtifactId().equals(artifact.getArtifactId()) || !prj.getGroupId().equals(artifact.getGroupId()) || !prj.getVersion().equals(artifact.getBaseVersion())) continue;
            String displayName = String.format("%s:%s:%s", prj.getGroupId(), prj.getArtifactId(), prj.getVersion());
            this.getLog().info((CharSequence)String.format(infoLogTemplate, displayName));
            File pom = new File(prj.getBasedir(), "pom.xml");
            if (pom.isFile()) {
                this.getLog().debug((CharSequence)"Adding virtual dependency from pom.xml");
                d = new org.owasp.dependencycheck.dependency.Dependency(pom, true);
            } else {
                d = new org.owasp.dependencycheck.dependency.Dependency(true);
            }
            String key = String.format("%s:%s:%s", prj.getGroupId(), prj.getArtifactId(), prj.getVersion());
            d.setSha1sum(Checksum.getSHA1Checksum((String)key));
            d.setSha256sum(Checksum.getSHA256Checksum((String)key));
            d.setMd5sum(Checksum.getMD5Checksum((String)key));
            d.setEcosystem("java");
            d.setDisplayFileName(displayName);
            d.addEvidence(EvidenceType.PRODUCT, "project", "artifactid", prj.getArtifactId(), Confidence.HIGHEST);
            d.addEvidence(EvidenceType.VENDOR, "project", "artifactid", prj.getArtifactId(), Confidence.LOW);
            d.addEvidence(EvidenceType.VENDOR, "project", "groupid", prj.getGroupId(), Confidence.HIGHEST);
            d.addEvidence(EvidenceType.PRODUCT, "project", "groupid", prj.getGroupId(), Confidence.LOW);
            d.setEcosystem("java");
            try {
                id = new PurlIdentifier("maven", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), Confidence.HIGHEST);
            }
            catch (MalformedPackageURLException ex) {
                this.getLog().debug((CharSequence)("Unable to create PackageURL object:" + key));
                id = new GenericIdentifier("maven:" + key, Confidence.HIGHEST);
            }
            d.addSoftwareIdentifier((Identifier)id);
            d.setName(String.format("%s:%s", prj.getGroupId(), prj.getArtifactId()));
            d.setVersion(prj.getVersion());
            d.setPackagePath(displayName);
            if (prj.getDescription() != null) {
                JarAnalyzer.addDescription((org.owasp.dependencycheck.dependency.Dependency)d, (String)prj.getDescription(), (String)"project", (String)"description");
            }
            for (License l : prj.getLicenses()) {
                StringBuilder license = new StringBuilder();
                if (l.getName() != null) {
                    license.append(l.getName());
                }
                if (l.getUrl() != null) {
                    license.append(" ").append(l.getUrl());
                }
                if (d.getLicense() == null) {
                    d.setLicense(license.toString());
                    continue;
                }
                if (d.getLicense().contains(license)) continue;
                d.setLicense(String.format("%s%n%s", d.getLicense(), license.toString()));
            }
            engine.addDependency(d);
            return true;
        }
        return false;
    }

    private boolean addSnapshotReactorDependency(Engine engine, Artifact artifact) {
        if (!artifact.isSnapshot()) {
            return false;
        }
        return this.addVirtualDependencyFromReactor(engine, artifact, "Found snapshot reactor project in aggregate for %s - creating a virtual dependency as the snapshot found in the repository may contain outdated dependencies.");
    }

    public ProjectBuildingRequest newResolveArtifactProjectBuildingRequest(MavenProject project) {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setRemoteRepositories(new ArrayList(project.getRemoteArtifactRepositories()));
        buildingRequest.setProject(project);
        return buildingRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runCheck() throws MojoExecutionException, MojoFailureException {
        block29: {
            this.muteJCS();
            try (Engine engine = this.initializeEngine();){
                ExceptionCollection exCol = this.scanDependencies(engine);
                try {
                    engine.analyzeDependencies();
                }
                catch (ExceptionCollection ex) {
                    exCol = this.handleAnalysisExceptions(exCol, ex);
                }
                if (exCol != null && exCol.isFatal()) break block29;
                File outputDir = this.getCorrectOutputDirectory(this.getProject());
                if (outputDir == null) {
                    outputDir = new File(this.getProject().getBuild().getDirectory());
                }
                try {
                    MavenProject p = this.getProject();
                    for (String f : this.getFormats()) {
                        engine.writeReports(p.getName(), p.getGroupId(), p.getArtifactId(), p.getVersion(), outputDir, f, exCol);
                    }
                }
                catch (ReportException ex) {
                    if (exCol == null) {
                        exCol = new ExceptionCollection((Throwable)ex);
                    } else {
                        exCol.addException((Throwable)ex);
                    }
                    if (this.isFailOnError()) {
                        throw new MojoExecutionException("One or more exceptions occurred during dependency-check analysis", (Exception)((Object)exCol));
                    }
                    this.getLog().debug((CharSequence)"Error writing the report", (Throwable)ex);
                }
                this.showSummary(this.getProject(), engine.getDependencies());
                this.checkForFailure(engine.getDependencies());
                if (exCol != null && this.isFailOnError()) {
                    throw new MojoExecutionException("One or more exceptions occurred during dependency-check analysis", (Exception)((Object)exCol));
                }
            }
            catch (DatabaseException ex) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)"Database connection error", (Throwable)ex);
                }
                String msg = "An exception occurred connecting to the local database. Please see the log file for more details.";
                if (this.isFailOnError()) {
                    throw new MojoExecutionException("An exception occurred connecting to the local database. Please see the log file for more details.", (Exception)((Object)ex));
                }
                this.getLog().error((CharSequence)"An exception occurred connecting to the local database. Please see the log file for more details.", (Throwable)ex);
            }
            finally {
                this.getSettings().cleanup();
            }
        }
    }

    private ExceptionCollection handleAnalysisExceptions(ExceptionCollection currentEx, ExceptionCollection newEx) throws MojoExecutionException {
        ExceptionCollection returnEx = currentEx;
        if (returnEx == null) {
            returnEx = newEx;
        } else {
            returnEx.getExceptions().addAll(newEx.getExceptions());
            if (newEx.isFatal()) {
                returnEx.setFatal(true);
            }
        }
        if (returnEx.isFatal()) {
            String msg = String.format("Fatal exception(s) analyzing %s", this.getProject().getName());
            if (this.isFailOnError()) {
                throw new MojoExecutionException(msg, (Exception)((Object)returnEx));
            }
            this.getLog().error((CharSequence)msg);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Throwable)returnEx);
            }
        } else {
            String msg = String.format("Exception(s) analyzing %s", this.getProject().getName());
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)msg, (Throwable)returnEx);
            }
        }
        return returnEx;
    }

    protected abstract ExceptionCollection scanDependencies(Engine var1) throws MojoExecutionException;

    public File getReportOutputDirectory() {
        return this.reportOutputDirectory;
    }

    public void setReportOutputDirectory(File directory) {
        this.reportOutputDirectory = directory;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public final boolean isExternalReport() {
        return true;
    }

    public String getOutputName() {
        Set<String> selectedFormats = this.getFormats();
        if (selectedFormats.contains("HTML") || selectedFormats.contains("ALL") || selectedFormats.size() > 1) {
            return "dependency-check-report";
        }
        if (selectedFormats.contains("XML")) {
            return "dependency-check-report.xml";
        }
        if (selectedFormats.contains("JUNIT")) {
            return "dependency-check-junit.xml";
        }
        if (selectedFormats.contains("JSON")) {
            return "dependency-check-report.json";
        }
        if (selectedFormats.contains("CSV")) {
            return "dependency-check-report.csv";
        }
        this.getLog().warn((CharSequence)"Unknown report format used during site generation.");
        return "dependency-check-report";
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    protected Engine initializeEngine() throws DatabaseException {
        this.populateSettings();
        return new Engine(this.settings);
    }

    protected void populateSettings() {
        this.settings = new Settings();
        InputStream mojoProperties = null;
        try {
            mojoProperties = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(PROPERTIES_FILE);
            this.settings.mergeProperties(mojoProperties);
        }
        catch (IOException ex) {
            this.getLog().warn((CharSequence)"Unable to load the dependency-check maven mojo.properties file.");
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"", (Throwable)ex);
            }
        }
        finally {
            block29: {
                if (mojoProperties != null) {
                    try {
                        mojoProperties.close();
                    }
                    catch (IOException ex) {
                        if (!this.getLog().isDebugEnabled()) break block29;
                        this.getLog().debug((CharSequence)"", (Throwable)ex);
                    }
                }
            }
        }
        this.settings.setBooleanIfNotNull("odc.autoupdate", this.autoUpdate);
        this.settings.setBooleanIfNotNull("analyzer.experimental.enabled", this.enableExperimental);
        this.settings.setBooleanIfNotNull("analyzer.retired.enabled", this.enableRetired);
        this.settings.setBooleanIfNotNull("analyzer.golang.dep.enabled", this.golangDepEnabled);
        this.settings.setBooleanIfNotNull("analyzer.golang.mod.enabled", this.golangModEnabled);
        this.settings.setStringIfNotNull("analyzer.golang.path", this.pathToGo);
        Proxy proxy = this.getMavenProxy();
        if (proxy != null) {
            this.settings.setString("proxy.server", proxy.getHost());
            this.settings.setString("proxy.port", Integer.toString(proxy.getPort()));
            String userName = proxy.getUsername();
            String password = proxy.getPassword();
            if (password != null && !password.isEmpty()) {
                if (this.settings.getBoolean("proxy.disableSchemas", true)) {
                    System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
                }
                try {
                    password = this.decryptPasswordFromSettings(password);
                }
                catch (SecDispatcherException ex) {
                    password = this.handleSecDispatcherException("proxy", proxy.getId(), password, ex);
                }
            }
            this.settings.setStringIfNotNull("proxy.username", userName);
            this.settings.setStringIfNotNull("proxy.password", password);
            this.settings.setStringIfNotNull("proxy.nonproxyhosts", proxy.getNonProxyHosts());
        }
        String[] suppressions = this.determineSuppressions();
        this.settings.setArrayIfNotEmpty("suppression.file", suppressions);
        this.settings.setBooleanIfNotNull("updater.versioncheck.enabled", Boolean.valueOf(this.versionCheckEnabled));
        this.settings.setStringIfNotEmpty("connection.timeout", this.connectionTimeout);
        this.settings.setStringIfNotEmpty("hints.file", this.hintsFile);
        this.settings.setFloat("junit.fail.on.cvss", this.junitFailOnCVSS);
        this.settings.setBooleanIfNotNull("analyzer.jar.enabled", this.jarAnalyzerEnabled);
        this.settings.setBooleanIfNotNull("analyzer.nuspec.enabled", this.nuspecAnalyzerEnabled);
        this.settings.setBooleanIfNotNull("analyzer.nugetconf.enabled", this.nugetconfAnalyzerEnabled);
        this.settings.setBooleanIfNotNull("analyzer.central.enabled", this.centralAnalyzerEnabled);
        this.settings.setBooleanIfNotNull("analyzer.central.use.cache", this.centralAnalyzerUseCache);
        this.settings.setBooleanIfNotNull("analyzer.artifactory.enabled", this.artifactoryAnalyzerEnabled);
        this.settings.setBooleanIfNotNull("analyzer.nexus.enabled", this.nexusAnalyzerEnabled);
        this.settings.setBooleanIfNotNull("analyzer.assembly.enabled", this.assemblyAnalyzerEnabled);
        this.settings.setBooleanIfNotNull("analyzer.archive.enabled", this.archiveAnalyzerEnabled);
        this.settings.setStringIfNotEmpty("extensions.zip", this.zipExtensions);
        this.settings.setStringIfNotEmpty("analyzer.assembly.dotnet.path", this.pathToCore);
        this.settings.setStringIfNotEmpty("analyzer.nexus.url", this.nexusUrl);
        this.configureServerCredentials(this.nexusServerId, "analyzer.nexus.username", "analyzer.nexus.password");
        this.settings.setBooleanIfNotNull("analyzer.nexus.proxy", this.nexusUsesProxy);
        this.settings.setStringIfNotNull("analyzer.artifactory.url", this.artifactoryAnalyzerUrl);
        this.settings.setBooleanIfNotNull("analyzer.artifactory.proxy", this.artifactoryAnalyzerUseProxy);
        this.settings.setBooleanIfNotNull("analyzer.artifactory.parallel.analysis", this.artifactoryAnalyzerParallelAnalysis);
        if (Boolean.TRUE.equals(this.artifactoryAnalyzerEnabled)) {
            if (this.artifactoryAnalyzerServerId != null) {
                this.configureServerCredentials(this.artifactoryAnalyzerServerId, "analyzer.artifactory.api.username", "analyzer.artifactory.api.token");
            } else {
                this.settings.setStringIfNotNull("analyzer.artifactory.api.username", this.artifactoryAnalyzerUsername);
                this.settings.setStringIfNotNull("analyzer.artifactory.api.token", this.artifactoryAnalyzerApiToken);
            }
            this.settings.setStringIfNotNull("analyzer.artifactory.bearer.token", this.artifactoryAnalyzerBearerToken);
        }
        this.settings.setBooleanIfNotNull("analyzer.python.distribution.enabled", this.pyDistributionAnalyzerEnabled);
        this.settings.setBooleanIfNotNull("analyzer.python.package.enabled", this.pyPackageAnalyzerEnabled);
        this.settings.setBooleanIfNotNull("analyzer.ruby.gemspec.enabled", this.rubygemsAnalyzerEnabled);
        this.settings.setBooleanIfNotNull("analyzer.openssl.enabled", this.opensslAnalyzerEnabled);
        this.settings.setBooleanIfNotNull("analyzer.cmake.enabled", this.cmakeAnalyzerEnabled);
        this.settings.setBooleanIfNotNull("analyzer.autoconf.enabled", this.autoconfAnalyzerEnabled);
        this.settings.setBooleanIfNotNull("analyzer.pip.enabled", this.pipAnalyzerEnabled);
        this.settings.setBooleanIfNotNull("analyzer.pipfile.enabled", this.pipfileAnalyzerEnabled);
        this.settings.setBooleanIfNotNull("analyzer.composer.lock.enabled", this.composerAnalyzerEnabled);
        this.settings.setBooleanIfNotNull("analyzer.node.package.enabled", this.nodeAnalyzerEnabled);
        this.settings.setBooleanIfNotNull("analyzer.node.audit.enabled", this.nodeAuditAnalyzerEnabled);
        this.settings.setBooleanIfNotNull("analyzer.node.audit.use.cache", this.nodeAuditAnalyzerUseCache);
        this.settings.setBooleanIfNotNull("analyzer.node.audit.skipdev", this.nodeAuditSkipDevDependencies);
        this.settings.setBooleanIfNotNull("analyzer.retirejs.enabled", this.retireJsAnalyzerEnabled);
        this.settings.setStringIfNotNull("analyzer.retirejs.repo.js.url", this.retireJsUrl);
        this.settings.setBooleanIfNotNull("analyzer.retirejs.forceupdate", this.retireJsForceUpdate);
        this.settings.setBooleanIfNotNull("analyzer.mix.audit.enabled", this.mixAuditAnalyzerEnabled);
        this.settings.setStringIfNotNull("analyzer.mix.audit.path", this.mixAuditPath);
        this.settings.setBooleanIfNotNull("analyzer.bundle.audit.enabled", this.bundleAuditAnalyzerEnabled);
        this.settings.setStringIfNotNull("analyzer.bundle.audit.path", this.bundleAuditPath);
        this.settings.setStringIfNotNull("analyzer.bundle.audit.working.directory", this.bundleAuditWorkingDirectory);
        this.settings.setBooleanIfNotNull("analyzer.cocoapods.enabled", this.cocoapodsAnalyzerEnabled);
        this.settings.setBooleanIfNotNull("analyzer.swift.package.manager.enabled", this.swiftPackageManagerAnalyzerEnabled);
        this.settings.setBooleanIfNotNull("analyzer.ossindex.enabled", this.ossindexAnalyzerEnabled);
        this.settings.setStringIfNotEmpty("analyzer.ossindex.url", this.ossindexAnalyzerUrl);
        this.configureServerCredentials(this.ossIndexServerId, "analyzer.ossindex.user", "analyzer.ossindex.password");
        this.settings.setBooleanIfNotNull("analyzer.ossindex.use.cache", this.ossindexAnalyzerUseCache);
        if (this.retirejs != null) {
            this.settings.setBooleanIfNotNull("analyzer.retirejs.filternonvulnerable", this.retirejs.getFilterNonVulnerable());
            this.settings.setArrayIfNotEmpty("analyzer.retirejs.filters", this.retirejs.getFilters());
        }
        this.settings.setStringIfNotEmpty("data.driver_name", this.databaseDriverName);
        this.settings.setStringIfNotEmpty("data.driver_path", this.databaseDriverPath);
        this.settings.setStringIfNotEmpty("data.connection_string", this.connectionString);
        if (this.databaseUser == null && this.databasePassword == null && this.serverId != null) {
            this.configureServerCredentials(this.serverId, "data.user", "data.password");
        } else {
            this.settings.setStringIfNotEmpty("data.user", this.databaseUser);
            this.settings.setStringIfNotEmpty("data.password", this.databasePassword);
        }
        this.settings.setStringIfNotEmpty("data.directory", this.dataDirectory);
        this.settings.setStringIfNotEmpty("data.file_name", this.dbFilename);
        this.settings.setStringIfNotEmpty("cve.url.modified", this.cveUrlModified);
        this.settings.setStringIfNotEmpty("cve.url.base", this.cveUrlBase);
        this.settings.setIntIfNotNull("cve.check.validforhours", this.cveValidForHours);
        this.settings.setBooleanIfNotNull("odc.reports.pretty.print", this.prettyPrint);
        this.artifactScopeExcluded = new ArtifactScopeExcluded(this.skipTestScope, this.skipProvidedScope, this.skipSystemScope, this.skipRuntimeScope);
        this.artifactTypeExcluded = new ArtifactTypeExcluded(this.skipArtifactType);
        if (this.cveUser == null && this.cvePassword == null && this.cveServerId != null) {
            this.configureServerCredentials(this.cveServerId, "cve.user", "cve.password");
        } else {
            this.settings.setStringIfNotEmpty("cve.user", this.cveUser);
            this.settings.setStringIfNotEmpty("cve.password", this.cvePassword);
        }
        if (this.suppressionFileUser == null && this.suppressionFilePassword == null && this.suppressionFileServerId != null) {
            this.configureServerCredentials(this.suppressionFileServerId, "suppression.file.user", "suppression.file.password");
        } else {
            this.settings.setStringIfNotEmpty("suppression.file.user", this.suppressionFileUser);
            this.settings.setStringIfNotEmpty("suppression.file.password", this.suppressionFilePassword);
        }
    }

    private void configureServerCredentials(String serverId, String userSettingKey, String passwordSettingKey) {
        if (serverId != null) {
            Server server = this.settingsXml.getServer(serverId);
            if (server != null) {
                String username = server.getUsername();
                String password = null;
                try {
                    password = this.decryptPasswordFromSettings(server.getPassword());
                }
                catch (SecDispatcherException ex) {
                    password = this.handleSecDispatcherException("server", serverId, server.getPassword(), ex);
                }
                this.settings.setStringIfNotEmpty(userSettingKey, username);
                this.settings.setStringIfNotEmpty(passwordSettingKey, password);
            } else {
                this.getLog().error((CharSequence)String.format("Server '%s' not found in the settings.xml file", serverId));
            }
        }
    }

    private String decryptPasswordFromSettings(String password) throws SecDispatcherException {
        if (this.securityDispatcher instanceof DefaultSecDispatcher) {
            ((DefaultSecDispatcher)this.securityDispatcher).setConfigurationFile("~/.m2/settings-security.xml");
        }
        return this.securityDispatcher.decrypt(password);
    }

    private String handleSecDispatcherException(String settingsElementName, String settingsElementId, String passwordValueFromSettings, SecDispatcherException ex) {
        String password = passwordValueFromSettings;
        if (ex.getCause() instanceof FileNotFoundException || ex.getCause() != null && ex.getCause().getCause() instanceof FileNotFoundException) {
            String tmp = passwordValueFromSettings;
            if (tmp.startsWith("{") && tmp.endsWith("}")) {
                this.getLog().error((CharSequence)String.format("Unable to decrypt the %s password for %s id '%s' in settings.xml%n\tCause: %s", settingsElementName, settingsElementName, settingsElementId, ex.getMessage()));
            } else {
                password = tmp;
            }
        } else {
            this.getLog().error((CharSequence)String.format("Unable to decrypt the %s password for %s id '%s' in settings.xml%n\tCause: %s", settingsElementName, settingsElementName, settingsElementId, ex.getMessage()));
        }
        return password;
    }

    private String[] determineSuppressions() {
        String[] suppressions = this.suppressionFiles;
        if (this.suppressionFile != null) {
            if (suppressions == null) {
                suppressions = new String[]{this.suppressionFile};
            } else {
                suppressions = Arrays.copyOf(suppressions, suppressions.length + 1);
                suppressions[suppressions.length - 1] = this.suppressionFile;
            }
        }
        return suppressions;
    }

    private void muteJCS() {
        String[] noisyLoggers;
        for (String loggerName : noisyLoggers = new String[]{"org.apache.commons.jcs.auxiliary.disk.AbstractDiskCache", "org.apache.commons.jcs.engine.memory.AbstractMemoryCache", "org.apache.commons.jcs.engine.control.CompositeCache", "org.apache.commons.jcs.auxiliary.disk.indexed.IndexedDiskCache", "org.apache.commons.jcs.engine.control.CompositeCache", "org.apache.commons.jcs.engine.memory.AbstractMemoryCache", "org.apache.commons.jcs.engine.control.event.ElementEventQueue", "org.apache.commons.jcs.engine.memory.AbstractDoubleLinkedListMemoryCache", "org.apache.commons.jcs.auxiliary.AuxiliaryCacheConfigurator", "org.apache.commons.jcs.engine.control.CompositeCacheManager", "org.apache.commons.jcs.utils.threadpool.ThreadPoolManager", "org.apache.commons.jcs.engine.control.CompositeCacheConfigurator"}) {
            try {
                Logger l = LoggerFactory.getLogger((String)loggerName);
                Field f = l.getClass().getSuperclass().getDeclaredField("currentLogLevel");
                f.setAccessible(true);
                f.set(l, 40);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                this.getLog().debug((CharSequence)("Failed to reset the log level of " + loggerName + ", it will continue being noisy."));
            }
        }
    }

    private Proxy getMavenProxy() {
        block4: {
            List proxies;
            if (this.mavenSettings == null || (proxies = this.mavenSettings.getProxies()) == null || proxies.isEmpty()) break block4;
            if (this.mavenSettingsProxyId != null) {
                for (Proxy proxy : proxies) {
                    if (!this.mavenSettingsProxyId.equalsIgnoreCase(proxy.getId())) continue;
                    return proxy;
                }
            } else {
                for (Proxy aProxy : proxies) {
                    if (!aProxy.isActive()) continue;
                    return aProxy;
                }
            }
        }
        return null;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected List<MavenProject> getReactorProjects() {
        return this.reactorProjects;
    }

    private Set<String> getFormats() {
        HashSet invalid = new HashSet();
        HashSet<String> selectedFormats = this.formats == null || this.formats.length == 0 ? new HashSet<String>() : new HashSet<String>(Arrays.asList(this.formats));
        selectedFormats.forEach(s -> {
            try {
                ReportGenerator.Format.valueOf((String)s.toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                invalid.add(s);
            }
        });
        invalid.forEach(s -> this.getLog().warn((CharSequence)("Invalid report format specified: " + s)));
        if (selectedFormats.contains("true")) {
            selectedFormats.remove("true");
        }
        if (this.format != null && selectedFormats.isEmpty()) {
            selectedFormats.add(this.format);
        }
        return selectedFormats;
    }

    public List<String> getExcludes() {
        if (this.excludes == null) {
            this.excludes = new ArrayList<String>();
        }
        return this.excludes;
    }

    protected Filter<String> getArtifactScopeExcluded() {
        return this.artifactScopeExcluded;
    }

    protected Settings getSettings() {
        return this.settings;
    }

    protected void checkForFailure(org.owasp.dependencycheck.dependency.Dependency[] dependencies) throws MojoFailureException {
        StringBuilder ids = new StringBuilder();
        for (org.owasp.dependencycheck.dependency.Dependency d : dependencies) {
            boolean addName = true;
            for (Vulnerability v : d.getVulnerabilities()) {
                if (!(this.failBuildOnAnyVulnerability || v.getCvssV2() != null && v.getCvssV2().getScore() >= this.failBuildOnCVSS || v.getCvssV3() != null && v.getCvssV3().getBaseScore() >= this.failBuildOnCVSS || v.getUnscoredSeverity() != null && SeverityUtil.estimateCvssV2((String)v.getUnscoredSeverity()) >= this.failBuildOnCVSS) && !(this.failBuildOnCVSS <= 0.0f)) continue;
                if (addName) {
                    addName = false;
                    ids.append(NEW_LINE).append(d.getFileName()).append(": ");
                    ids.append(v.getName());
                    continue;
                }
                ids.append(", ").append(v.getName());
            }
        }
        if (ids.length() > 0) {
            String msg = this.showSummary ? (this.failBuildOnAnyVulnerability ? String.format("%n%nOne or more dependencies were identified with vulnerabilities: %n%s%n%nSee the dependency-check report for more details.%n%n", ids.toString()) : String.format("%n%nOne or more dependencies were identified with vulnerabilities that have a CVSS score greater than or equal to '%.1f': %n%s%n%nSee the dependency-check report for more details.%n%n", Float.valueOf(this.failBuildOnCVSS), ids.toString())) : String.format("%n%nOne or more dependencies were identified with vulnerabilities.%n%nSee the dependency-check report for more details.%n%n", new Object[0]);
            throw new MojoFailureException(msg);
        }
    }

    protected void showSummary(MavenProject mp, org.owasp.dependencycheck.dependency.Dependency[] dependencies) {
        if (this.showSummary) {
            DependencyCheckScanAgent.showSummary((String)mp.getName(), (org.owasp.dependencycheck.dependency.Dependency[])dependencies);
        }
    }
}

