/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.maven;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.Proxy;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Identifier;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.maven.Engine;
import org.owasp.dependencycheck.reporting.ReportGenerator;
import org.owasp.dependencycheck.utils.Settings;

public abstract class BaseDependencyCheckMojo
extends AbstractMojo
implements MavenReport {
    private static final String PROPERTIES_FILE = "mojo.properties";
    private static final String NEW_LINE = System.getProperty("line.separator", "\n").intern();
    @Parameter(property="metaFileName", defaultValue="dependency-check.ser", required=true)
    private String dataFileName;
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(readonly=true, required=true, property="reactorProjects")
    private List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(property="project.reporting.outputDirectory", required=true)
    private File reportOutputDirectory;
    @Parameter(property="failBuildOnCVSS", defaultValue="11", required=true)
    private float failBuildOnCVSS = 11.0f;
    @Parameter(property="autoupdate", defaultValue="true", required=true)
    private boolean autoUpdate = true;
    @Deprecated
    @Parameter(property="aggregate", defaultValue="false")
    private boolean aggregate;
    @Parameter(property="format", defaultValue="HTML", required=true)
    private String format = "HTML";
    @Parameter(property="mavenSettings", defaultValue="${settings}", required=false)
    private org.apache.maven.settings.Settings mavenSettings;
    @Parameter(property="mavenSettingsProxyId", required=false)
    private String mavenSettingsProxyId;
    @Parameter(property="connectionTimeout", defaultValue="", required=false)
    private String connectionTimeout = null;
    @Parameter(property="suppressionFile", defaultValue="", required=false)
    private String suppressionFile = null;
    @Parameter(property="showSummary", defaultValue="true", required=false)
    private boolean showSummary = true;
    @Parameter(property="jarAnalyzerEnabled", defaultValue="true", required=false)
    private boolean jarAnalyzerEnabled = true;
    @Parameter(property="archiveAnalyzerEnabled", defaultValue="true", required=false)
    private boolean archiveAnalyzerEnabled = true;
    @Parameter(property="assemblyAnalyzerEnabled", defaultValue="true", required=false)
    private boolean assemblyAnalyzerEnabled = true;
    @Parameter(property="nuspecAnalyzerEnabled", defaultValue="true", required=false)
    private boolean nuspecAnalyzerEnabled = true;
    @Parameter(property="centralAnalyzerEnabled", defaultValue="true", required=false)
    private boolean centralAnalyzerEnabled = true;
    @Parameter(property="nexusAnalyzerEnabled", defaultValue="true", required=false)
    private boolean nexusAnalyzerEnabled = true;
    @Parameter(property="nexusUrl", defaultValue="", required=false)
    private String nexusUrl;
    @Parameter(property="nexusUsesProxy", defaultValue="true", required=false)
    private boolean nexusUsesProxy = true;
    @Parameter(property="connectionString", defaultValue="", required=false)
    private String connectionString;
    @Parameter(property="databaseDriverName", defaultValue="", required=false)
    private String databaseDriverName;
    @Parameter(property="databaseDriverPath", defaultValue="", required=false)
    private String databaseDriverPath;
    @Parameter(property="databaseUser", defaultValue="", required=false)
    private String databaseUser;
    @Parameter(property="databasePassword", defaultValue="", required=false)
    private String databasePassword;
    @Parameter(property="zipExtensions", required=false)
    private String zipExtensions;
    @Parameter(property="skipTestScope", defaultValue="true", required=false)
    private boolean skipTestScope = true;
    @Parameter(property="skipRuntimeScope", defaultValue="false", required=false)
    private boolean skipRuntimeScope = false;
    @Parameter(property="skipProvidedScope", defaultValue="false", required=false)
    private boolean skipProvidedScope = false;
    @Parameter(property="dataDirectory", defaultValue="", required=false)
    private String dataDirectory;
    @Parameter(property="cveUrl12Modified", defaultValue="", required=false)
    private String cveUrl12Modified;
    @Parameter(property="cveUrl20Modified", defaultValue="", required=false)
    private String cveUrl20Modified;
    @Parameter(property="cveUrl12Base", defaultValue="", required=false)
    private String cveUrl12Base;
    @Parameter(property="cveUrl20Base", defaultValue="", required=false)
    private String cveUrl20Base;
    @Parameter(property="pathToMono", defaultValue="", required=false)
    private String pathToMono;
    @Deprecated
    @Parameter(property="proxyUrl", defaultValue="", required=false)
    private String proxyUrl = null;
    @Deprecated
    @Parameter(property="externalReport")
    private String externalReport = null;

    protected String getConnectionString() {
        return this.connectionString;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validateAggregate();
        this.project.setContextValue(this.getOutputDirectoryContextKey(), (Object)this.outputDirectory);
        this.runCheck();
    }

    private void validateAggregate() throws MojoExecutionException {
        if (this.aggregate) {
            String msg = "Aggregate configuration detected - as of dependency-check 1.2.8 this no longer supported. Please use the aggregate goal instead.";
            throw new MojoExecutionException("Aggregate configuration detected - as of dependency-check 1.2.8 this no longer supported. Please use the aggregate goal instead.");
        }
    }

    @Deprecated
    public final void generate(org.codehaus.doxia.sink.Sink sink, Locale locale) throws MavenReportException {
        this.generate((Sink)sink, locale);
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        try {
            this.validateAggregate();
        }
        catch (MojoExecutionException ex) {
            throw new MavenReportException(ex.getMessage());
        }
        this.project.setContextValue(this.getOutputDirectoryContextKey(), (Object)this.getReportOutputDirectory());
        try {
            this.runCheck();
        }
        catch (MojoExecutionException ex) {
            throw new MavenReportException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (MojoFailureException ex) {
            this.getLog().warn((CharSequence)"Vulnerabilities were identifies that exceed the CVSS threshold for failing the build");
        }
    }

    protected File getCorrectOutputDirectory() throws MojoExecutionException {
        return this.getCorrectOutputDirectory(this.project);
    }

    protected File getCorrectOutputDirectory(MavenProject current) {
        Object obj = current.getContextValue(this.getOutputDirectoryContextKey());
        if (obj != null && obj instanceof File) {
            return (File)obj;
        }
        File target = new File(current.getBuild().getDirectory());
        if (target.getParentFile() != null && "target".equals(target.getParentFile().getName())) {
            target = target.getParentFile();
        }
        return target;
    }

    protected File getDataFile(MavenProject current) {
        Object obj;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format("Getting data filefor %s using key '%s'", current.getName(), this.getDataFileContextKey()));
        }
        if ((obj = current.getContextValue(this.getDataFileContextKey())) != null) {
            if (obj instanceof String) {
                File f = new File((String)obj);
                return f;
            }
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Context value not found");
        }
        return null;
    }

    protected void scanArtifacts(MavenProject project, Engine engine) {
        for (Artifact a : project.getArtifacts()) {
            List deps;
            if (this.excludeFromScan(a) || (deps = engine.scan(a.getFile().getAbsoluteFile())) == null) continue;
            if (deps.size() == 1) {
                Dependency d = (Dependency)deps.get(0);
                if (d == null) continue;
                MavenArtifact ma = new MavenArtifact(a.getGroupId(), a.getArtifactId(), a.getVersion());
                d.addAsEvidence("pom", ma, Confidence.HIGHEST);
                d.addProjectReference(project.getName());
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)String.format("Adding project reference %s on dependency %s", project.getName(), d.getDisplayFileName()));
                continue;
            }
            if (!this.getLog().isDebugEnabled()) continue;
            String msg = String.format("More then 1 dependency was identified in first pass scan of '%s:%s:%s'", a.getGroupId(), a.getArtifactId(), a.getVersion());
            this.getLog().debug((CharSequence)msg);
        }
    }

    public abstract void runCheck() throws MojoExecutionException, MojoFailureException;

    public void setReportOutputDirectory(File directory) {
        this.reportOutputDirectory = directory;
    }

    public File getReportOutputDirectory() {
        return this.reportOutputDirectory;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public final boolean isExternalReport() {
        return true;
    }

    public String getOutputName() {
        if ("HTML".equalsIgnoreCase(this.format) || "ALL".equalsIgnoreCase(this.format)) {
            return "dependency-check-report";
        }
        if ("XML".equalsIgnoreCase(this.format)) {
            return "dependency-check-report.xml#";
        }
        if ("VULN".equalsIgnoreCase(this.format)) {
            return "dependency-check-vulnerability";
        }
        this.getLog().warn((CharSequence)"Unknown report format used during site generation.");
        return "dependency-check-report";
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    protected Engine initializeEngine() throws DatabaseException {
        this.populateSettings();
        return new Engine(this.project, this.reactorProjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateSettings() {
        Proxy proxy;
        Settings.initialize();
        InputStream mojoProperties = null;
        try {
            mojoProperties = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(PROPERTIES_FILE);
            Settings.mergeProperties((InputStream)mojoProperties);
        }
        catch (IOException ex) {
            this.getLog().warn((CharSequence)"Unable to load the dependency-check ant task.properties file.");
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"", (Throwable)ex);
            }
        }
        finally {
            block34: {
                if (mojoProperties != null) {
                    try {
                        mojoProperties.close();
                    }
                    catch (IOException ex) {
                        if (!this.getLog().isDebugEnabled()) break block34;
                        this.getLog().debug((CharSequence)"", (Throwable)ex);
                    }
                }
            }
        }
        Settings.setBoolean((String)"autoupdate", (boolean)this.autoUpdate);
        if (this.externalReport != null) {
            this.getLog().warn((CharSequence)"The 'externalReport' option was set; this configuration option has been removed. Please update the dependency-check-maven plugin's configuration");
        }
        if (this.proxyUrl != null && !this.proxyUrl.isEmpty()) {
            this.getLog().warn((CharSequence)"Deprecated configuration detected, proxyUrl will be ignored; use the maven settings to configure the proxy instead");
        }
        if ((proxy = this.getMavenProxy()) != null) {
            Settings.setString((String)"proxy.server", (String)proxy.getHost());
            Settings.setString((String)"proxy.port", (String)Integer.toString(proxy.getPort()));
            String userName = proxy.getUsername();
            String password = proxy.getPassword();
            if (userName != null) {
                Settings.setString((String)"proxy.username", (String)userName);
            }
            if (password != null) {
                Settings.setString((String)"proxy.password", (String)password);
            }
        }
        if (this.connectionTimeout != null && !this.connectionTimeout.isEmpty()) {
            Settings.setString((String)"connection.timeout", (String)this.connectionTimeout);
        }
        if (this.suppressionFile != null && !this.suppressionFile.isEmpty()) {
            Settings.setString((String)"suppression.file", (String)this.suppressionFile);
        }
        Settings.setBoolean((String)"analyzer.jar.enabled", (boolean)this.jarAnalyzerEnabled);
        Settings.setBoolean((String)"analyzer.nuspec.enabled", (boolean)this.nuspecAnalyzerEnabled);
        Settings.setBoolean((String)"analyzer.central.enabled", (boolean)this.centralAnalyzerEnabled);
        Settings.setBoolean((String)"analyzer.nexus.enabled", (boolean)this.nexusAnalyzerEnabled);
        if (this.nexusUrl != null && !this.nexusUrl.isEmpty()) {
            Settings.setString((String)"analyzer.nexus.url", (String)this.nexusUrl);
        }
        Settings.setBoolean((String)"analyzer.nexus.proxy", (boolean)this.nexusUsesProxy);
        Settings.setBoolean((String)"analyzer.archive.enabled", (boolean)this.archiveAnalyzerEnabled);
        if (this.zipExtensions != null && !this.zipExtensions.isEmpty()) {
            Settings.setString((String)"extensions.zip", (String)this.zipExtensions);
        }
        Settings.setBoolean((String)"analyzer.assembly.enabled", (boolean)this.assemblyAnalyzerEnabled);
        if (this.pathToMono != null && !this.pathToMono.isEmpty()) {
            Settings.setString((String)"analyzer.assembly.mono.path", (String)this.pathToMono);
        }
        if (this.databaseDriverName != null && !this.databaseDriverName.isEmpty()) {
            Settings.setString((String)"data.driver_name", (String)this.databaseDriverName);
        }
        if (this.databaseDriverPath != null && !this.databaseDriverPath.isEmpty()) {
            Settings.setString((String)"data.driver_path", (String)this.databaseDriverPath);
        }
        if (this.connectionString != null && !this.connectionString.isEmpty()) {
            Settings.setString((String)"data.connection_string", (String)this.connectionString);
        }
        if (this.databaseUser != null && !this.databaseUser.isEmpty()) {
            Settings.setString((String)"data.user", (String)this.databaseUser);
        }
        if (this.databasePassword != null && !this.databasePassword.isEmpty()) {
            Settings.setString((String)"data.password", (String)this.databasePassword);
        }
        if (this.dataDirectory != null && !this.dataDirectory.isEmpty()) {
            Settings.setString((String)"data.directory", (String)this.dataDirectory);
        }
        Settings.setBoolean((String)"skip.test.scope", (boolean)this.skipTestScope);
        Settings.setBoolean((String)"skip.runtime.scope", (boolean)this.skipRuntimeScope);
        Settings.setBoolean((String)"skip.provided.scope", (boolean)this.skipProvidedScope);
        if (this.cveUrl12Modified != null && !this.cveUrl12Modified.isEmpty()) {
            Settings.setString((String)"cve.url-1.2.modified", (String)this.cveUrl12Modified);
        }
        if (this.cveUrl20Modified != null && !this.cveUrl20Modified.isEmpty()) {
            Settings.setString((String)"cve.url-2.0.modified", (String)this.cveUrl20Modified);
        }
        if (this.cveUrl12Base != null && !this.cveUrl12Base.isEmpty()) {
            Settings.setString((String)"cve.url-1.2.base", (String)this.cveUrl12Base);
        }
        if (this.cveUrl20Base != null && !this.cveUrl20Base.isEmpty()) {
            Settings.setString((String)"cve.url-2.0.base", (String)this.cveUrl20Base);
        }
    }

    private Proxy getMavenProxy() {
        List proxies;
        if (this.mavenSettings != null && (proxies = this.mavenSettings.getProxies()) != null && !proxies.isEmpty()) {
            if (this.mavenSettingsProxyId != null) {
                for (Proxy proxy : proxies) {
                    if (!this.mavenSettingsProxyId.equalsIgnoreCase(proxy.getId())) continue;
                    return proxy;
                }
            } else {
                if (proxies.size() == 1) {
                    return (Proxy)proxies.get(0);
                }
                this.getLog().warn((CharSequence)"Multiple proxy definitions exist in the Maven settings. In the dependency-check configuration set the mavenSettingsProxyId so that the correct proxy will be used.");
                throw new IllegalStateException("Ambiguous proxy definition");
            }
        }
        return null;
    }

    protected boolean excludeFromScan(Artifact a) {
        if (this.skipTestScope && "test".equals(a.getScope())) {
            return true;
        }
        if (this.skipProvidedScope && "provided".equals(a.getScope())) {
            return true;
        }
        return this.skipRuntimeScope && !"runtime".equals(a.getScope());
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected List<MavenProject> getReactorProjects() {
        return this.reactorProjects;
    }

    protected String getFormat() {
        return this.format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeReports(Engine engine, MavenProject p, File outputDir) {
        block12: {
            DatabaseProperties prop = null;
            CveDB cve = null;
            try {
                cve = new CveDB();
                cve.open();
                prop = cve.getDatabaseProperties();
            }
            catch (DatabaseException ex) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)"Unable to retrieve DB Properties", (Throwable)ex);
                }
            }
            finally {
                if (cve != null) {
                    cve.close();
                }
            }
            ReportGenerator r = new ReportGenerator(p.getName(), engine.getDependencies(), engine.getAnalyzers(), prop);
            try {
                r.generateReports(outputDir.getAbsolutePath(), this.format);
            }
            catch (IOException ex) {
                this.getLog().error((CharSequence)"Unexpected exception occurred during analysis; please see the verbose error log for more details.");
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)"", (Throwable)ex);
                }
            }
            catch (Throwable ex) {
                this.getLog().error((CharSequence)"Unexpected exception occurred during analysis; please see the verbose error log for more details.");
                if (!this.getLog().isDebugEnabled()) break block12;
                this.getLog().debug((CharSequence)"", ex);
            }
        }
    }

    protected void checkForFailure(List<Dependency> dependencies) throws MojoFailureException {
        if (this.failBuildOnCVSS <= 10.0f) {
            StringBuilder ids = new StringBuilder();
            for (Dependency d : dependencies) {
                boolean addName = true;
                for (Vulnerability v : d.getVulnerabilities()) {
                    if (!(v.getCvssScore() >= this.failBuildOnCVSS)) continue;
                    if (addName) {
                        addName = false;
                        ids.append(NEW_LINE).append(d.getFileName()).append(": ");
                        ids.append(v.getName());
                        continue;
                    }
                    ids.append(", ").append(v.getName());
                }
            }
            if (ids.length() > 0) {
                String msg = String.format("%n%nDependency-Check Failure:%nOne or more dependencies were identified with vulnerabilities that have a CVSS score greater then '%.1f': %s%nSee the dependency-check report for more details.%n%n", Float.valueOf(this.failBuildOnCVSS), ids.toString());
                throw new MojoFailureException(msg);
            }
        }
    }

    protected void showSummary(MavenProject mp, List<Dependency> dependencies) {
        if (this.showSummary) {
            StringBuilder summary = new StringBuilder();
            for (Dependency d : dependencies) {
                boolean firstEntry = true;
                StringBuilder ids = new StringBuilder();
                for (Vulnerability v : d.getVulnerabilities()) {
                    if (firstEntry) {
                        firstEntry = false;
                    } else {
                        ids.append(", ");
                    }
                    ids.append(v.getName());
                }
                if (ids.length() <= 0) continue;
                summary.append(d.getFileName()).append(" (");
                firstEntry = true;
                for (Identifier id : d.getIdentifiers()) {
                    if (firstEntry) {
                        firstEntry = false;
                    } else {
                        summary.append(", ");
                    }
                    summary.append(id.getValue());
                }
                summary.append(") : ").append((CharSequence)ids).append(NEW_LINE);
            }
            if (summary.length() > 0) {
                String msg = String.format("%n%nOne or more dependencies were identified with known vulnerabilities in %s:%n%n%s%n%nSee the dependency-check report for more details.%n%n", mp.getName(), summary.toString());
                this.getLog().warn((CharSequence)msg);
            }
        }
    }

    protected String getDataFileContextKey() {
        return "dependency-check-path-" + this.dataFileName;
    }

    protected String getOutputDirectoryContextKey() {
        return "dependency-output-dir-" + this.dataFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeDataFile(MavenProject mp, File writeTo, List<Dependency> dependencies) {
        if (mp.getContextValue(this.getDataFileContextKey()) == null) {
            File file;
            if (writeTo == null) {
                file = new File(mp.getBuild().getDirectory());
                file = new File(file, this.dataFileName);
            } else {
                file = new File(writeTo, this.dataFileName);
            }
            File parent = file.getParentFile();
            if (!parent.isDirectory() && parent.mkdirs()) {
                this.getLog().error((CharSequence)String.format("Directory '%s' does not exist and cannot be created; unable to write data file.", parent.getAbsolutePath()));
            }
            FileOutputStream os = null;
            OutputStream bos = null;
            ObjectOutputStream out = null;
            try {
                if (dependencies != null) {
                    os = new FileOutputStream(file);
                    bos = new BufferedOutputStream(os);
                    out = new ObjectOutputStream(bos);
                    out.writeObject(dependencies);
                    out.flush();
                    out.reset();
                }
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)String.format("Serialized data file written to '%s' for %s, referenced by key %s", file.getAbsolutePath(), mp.getName(), this.getDataFileContextKey()));
                }
                mp.setContextValue(this.getDataFileContextKey(), (Object)file.getAbsolutePath());
            }
            catch (IOException ex) {
                this.getLog().warn((CharSequence)"Unable to create data file used for report aggregation; if report aggregation is being used the results may be incomplete.");
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)ex.getMessage(), (Throwable)ex);
                }
            }
            finally {
                block36: {
                    block35: {
                        block34: {
                            if (out != null) {
                                try {
                                    out.close();
                                }
                                catch (IOException ex) {
                                    if (!this.getLog().isDebugEnabled()) break block34;
                                    this.getLog().debug((CharSequence)"ignore", (Throwable)ex);
                                }
                            }
                        }
                        if (bos != null) {
                            try {
                                bos.close();
                            }
                            catch (IOException ex) {
                                if (!this.getLog().isDebugEnabled()) break block35;
                                this.getLog().debug((CharSequence)"ignore", (Throwable)ex);
                            }
                        }
                    }
                    if (os != null) {
                        try {
                            ((OutputStream)os).close();
                        }
                        catch (IOException ex) {
                            if (!this.getLog().isDebugEnabled()) break block36;
                            this.getLog().debug((CharSequence)"ignore", (Throwable)ex);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Dependency> readDataFile(MavenProject project) {
        Object oPath = project.getContextValue(this.getDataFileContextKey());
        if (oPath == null) {
            return null;
        }
        List ret = null;
        String path = (String)oPath;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(path));
            ret = (List)ois.readObject();
        }
        catch (FileNotFoundException ex) {
            this.getLog().error((CharSequence)"", (Throwable)ex);
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)"", (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            this.getLog().error((CharSequence)"", (Throwable)ex);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException ex) {
                    this.getLog().error((CharSequence)"", (Throwable)ex);
                }
            }
        }
        return ret;
    }
}

