/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.DependencyBundlingAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.maven.BaseDependencyCheckMojo;
import org.owasp.dependencycheck.utils.Settings;

@Mojo(name="aggregate", defaultPhase=LifecyclePhase.SITE, aggregator=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresOnline=true)
public class AggregateMojo
extends BaseDependencyCheckMojo {
    private static final Logger LOGGER = Logger.getLogger(AggregateMojo.class.getName());

    @Override
    public void runCheck() throws MojoExecutionException, MojoFailureException {
        org.owasp.dependencycheck.maven.Engine engine = this.generateDataFile();
        if (this.getProject() == this.getReactorProjects().get(this.getReactorProjects().size() - 1)) {
            List<MavenProject> childProjects;
            List<Dependency> dependencies;
            Map<MavenProject, Set<MavenProject>> children = this.buildAggregateInfo();
            boolean hasOrchestration = false;
            for (MavenProject current : this.getReactorProjects()) {
                dependencies = this.readDataFile(current);
                childProjects = this.getAllChildren(current, children);
                if (dependencies != null && !dependencies.isEmpty() || !childProjects.isEmpty() || !current.isExecutionRoot()) continue;
                hasOrchestration = true;
            }
            for (MavenProject current : this.getReactorProjects()) {
                dependencies = this.readDataFile(current);
                childProjects = this.getAllChildren(current, children);
                if ((dependencies == null || dependencies.isEmpty()) && childProjects.isEmpty() && current.isExecutionRoot()) {
                    engine.resetFileTypeAnalyzers();
                    for (MavenProject mod : this.getReactorProjects()) {
                        this.scanArtifacts(mod, engine);
                    }
                    engine.analyzeDependencies();
                } else {
                    if (dependencies == null) {
                        dependencies = new ArrayList<Dependency>();
                    }
                    for (MavenProject reportOn : childProjects) {
                        List<Dependency> childDeps = this.readDataFile(reportOn);
                        if (childDeps == null || childDeps.isEmpty()) continue;
                        dependencies.addAll(childDeps);
                    }
                    engine.getDependencies().clear();
                    engine.getDependencies().addAll(dependencies);
                    DependencyBundlingAnalyzer bundler = new DependencyBundlingAnalyzer();
                    try {
                        bundler.analyze(null, (Engine)engine);
                    }
                    catch (AnalysisException ex) {
                        LOGGER.log(Level.WARNING, "An error occured grouping the dependencies; duplicate entries may exist in the report", ex);
                        LOGGER.log(Level.FINE, "Bundling Exception", ex);
                    }
                }
                try {
                    File outputDir = this.getCorrectOutputDirectory(current);
                    this.writeReports(engine, current, outputDir);
                }
                catch (MojoExecutionException ex) {
                    if (hasOrchestration) continue;
                    throw ex;
                }
            }
        }
        engine.cleanup();
        Settings.cleanup();
    }

    protected List<MavenProject> getAllChildren(MavenProject project, Map<MavenProject, Set<MavenProject>> childMap) {
        Set<MavenProject> children = childMap.get(project);
        if (children == null) {
            return Collections.emptyList();
        }
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        for (MavenProject child : children) {
            if (this.isMultiModule(child)) {
                result.addAll(this.getAllChildren(child, childMap));
                continue;
            }
            result.add(child);
        }
        return result;
    }

    protected boolean isMultiModule(MavenProject mavenProject) {
        return "pom".equals(mavenProject.getPackaging());
    }

    private Map<MavenProject, Set<MavenProject>> buildAggregateInfo() {
        HashMap<MavenProject, Set<MavenProject>> parentChildMap = new HashMap<MavenProject, Set<MavenProject>>();
        for (MavenProject proj : this.getReactorProjects()) {
            HashSet<MavenProject> depList = (HashSet<MavenProject>)parentChildMap.get(proj.getParent());
            if (depList == null) {
                depList = new HashSet<MavenProject>();
                parentChildMap.put(proj.getParent(), depList);
            }
            depList.add(proj);
        }
        return parentChildMap;
    }

    protected org.owasp.dependencycheck.maven.Engine generateDataFile() throws MojoExecutionException, MojoFailureException {
        org.owasp.dependencycheck.maven.Engine engine;
        try {
            engine = this.initializeEngine();
        }
        catch (DatabaseException ex) {
            LOGGER.log(Level.FINE, "Database connection error", ex);
            throw new MojoExecutionException("An exception occured connecting to the local database. Please see the log file for more details.", (Exception)((Object)ex));
        }
        this.scanArtifacts(this.getProject(), engine);
        engine.analyzeDependencies();
        this.writeDataFile(engine.getDependencies());
        this.showSummary(engine.getDependencies());
        this.checkForFailure(engine.getDependencies());
        return engine;
    }

    public boolean canGenerateReport() {
        return true;
    }

    public String getName(Locale locale) {
        return "dependency-check:aggregate";
    }

    public String getDescription(Locale locale) {
        return "Generates an aggregate report of all child Maven projects providing details on any published vulnerabilities within project dependencies. This report is a best effort and may contain false positives and false negatives.";
    }
}

